/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.server.recovery;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.retry.RetryNTimes;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.server.recovery.JsonMapper;
import org.apache.livy.server.recovery.JsonMapper$class;
import org.apache.livy.server.recovery.ZooKeeperManager$;
import org.apache.livy.utils.LivyUncaughtException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0001\u0003\u00015\u0011\u0001CW8p\u0017\u0016,\u0007/\u001a:NC:\fw-\u001a:\u000b\u0005\r!\u0011\u0001\u0003:fG>4XM]=\u000b\u0005\u00151\u0011AB:feZ,'O\u0003\u0002\b\u0011\u0005!A.\u001b<z\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0019!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u000b\u0015N|g.T1qa\u0016\u0014\bCA\r\u001b\u001b\u00051\u0011BA\u000e\u0007\u0005\u001daunZ4j]\u001eD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\tY&4\u0018pQ8oMB\u0011\u0011dH\u0005\u0003A\u0019\u0011\u0001\u0002T5ws\u000e{gN\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u0005\tRn\\2l\u0007V\u0014\u0018\r^8s\u00072LWM\u001c;\u0011\u0007=!c%\u0003\u0002&!\t1q\n\u001d;j_:\u0004\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\u0013\u0019\u0014\u0018-\\3x_J\\'BA\u0016\t\u0003\u001d\u0019WO]1u_JL!!\f\u0015\u0003!\r+(/\u0019;pe\u001a\u0013\u0018-\\3x_J\\\u0007\"B\u0018\u0001\t\u0003\u0001\u0014A\u0002\u001fj]&$h\bF\u00022eM\u0002\"!\u0006\u0001\t\u000buq\u0003\u0019\u0001\u0010\t\u000f\tr\u0003\u0013!a\u0001G!)q\u0006\u0001C\u0001kQ\u0011\u0011G\u000e\u0005\u0006;Q\u0002\rA\b\u0005\bq\u0001\u0011\r\u0011\"\u0003:\u0003%Q8.\u00113ee\u0016\u001c8/F\u0001;!\tY\u0004)D\u0001=\u0015\tid(\u0001\u0003mC:<'\"A \u0002\t)\fg/Y\u0005\u0003\u0003r\u0012aa\u0015;sS:<\u0007BB\"\u0001A\u0003%!(\u0001\u0006{W\u0006#GM]3tg\u0002Bq!\u0012\u0001C\u0002\u0013%\u0011(\u0001\u0006sKR\u0014\u0018PV1mk\u0016Daa\u0012\u0001!\u0002\u0013Q\u0014a\u0003:fiJLh+\u00197vK\u0002Bq!\u0013\u0001C\u0002\u0013%!*\u0001\u0007sKR\u0014\u0018\u0010U1ui\u0016\u0014h.F\u0001L!\ta\u0015+D\u0001N\u0015\tqu*\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\t\u0001\u0006#\u0001\u0003vi&d\u0017B\u0001*N\u0005\u0015\u0011VmZ3y\u0011\u0019!\u0006\u0001)A\u0005\u0017\u0006i!/\u001a;ssB\u000bG\u000f^3s]\u0002B\u0001B\u0016\u0001C\u0002\u0013\u0005!aV\u0001\fe\u0016$(/\u001f)pY&\u001c\u00170F\u0001Y!\tIF,D\u0001[\u0015\tY&&A\u0003sKR\u0014\u00180\u0003\u0002^5\nY!+\u001a;ss:#\u0016.\\3t\u0011\u0019y\u0006\u0001)A\u00051\u0006a!/\u001a;ssB{G.[2zA!9\u0011\r\u0001b\u0001\n\u0013\u0011\u0017!D2ve\u0006$xN]\"mS\u0016tG/F\u0001'\u0011\u0019!\u0007\u0001)A\u0005M\u0005q1-\u001e:bi>\u00148\t\\5f]R\u0004\u0003\"\u00024\u0001\t\u00039\u0017!B:uCJ$H#\u00015\u0011\u0005=I\u0017B\u00016\u0011\u0005\u0011)f.\u001b;\t\u000b1\u0004A\u0011A4\u0002\tM$x\u000e\u001d\u0005\u0006]\u0002!\ta\\\u0001\u0004g\u0016$Hc\u00015qq\")\u0011/\u001ca\u0001e\u0006\u00191.Z=\u0011\u0005M4hBA\bu\u0013\t)\b#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0003^T!!\u001e\t\t\u000bel\u0007\u0019\u0001>\u0002\u000bY\fG.^3\u0011\u0005mZ\u0018B\u0001?=\u0005\u0019y%M[3di\")a\u0010\u0001C\u0001\u007f\u0006\u0019q-\u001a;\u0016\t\u0005\u0005\u00111\u0002\u000b\u0005\u0003\u0007\ti\u0003\u0006\u0003\u0002\u0006\u0005u\u0001\u0003B\b%\u0003\u000f\u0001B!!\u0003\u0002\f1\u0001AaBA\u0007{\n\u0007\u0011q\u0002\u0002\u0002)F!\u0011\u0011CA\f!\ry\u00111C\u0005\u0004\u0003+\u0001\"a\u0002(pi\"Lgn\u001a\t\u0004\u001f\u0005e\u0011bAA\u000e!\t\u0019\u0011I\\=\t\u0013\u0005}Q0!AA\u0004\u0005\u0005\u0012AC3wS\u0012,gnY3%cA1\u00111EA\u0015\u0003\u000fi!!!\n\u000b\u0007\u0005\u001d\u0002#A\u0004sK\u001adWm\u0019;\n\t\u0005-\u0012Q\u0005\u0002\t\u00072\f7o\u001d+bO\")\u0011/ a\u0001e\"9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0012aC4fi\u000eC\u0017\u000e\u001c3sK:$B!!\u000e\u0002NA)\u0011qGA$e:!\u0011\u0011HA\"\u001d\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA \u0019\u00051AH]8pizJ\u0011!E\u0005\u0004\u0003\u000b\u0002\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u0013\nYEA\u0002TKFT1!!\u0012\u0011\u0011\u0019\t\u0018q\u0006a\u0001e\"9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0013A\u0002:f[>4X\rF\u0002i\u0003+Ba!]A(\u0001\u0004\u0011x!CA-\u0005\u0005\u0005\t\u0012AA.\u0003AQvn\\&fKB,'/T1oC\u001e,'\u000fE\u0002\u0016\u0003;2\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011qL\n\u0004\u0003;r\u0001bB\u0018\u0002^\u0011\u0005\u00111\r\u000b\u0003\u00037B!\"a\u001a\u0002^E\u0005I\u0011AA5\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u000e\u0016\u0004G\u000554FAA8!\u0011\t\t(a\u001f\u000e\u0005\u0005M$\u0002BA;\u0003o\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005e\u0004#\u0001\u0006b]:|G/\u0019;j_:LA!! \u0002t\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class ZooKeeperManager
implements JsonMapper,
Logging {
    public final LivyConf org$apache$livy$server$recovery$ZooKeeperManager$$livyConf;
    private final String org$apache$livy$server$recovery$ZooKeeperManager$$zkAddress;
    private final String retryValue;
    private final Regex retryPattern;
    private final RetryNTimes retryPolicy;
    private final CuratorFramework curatorClient;
    private final Logger logger;
    private final ObjectMapper mapper;
    private volatile boolean bitmap$0;

    public static Option<CuratorFramework> $lessinit$greater$default$2() {
        return ZooKeeperManager$.MODULE$.$lessinit$greater$default$2();
    }

    private Logger logger$lzycompute() {
        ZooKeeperManager zooKeeperManager = this;
        synchronized (zooKeeperManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    @Override
    public ObjectMapper mapper() {
        return this.mapper;
    }

    @Override
    public void org$apache$livy$server$recovery$JsonMapper$_setter_$mapper_$eq(ObjectMapper x$1) {
        this.mapper = x$1;
    }

    @Override
    public byte[] serializeToBytes(Object value) {
        return JsonMapper$class.serializeToBytes(this, value);
    }

    @Override
    public <T> T deserialize(byte[] json, ClassTag<T> evidence$1) {
        return (T)JsonMapper$class.deserialize(this, json, evidence$1);
    }

    public String org$apache$livy$server$recovery$ZooKeeperManager$$zkAddress() {
        return this.org$apache$livy$server$recovery$ZooKeeperManager$$zkAddress;
    }

    private String retryValue() {
        return this.retryValue;
    }

    private Regex retryPattern() {
        return this.retryPattern;
    }

    public RetryNTimes retryPolicy() {
        return this.retryPolicy;
    }

    private CuratorFramework curatorClient() {
        return this.curatorClient;
    }

    public void start() {
        this.curatorClient().start();
    }

    public void stop() {
        this.curatorClient().close();
    }

    public void set(String key, Object value) {
        byte[] data = this.serializeToBytes(value);
        if (this.curatorClient().checkExists().forPath(key) == null) {
            this.curatorClient().create().creatingParentsIfNeeded().forPath(key, data);
        } else {
            this.curatorClient().setData().forPath(key, data);
        }
    }

    public <T> Option<T> get(String key, ClassTag<T> evidence$1) {
        return this.curatorClient().checkExists().forPath(key) == null ? None$.MODULE$ : Option$.MODULE$.apply(this.deserialize((byte[])this.curatorClient().getData().forPath(key), evidence$1));
    }

    public Seq<String> getChildren(String key) {
        return this.curatorClient().checkExists().forPath(key) == null ? (Seq)Seq$.MODULE$.empty() : (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.curatorClient().getChildren().forPath(key)).asScala();
    }

    public void remove(String key) {
        try {
            this.curatorClient().delete().guaranteed().forPath(key);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            this.warn((Function0<Object>)new Serializable(this, key){
                public static final long serialVersionUID = 0L;
                private final String key$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fail to remove non-existed zookeeper node: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1}));
                }
                {
                    this.key$1 = key$1;
                }
            });
        }
    }

    public ZooKeeperManager(LivyConf livyConf, Option<CuratorFramework> mockCuratorClient) {
        this.org$apache$livy$server$recovery$ZooKeeperManager$$livyConf = livyConf;
        JsonMapper$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.org$apache$livy$server$recovery$ZooKeeperManager$$zkAddress = (String)Option$.MODULE$.apply((Object)livyConf.get(LivyConf$.MODULE$.ZOOKEEPER_URL())).orElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZooKeeperManager $outer;

            public final Option<String> apply() {
                return Option$.MODULE$.apply((Object)this.$outer.org$apache$livy$server$recovery$ZooKeeperManager$$livyConf.get(LivyConf$.MODULE$.RECOVERY_STATE_STORE_URL()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return x$1.trim();
            }
        }).orNull(Predef$.MODULE$.$conforms());
        Predef$.MODULE$.require(this.org$apache$livy$server$recovery$ZooKeeperManager$$zkAddress() != null && !this.org$apache$livy$server$recovery$ZooKeeperManager$$zkAddress().isEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please config ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LivyConf$.MODULE$.ZOOKEEPER_URL().key()}));
            }
        });
        this.retryValue = (String)Option$.MODULE$.apply((Object)livyConf.get(LivyConf$.MODULE$.ZK_RETRY_POLICY())).orElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZooKeeperManager $outer;

            public final Option<String> apply() {
                return Option$.MODULE$.apply((Object)this.$outer.org$apache$livy$server$recovery$ZooKeeperManager$$livyConf.get(LivyConf$.MODULE$.RECOVERY_ZK_STATE_STORE_RETRY_POLICY()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$2) {
                return x$2.trim();
            }
        }).orNull(Predef$.MODULE$.$conforms());
        Predef$.MODULE$.require(this.retryValue() != null && !this.retryValue().isEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please config ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LivyConf$.MODULE$.ZK_RETRY_POLICY().key()}));
            }
        });
        this.retryPattern = new StringOps(Predef$.MODULE$.augmentString("\\s*(\\d+)\\s*,\\s*(\\d+)\\s*")).r();
        String string = this.retryValue();
        Option option = this.retryPattern().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            RetryNTimes retryNTimes;
            String n = (String)((LinearSeqOptimized)option.get()).apply(0);
            String sleepMs = (String)((LinearSeqOptimized)option.get()).apply(1);
            this.retryPolicy = retryNTimes = new RetryNTimes(new StringOps(Predef$.MODULE$.augmentString(n)).toInt(), new StringOps(Predef$.MODULE$.augmentString(sleepMs)).toInt());
            this.curatorClient = (CuratorFramework)mockCuratorClient.getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ZooKeeperManager $outer;

                public final CuratorFramework apply() {
                    return CuratorFrameworkFactory.newClient((String)this.$outer.org$apache$livy$server$recovery$ZooKeeperManager$$zkAddress(), (RetryPolicy)this.$outer.retryPolicy());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.curatorClient().getUnhandledErrorListenable().addListener((Object)new UnhandledErrorListener(this){
                private final /* synthetic */ ZooKeeperManager $outer;

                public void unhandledError(String message, Throwable e) {
                    this.$outer.error((Function0<Object>)new Serializable(this, message){
                        public static final long serialVersionUID = 0L;
                        private final String message$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fatal Zookeeper error: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.message$1}));
                        }
                        {
                            this.message$1 = message$1;
                        }
                    }, e);
                    throw new LivyUncaughtException(e.getMessage());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"contains bad value: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.retryValue()}))).append((Object)"Correct format is <max retry count>,<sleep ms between retry>. e.g. 5,100").toString());
    }

    public ZooKeeperManager(LivyConf livyConf) {
        this(livyConf, (Option<CuratorFramework>)None$.MODULE$);
    }
}

