/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.session;

import java.util.Iterator;
import org.apache.livy.Job;
import org.apache.livy.JobContext;
import org.apache.livy.thriftserver.session.ScalaIterator;
import org.apache.livy.thriftserver.session.ThriftSessionState;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;

public class SqlJob
implements Job<Void> {
    private final String sessionId;
    private final String statementId;
    private final String statement;
    private final String defaultIncrementalCollect;
    private final String incrementalCollectEnabledProp;

    public SqlJob() {
        this(null, null, null, null, null);
    }

    public SqlJob(String sessionId, String statementId, String statement, String defaultIncrementalCollect, String incrementalCollectEnabledProp) {
        this.sessionId = sessionId;
        this.statementId = statementId;
        this.statement = statement;
        this.defaultIncrementalCollect = defaultIncrementalCollect;
        this.incrementalCollectEnabledProp = incrementalCollectEnabledProp;
    }

    public Void call(JobContext ctx) throws Exception {
        ctx.sc().setJobGroup(this.statementId, this.statement);
        try {
            this.executeSql(ctx);
        }
        finally {
            ctx.sc().clearJobGroup();
        }
        return null;
    }

    private void executeSql(JobContext ctx) throws Exception {
        ThriftSessionState session = ThriftSessionState.get(ctx, this.sessionId);
        SparkSession spark = session.spark();
        Dataset df = spark.sql(this.statement);
        StructType schema = df.schema();
        boolean incremental = Boolean.parseBoolean(spark.conf().get(this.incrementalCollectEnabledProp, this.defaultIncrementalCollect));
        Iterator<Object> iter = incremental ? new ScalaIterator(df.rdd().toLocalIterator()) : df.collectAsList().iterator();
        session.registerStatement(this.statementId, schema, iter);
    }
}

