/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.livy.Job;
import org.apache.livy.JobHandle;
import org.apache.livy.LivyClient;
import org.apache.livy.client.common.BufferUtils;
import org.apache.livy.rsc.BaseProtocol;
import org.apache.livy.rsc.BypassJobStatus;
import org.apache.livy.rsc.ContextInfo;
import org.apache.livy.rsc.FutureListener;
import org.apache.livy.rsc.JobHandleImpl;
import org.apache.livy.rsc.RSCConf;
import org.apache.livy.rsc.ReplJobResults;
import org.apache.livy.rsc.Utils;
import org.apache.livy.rsc.driver.AddFileJob;
import org.apache.livy.rsc.driver.AddJarJob;
import org.apache.livy.rsc.rpc.Rpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSCClient
implements LivyClient {
    private static final Logger LOG = LoggerFactory.getLogger(RSCClient.class);
    private static final AtomicInteger EXECUTOR_GROUP_ID = new AtomicInteger();
    private final RSCConf conf;
    private final Promise<ContextInfo> contextInfoPromise;
    private final Map<String, JobHandleImpl<?>> jobs;
    private final ClientProtocol protocol;
    private final Promise<Rpc> driverRpc;
    private final int executorGroupId;
    private final EventLoopGroup eventLoopGroup;
    private final Promise<URI> serverUriPromise;
    private ContextInfo contextInfo;
    private Process driverProcess;
    private volatile boolean isAlive;
    private volatile String replState;

    RSCClient(RSCConf conf, Promise<ContextInfo> ctx, Process driverProcess) throws IOException {
        this.conf = conf;
        this.contextInfoPromise = ctx;
        this.driverProcess = driverProcess;
        this.jobs = new ConcurrentHashMap();
        this.protocol = new ClientProtocol();
        this.driverRpc = ImmediateEventExecutor.INSTANCE.newPromise();
        this.executorGroupId = EXECUTOR_GROUP_ID.incrementAndGet();
        this.eventLoopGroup = new NioEventLoopGroup(conf.getInt(RSCConf.Entry.RPC_MAX_THREADS), Utils.newDaemonThreadFactory("RSCClient-" + this.executorGroupId + "-%d"));
        this.serverUriPromise = ImmediateEventExecutor.INSTANCE.newPromise();
        Utils.addListener(this.contextInfoPromise, new FutureListener<ContextInfo>(){

            @Override
            public void onSuccess(ContextInfo info) throws Exception {
                RSCClient.this.connectToContext(info);
                String url = String.format("rsc://%s:%s@%s:%d", info.clientId, info.secret, info.remoteAddress, info.remotePort);
                RSCClient.this.serverUriPromise.setSuccess((Object)URI.create(url));
            }

            @Override
            public void onFailure(Throwable error) {
                RSCClient.this.connectionError(error);
                RSCClient.this.serverUriPromise.setFailure(error);
            }
        });
        this.isAlive = true;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public Process getDriverProcess() {
        return this.driverProcess;
    }

    private synchronized void connectToContext(final ContextInfo info) throws Exception {
        this.contextInfo = info;
        try {
            Promise<Rpc> promise = Rpc.createClient(this.conf, this.eventLoopGroup, info.remoteAddress, info.remotePort, info.clientId, info.secret, this.protocol);
            Utils.addListener(promise, new FutureListener<Rpc>(){

                @Override
                public void onSuccess(Rpc rpc) throws Exception {
                    RSCClient.this.driverRpc.setSuccess((Object)rpc);
                    Utils.addListener(rpc.getChannel().closeFuture(), new FutureListener<Void>(){

                        @Override
                        public void onSuccess(Void unused) {
                            if (RSCClient.this.isAlive) {
                                LOG.warn("Client RPC channel closed unexpectedly.");
                                try {
                                    RSCClient.this.stop(false);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                    LOG.debug("Connected to context {} ({}, {}).", new Object[]{info.clientId, rpc.getChannel(), RSCClient.this.executorGroupId});
                }

                @Override
                public void onFailure(Throwable error) throws Exception {
                    RSCClient.this.driverRpc.setFailure(error);
                    RSCClient.this.connectionError(error);
                }
            });
        }
        catch (Exception e) {
            this.connectionError(e);
        }
    }

    private void connectionError(Throwable error) {
        LOG.error("Failed to connect to context.", error);
        try {
            this.stop(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private <T> Future<T> deferredCall(final Object msg, final Class<T> retType) {
        if (this.driverRpc.isSuccess()) {
            try {
                return ((Rpc)this.driverRpc.get()).call(msg, retType);
            }
            catch (Exception ie) {
                throw Utils.propagate(ie);
            }
        }
        final Promise promise = this.eventLoopGroup.next().newPromise();
        final FutureListener callListener = new FutureListener<T>(){

            @Override
            public void onSuccess(T value) throws Exception {
                promise.setSuccess(value);
            }

            @Override
            public void onFailure(Throwable error) throws Exception {
                promise.setFailure(error);
            }
        };
        Utils.addListener(this.driverRpc, new FutureListener<Rpc>(){

            @Override
            public void onSuccess(Rpc rpc) throws Exception {
                Utils.addListener(rpc.call(msg, retType), callListener);
            }

            @Override
            public void onFailure(Throwable error) throws Exception {
                promise.setFailure(error);
            }
        });
        return promise;
    }

    public java.util.concurrent.Future<URI> getServerUri() {
        return this.serverUriPromise;
    }

    public <T> JobHandle<T> submit(Job<T> job) {
        return this.protocol.submit(job);
    }

    public <T> java.util.concurrent.Future<T> run(Job<T> job) {
        return this.protocol.run(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(boolean shutdownContext) {
        if (this.isAlive) {
            this.isAlive = false;
            try {
                this.contextInfoPromise.cancel(true);
                if (shutdownContext && this.driverRpc.isSuccess()) {
                    this.protocol.endSession();
                    long stopTimeout = this.conf.getTimeAsMs(RSCConf.Entry.CLIENT_SHUTDOWN_TIMEOUT);
                    ((Rpc)this.driverRpc.get()).getChannel().closeFuture().get(stopTimeout, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e) {
                LOG.warn("Exception while waiting for end session reply.", (Throwable)e);
                Utils.propagate(e);
            }
            finally {
                if (this.driverRpc.isSuccess()) {
                    try {
                        ((Rpc)this.driverRpc.get()).close();
                    }
                    catch (Exception e) {
                        LOG.warn("Error stopping RPC.", (Throwable)e);
                    }
                }
                for (Map.Entry<String, JobHandleImpl<?>> e : this.jobs.entrySet()) {
                    LOG.info("Failing pending job {} due to shutdown.", (Object)e.getKey());
                    e.getValue().setFailure(new IOException("RSCClient instance stopped."));
                }
                this.eventLoopGroup.shutdownGracefully();
            }
            if (this.contextInfo != null) {
                LOG.debug("Disconnected from context {}, shutdown = {}.", (Object)this.contextInfo.clientId, (Object)shutdownContext);
            }
        }
    }

    public java.util.concurrent.Future<?> uploadJar(File jar) {
        throw new UnsupportedOperationException("Use addJar to add the jar to the remote context!");
    }

    public java.util.concurrent.Future<?> addJar(URI uri) {
        return this.submit(new AddJarJob(uri.toString()));
    }

    public java.util.concurrent.Future<?> uploadFile(File file) {
        throw new UnsupportedOperationException("Use addFile to add the file to the remote context!");
    }

    public java.util.concurrent.Future<?> addFile(URI uri) {
        return this.submit(new AddFileJob(uri.toString()));
    }

    public String bypass(ByteBuffer serializedJob, String jobType, boolean sync) {
        return this.protocol.bypass(serializedJob, jobType, sync);
    }

    public java.util.concurrent.Future<BypassJobStatus> getBypassJobStatus(String id) {
        return this.protocol.getBypassJobStatus(id);
    }

    public void cancel(String jobId) {
        this.protocol.cancel(jobId);
    }

    ContextInfo getContextInfo() {
        return this.contextInfo;
    }

    public java.util.concurrent.Future<Integer> submitReplCode(String code, String codeType) throws Exception {
        return this.deferredCall(new BaseProtocol.ReplJobRequest(code, codeType), Integer.class);
    }

    public void cancelReplCode(int statementId) throws Exception {
        this.deferredCall(new BaseProtocol.CancelReplJobRequest(statementId), Void.class);
    }

    public java.util.concurrent.Future<ReplJobResults> getReplJobResults(Integer from, Integer size) throws Exception {
        return this.deferredCall(new BaseProtocol.GetReplJobResults(from, size), ReplJobResults.class);
    }

    public java.util.concurrent.Future<ReplJobResults> getReplJobResults() throws Exception {
        return this.deferredCall(new BaseProtocol.GetReplJobResults(), ReplJobResults.class);
    }

    public java.util.concurrent.Future<String[]> completeReplCode(String code, String codeType, int cursor) throws Exception {
        return this.deferredCall(new BaseProtocol.ReplCompleteRequest(code, codeType, cursor), String[].class);
    }

    public String getReplState() {
        return this.replState;
    }

    private class ClientProtocol
    extends BaseProtocol {
        private ClientProtocol() {
        }

        <T> JobHandleImpl<T> submit(Job<T> job) {
            final String jobId = UUID.randomUUID().toString();
            BaseProtocol.JobRequest<T> msg = new BaseProtocol.JobRequest<T>(jobId, job);
            final Promise promise = RSCClient.this.eventLoopGroup.next().newPromise();
            final JobHandleImpl handle = new JobHandleImpl(RSCClient.this, promise, jobId);
            RSCClient.this.jobs.put(jobId, handle);
            final Future rpc = RSCClient.this.deferredCall(msg, Void.class);
            LOG.debug("Sending JobRequest[{}].", (Object)jobId);
            Utils.addListener(rpc, new FutureListener<Void>(){

                @Override
                public void onSuccess(Void unused) throws Exception {
                    handle.changeState(JobHandle.State.QUEUED);
                }

                @Override
                public void onFailure(Throwable error) throws Exception {
                    LOG.error("RPC error.", error);
                    promise.tryFailure(error);
                }
            });
            promise.addListener(new GenericFutureListener<Promise<T>>(){

                public void operationComplete(Promise<T> p) {
                    if (jobId != null) {
                        RSCClient.this.jobs.remove(jobId);
                    }
                    if (p.isCancelled() && !rpc.isDone()) {
                        rpc.cancel(true);
                    }
                }
            });
            return handle;
        }

        <T> java.util.concurrent.Future<T> run(Job<T> job) {
            return RSCClient.this.deferredCall(new BaseProtocol.SyncJobRequest<T>(job), Object.class);
        }

        String bypass(ByteBuffer serializedJob, String jobType, boolean sync) {
            String jobId = UUID.randomUUID().toString();
            BaseProtocol.BypassJobRequest msg = new BaseProtocol.BypassJobRequest(jobId, jobType, BufferUtils.toByteArray((ByteBuffer)serializedJob), sync);
            RSCClient.this.deferredCall(msg, Void.class);
            return jobId;
        }

        java.util.concurrent.Future<BypassJobStatus> getBypassJobStatus(String id) {
            return RSCClient.this.deferredCall(new BaseProtocol.GetBypassJobStatus(id), BypassJobStatus.class);
        }

        void cancel(String jobId) {
            RSCClient.this.deferredCall(new BaseProtocol.CancelJob(jobId), Void.class);
        }

        java.util.concurrent.Future<?> endSession() {
            return RSCClient.this.deferredCall(new BaseProtocol.EndSession(), Void.class);
        }

        private void handle(ChannelHandlerContext ctx, BaseProtocol.InitializationError msg) {
            LOG.warn("Error reported from remote driver: %s", (Object)msg.stackTrace);
        }

        private void handle(ChannelHandlerContext ctx, BaseProtocol.JobResult msg) {
            JobHandleImpl handle = (JobHandleImpl)((Object)RSCClient.this.jobs.remove(msg.id));
            if (handle != null) {
                RuntimeException error;
                LOG.info("Received result for {}", (Object)msg.id);
                RuntimeException runtimeException = error = msg.error != null ? new RuntimeException(msg.error) : null;
                if (error == null) {
                    handle.setSuccess(msg.result);
                } else {
                    handle.setFailure(error);
                }
            } else {
                LOG.warn("Received result for unknown job {}", (Object)msg.id);
            }
        }

        private void handle(ChannelHandlerContext ctx, BaseProtocol.JobStarted msg) {
            JobHandleImpl handle = (JobHandleImpl)((Object)RSCClient.this.jobs.get(msg.id));
            if (handle != null) {
                handle.changeState(JobHandle.State.STARTED);
            } else {
                LOG.warn("Received event for unknown job {}", (Object)msg.id);
            }
        }

        private void handle(ChannelHandlerContext ctx, BaseProtocol.ReplState msg) {
            LOG.trace("Received repl state for {}", (Object)msg.state);
            RSCClient.this.replState = msg.state;
        }
    }
}

