/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simpleflatmapper.map.ConsumerErrorHandler;
import org.simpleflatmapper.map.ContextualSourceFieldMapper;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.SetRowMapper;
import org.simpleflatmapper.map.context.KeySourceGetter;
import org.simpleflatmapper.map.context.MappingContextFactory;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.impl.DiscriminatorReflectionService;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.ConstantSourceMapperBuilder;
import org.simpleflatmapper.map.mapper.ContextualSourceFieldMapperImpl;
import org.simpleflatmapper.map.mapper.KeyFactory;
import org.simpleflatmapper.map.mapper.MapperSource;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.mapper.SetRowMapperBuilder;
import org.simpleflatmapper.map.mapper.TransformSourceFieldMapper;
import org.simpleflatmapper.map.property.IgnoreRowIfNullProperty;
import org.simpleflatmapper.reflect.ClassMetaWithDiscriminatorId;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.util.Enumerable;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.ForEachCallBack;
import org.simpleflatmapper.util.Function;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.PredicatedEnumerable;
import org.simpleflatmapper.util.TypeHelper;
import org.simpleflatmapper.util.UnaryFactory;

public class SetRowMapperBuilderImpl<M extends SetRowMapper<ROW, SET, T, E>, ROW, SET, T, K extends FieldKey<K>, E extends Exception>
implements SetRowMapperBuilder<M, ROW, SET, T, K, E> {
    private final ConstantSourceMapperBuilder<ROW, T, K> constantSourceMapperBuilder;
    protected final MapperConfig<K, ROW> mapperConfig;
    protected final MappingContextFactoryBuilder<? super ROW, K> mappingContextFactoryBuilder;
    private final UnaryFactory<SET, Enumerable<ROW>> enumerableFactory;
    private final SetRowMapperFactory<M, ROW, SET, T, E> setRowMapperFactory;
    private final KeySourceGetter<K, ? super ROW> keySourceGetter;

    public SetRowMapperBuilderImpl(ClassMeta<T> classMeta, MappingContextFactoryBuilder<ROW, K> parentBuilder, MapperConfig<K, ROW> mapperConfig, MapperSource<? super ROW, K> mapperSource, KeyFactory<K> keyFactory, UnaryFactory<SET, Enumerable<ROW>> enumerableFactory, SetRowMapperFactory<M, ROW, SET, T, E> setRowMapperFactory, KeySourceGetter<K, ? super ROW> keySourceGetter) {
        this.setRowMapperFactory = setRowMapperFactory;
        this.enumerableFactory = enumerableFactory;
        this.keySourceGetter = keySourceGetter;
        this.constantSourceMapperBuilder = ConstantSourceMapperBuilder.newConstantSourceMapperBuilder(mapperSource, this.prepareClassMetaForDiscriminator(classMeta, mapperConfig), mapperConfig, parentBuilder, keyFactory);
        this.mapperConfig = mapperConfig;
        this.mappingContextFactoryBuilder = parentBuilder;
    }

    private ClassMeta<T> prepareClassMetaForDiscriminator(ClassMeta<T> classMeta, MapperConfig<K, ROW> mapperConfig) {
        List<MapperConfig.Discriminator<ROW, K, ?>> discriminators = mapperConfig.getDiscriminators();
        if (discriminators.isEmpty()) {
            return classMeta;
        }
        HashMap discriminatorMap = new HashMap();
        for (MapperConfig.Discriminator<ROW, K, ?> d : discriminators) {
            Class clazz = TypeHelper.toClass((Type)d.type);
            ArrayList<ClassMetaWithDiscriminatorId> implementations = (ArrayList<ClassMetaWithDiscriminatorId>)discriminatorMap.get(clazz);
            if (implementations == null) {
                implementations = new ArrayList<ClassMetaWithDiscriminatorId>();
                discriminatorMap.put(clazz, implementations);
            }
            for (MapperConfig.DiscriminatorCase dc : d.cases) {
                implementations.add(new ClassMetaWithDiscriminatorId(dc.classMeta, d.discriminatorId));
            }
        }
        DiscriminatorReflectionService dfs = new DiscriminatorReflectionService(classMeta.getReflectionService(), discriminatorMap);
        return classMeta.withReflectionService((ReflectionService)dfs);
    }

    @Override
    public final M mapper() {
        ContextualSourceFieldMapper mapper = this.sourceFieldMapper();
        if (((ContextualSourceFieldMapperImpl)mapper).getDelegate() instanceof TransformSourceFieldMapper) {
            TransformSourceFieldMapper transformSourceFieldMapper = (TransformSourceFieldMapper)((ContextualSourceFieldMapperImpl)mapper).getDelegate();
            ContextualSourceFieldMapperImpl unwrappedMapper = new ContextualSourceFieldMapperImpl(((ContextualSourceFieldMapperImpl)mapper).getMappingContextFactory(), transformSourceFieldMapper.delegate);
            M m = this.constantSourceMapperBuilder.isRootAggregate() ? this.setRowMapperFactory.newTransformer(this.setRowMapperFactory.newJoinMapper(unwrappedMapper, this.mapperConfig.consumerErrorHandler(), this.mappingContextFactoryBuilder.build(), this.enumerableFactory()), transformSourceFieldMapper.transform) : this.setRowMapperFactory.newTransformer(this.setRowMapperFactory.newStaticMapper(unwrappedMapper, this.mapperConfig.consumerErrorHandler(), this.mappingContextFactoryBuilder.build(), this.enumerableFactory()), transformSourceFieldMapper.transform);
            return m;
        }
        M m = this.constantSourceMapperBuilder.isRootAggregate() ? (this.mapperConfig.unorderedJoin() ? this.setRowMapperFactory.newUnorderedJoinMapper(mapper, this.mapperConfig.consumerErrorHandler(), (MappingContextFactory<ROW>)this.mappingContextFactoryBuilder.build(), this.enumerableFactory()) : this.setRowMapperFactory.newJoinMapper(mapper, this.mapperConfig.consumerErrorHandler(), (MappingContextFactory<ROW>)this.mappingContextFactoryBuilder.build(), this.enumerableFactory())) : this.setRowMapperFactory.newStaticMapper(mapper, this.mapperConfig.consumerErrorHandler(), (MappingContextFactory<ROW>)this.mappingContextFactoryBuilder.build(), this.enumerableFactory());
        return m;
    }

    private UnaryFactory<SET, Enumerable<ROW>> enumerableFactory() {
        final Predicate<ROW> filter = this.getRowPredicate();
        if (filter != null) {
            return new UnaryFactory<SET, Enumerable<ROW>>(){

                public Enumerable<ROW> newInstance(SET set) {
                    return new PredicatedEnumerable((Enumerable)SetRowMapperBuilderImpl.this.enumerableFactory.newInstance(set), filter);
                }
            };
        }
        return this.enumerableFactory;
    }

    private Predicate<ROW> getRowPredicate() {
        Set mandatoryKeys = this.constantSourceMapperBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, K>>(){
            Set<K> mandatoryKeys = new HashSet();

            public void handle(PropertyMapping<T, ?, K> tkPropertyMapping) {
                if (tkPropertyMapping.getColumnDefinition().has(IgnoreRowIfNullProperty.class)) {
                    this.mandatoryKeys.add(tkPropertyMapping.getColumnKey());
                }
            }
        }).mandatoryKeys;
        if (mandatoryKeys.isEmpty()) {
            return null;
        }
        final FieldKey[] keys = (FieldKey[])Array.newInstance(((FieldKey)mandatoryKeys.iterator().next()).getClass(), mandatoryKeys.size());
        int i = 0;
        for (FieldKey k : mandatoryKeys) {
            keys[i++] = k;
        }
        return new Predicate<ROW>(){

            public boolean test(ROW row) {
                for (FieldKey k : keys) {
                    try {
                        if (SetRowMapperBuilderImpl.this.keySourceGetter.getValue(k, row) != null) continue;
                        return false;
                    }
                    catch (Exception e) {
                        ErrorHelper.rethrow((Throwable)e);
                    }
                }
                return true;
            }
        };
    }

    @Override
    public final ContextualSourceFieldMapperImpl<ROW, T> sourceFieldMapper() {
        return this.constantSourceMapperBuilder.mapper();
    }

    @Override
    public boolean isRootAggregate() {
        return this.constantSourceMapperBuilder.isRootAggregate();
    }

    @Override
    public final void addMapper(FieldMapper<ROW, T> mapper) {
        this.constantSourceMapperBuilder.addMapper(mapper);
    }

    @Override
    public final void addMapping(K key, ColumnDefinition<K, ?> columnDefinition) {
        this.constantSourceMapperBuilder.addMapping(key, columnDefinition);
    }

    @Override
    public MapperConfig<K, ROW> mapperConfig() {
        return this.mapperConfig;
    }

    @Override
    public MappingContextFactoryBuilder<? super ROW, K> getMappingContextFactoryBuilder() {
        return this.mappingContextFactoryBuilder;
    }

    @Override
    public List<K> getKeys() {
        return this.constantSourceMapperBuilder.getKeys();
    }

    public static interface SetRowMapperFactory<M extends SetRowMapper<ROW, SET, T, E>, ROW, SET, T, E extends Exception> {
        public M newJoinMapper(ContextualSourceFieldMapper<ROW, T> var1, ConsumerErrorHandler var2, MappingContextFactory<? super ROW> var3, UnaryFactory<SET, Enumerable<ROW>> var4);

        public M newUnorderedJoinMapper(ContextualSourceFieldMapper<ROW, T> var1, ConsumerErrorHandler var2, MappingContextFactory<? super ROW> var3, UnaryFactory<SET, Enumerable<ROW>> var4);

        public M newStaticMapper(ContextualSourceFieldMapper<ROW, T> var1, ConsumerErrorHandler var2, MappingContextFactory<? super ROW> var3, UnaryFactory<SET, Enumerable<ROW>> var4);

        public <I> M newTransformer(SetRowMapper<ROW, SET, I, E> var1, Function<I, T> var2);
    }
}

