/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.http;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.codec.Serializer;
import com.alipay.sofa.rpc.codec.SerializerFactory;
import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.common.utils.ClassLoaderUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.exception.SofaTimeOutException;
import com.alipay.sofa.rpc.core.invoke.SofaResponseCallback;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.event.ClientAfterSendEvent;
import com.alipay.sofa.rpc.event.ClientBeforeSendEvent;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.message.ResponseFuture;
import com.alipay.sofa.rpc.message.http.HttpResponseFuture;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.AbstractChannel;
import com.alipay.sofa.rpc.transport.ClientHandler;
import com.alipay.sofa.rpc.transport.ClientTransport;
import com.alipay.sofa.rpc.transport.ClientTransportConfig;
import com.alipay.sofa.rpc.transport.http.AbstractHttpClientHandler;
import com.alipay.sofa.rpc.transport.http.CallbackInvokeClientHandler;
import com.alipay.sofa.rpc.transport.http.FutureInvokeClientHandler;
import com.alipay.sofa.rpc.transport.http.Http2ClientChannelHandler;
import com.alipay.sofa.rpc.transport.http.Http2ClientInitializer;
import com.alipay.sofa.rpc.transport.http.Http2SettingsHandler;
import com.alipay.sofa.rpc.transport.http.SslContextBuilder;
import com.alipay.sofa.rpc.transport.http.SyncInvokeClientHandler;
import com.alipay.sofa.rpc.transport.netty.NettyChannel;
import com.alipay.sofa.rpc.transport.netty.NettyHelper;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractHttp2ClientTransport
extends ClientTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHttp2ClientTransport.class);
    protected final ProviderInfo providerInfo;
    private static final int START_STREAM_ID = 3;
    protected final AtomicInteger streamId = new AtomicInteger();
    protected volatile AtomicInteger currentRequests = new AtomicInteger(0);
    protected NettyChannel channel;
    protected Http2ClientChannelHandler responseChannelHandler;
    private static final Timer TIMEOUT_TIMER = new HashedWheelTimer((ThreadFactory)new NamedThreadFactory("HTTP-TIMER"), 10L, TimeUnit.MILLISECONDS);

    public AbstractHttp2ClientTransport(ClientTransportConfig transportConfig) {
        super(transportConfig);
        this.providerInfo = transportConfig.getProviderInfo();
    }

    @Override
    public void connect() {
        if (this.isAvailable()) {
            return;
        }
        EventLoopGroup workerGroup = NettyHelper.getClientIOEventLoopGroup();
        Http2ClientInitializer initializer = new Http2ClientInitializer(this.transportConfig);
        try {
            String host = this.providerInfo.getHost();
            int port = this.providerInfo.getPort();
            Bootstrap b = new Bootstrap();
            b.group(workerGroup);
            b.channel(this.transportConfig.isUseEpoll() ? EpollSocketChannel.class : NioSocketChannel.class);
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            b.remoteAddress(host, port);
            b.handler((ChannelHandler)initializer);
            Channel channel = b.connect().syncUninterruptibly().channel();
            this.channel = new NettyChannel(channel);
            Http2SettingsHandler http2SettingsHandler = initializer.settingsHandler();
            http2SettingsHandler.awaitSettings(this.transportConfig.getConnectTimeout(), TimeUnit.MILLISECONDS);
            this.responseChannelHandler = initializer.responseHandler();
            this.streamId.set(3);
        }
        catch (Exception e) {
            throw new SofaRpcException(250, (Throwable)e);
        }
    }

    @Override
    public void disconnect() {
        Channel nettyChannel;
        if (this.channel != null && (nettyChannel = this.channel.channel()) != null) {
            nettyChannel.close().syncUninterruptibly();
        }
    }

    @Override
    public void destroy() {
        NettyHelper.closeClientIOEventGroup();
    }

    @Override
    public boolean isAvailable() {
        return this.channel != null && this.channel.isAvailable();
    }

    @Override
    public void setChannel(AbstractChannel channel) {
        this.channel = (NettyChannel)channel;
    }

    @Override
    public AbstractChannel getChannel() {
        return this.channel;
    }

    @Override
    public int currentRequests() {
        return this.currentRequests.get();
    }

    @Override
    public ResponseFuture asyncSend(SofaRequest request, int timeout) throws SofaRpcException {
        this.checkConnection();
        RpcInternalContext context = RpcInternalContext.getContext();
        try {
            this.beforeSend(context, request);
            ResponseFuture responseFuture = this.doInvokeAsync(request, context, timeout);
            return responseFuture;
        }
        catch (SofaRpcException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SofaRpcException(299, e.getMessage(), e);
        }
        finally {
            this.afterSend(context, request);
        }
    }

    protected ResponseFuture doInvokeAsync(SofaRequest request, RpcInternalContext rpcContext, int timeoutMillis) {
        SofaResponseCallback listener = request.getSofaResponseCallback();
        if (listener != null) {
            CallbackInvokeClientHandler callback = new CallbackInvokeClientHandler(this.transportConfig.getConsumerConfig(), this.transportConfig.getProviderInfo(), listener, request, rpcContext, ClassLoaderUtils.getCurrentClassLoader());
            this.doSend(request, callback, timeoutMillis);
            return null;
        }
        HttpResponseFuture future = new HttpResponseFuture(request, timeoutMillis);
        FutureInvokeClientHandler callback = new FutureInvokeClientHandler(this.transportConfig.getConsumerConfig(), this.transportConfig.getProviderInfo(), future, request, rpcContext, ClassLoaderUtils.getCurrentClassLoader());
        this.doSend(request, callback, timeoutMillis);
        future.setSentTime();
        return future;
    }

    @Override
    public SofaResponse syncSend(SofaRequest request, int timeout) throws SofaRpcException {
        this.checkConnection();
        RpcInternalContext context = RpcInternalContext.getContext();
        try {
            this.beforeSend(context, request);
            SofaResponse sofaResponse = this.doInvokeSync(request, timeout);
            return sofaResponse;
        }
        catch (TimeoutException e) {
            throw this.timeoutException(request, timeout, e);
        }
        catch (SofaRpcException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SofaRpcException(299, e.getMessage(), e);
        }
        finally {
            this.afterSend(context, request);
        }
    }

    protected SofaResponse doInvokeSync(SofaRequest request, int timeout) throws InterruptedException, ExecutionException, TimeoutException {
        HttpResponseFuture future = new HttpResponseFuture(request, timeout);
        SyncInvokeClientHandler callback = new SyncInvokeClientHandler(this.transportConfig.getConsumerConfig(), this.transportConfig.getProviderInfo(), future, request, RpcInternalContext.getContext(), ClassLoaderUtils.getCurrentClassLoader());
        future.setSentTime();
        this.doSend(request, callback, timeout);
        future.setSentTime();
        return future.getSofaResponse(timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(final SofaRequest request, AbstractHttpClientHandler callback, final int timeoutMills) {
        AbstractByteBuf data = null;
        try {
            byte serializeType = request.getSerializeType();
            Serializer serializer = SerializerFactory.getSerializer(serializeType);
            data = serializer.encode(request, null);
            request.setData(data);
            RpcInternalContext.getContext().setAttachment("_req_size", data.readableBytes());
            FullHttpRequest httpRequest = this.convertToHttpRequest(request);
            final int requestId = this.sendHttpRequest(httpRequest, callback);
            if (request.isAsync()) {
                TIMEOUT_TIMER.newTimeout(new TimerTask(){

                    public void run(Timeout timeout) throws Exception {
                        Map.Entry<ChannelFuture, AbstractHttpClientHandler> entry = AbstractHttp2ClientTransport.this.responseChannelHandler.removePromise(requestId);
                        if (entry != null) {
                            ClientHandler handler = entry.getValue();
                            SofaTimeOutException e = AbstractHttp2ClientTransport.this.timeoutException(request, timeoutMills, null);
                            handler.onException(e);
                        }
                    }
                }, (long)timeoutMills, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            if (data != null) {
                data.release();
            }
        }
    }

    protected FullHttpRequest convertToHttpRequest(SofaRequest request) {
        HttpScheme scheme = SslContextBuilder.SSL ? HttpScheme.HTTPS : HttpScheme.HTTP;
        AsciiString hostName = new AsciiString((CharSequence)(this.providerInfo.getHost() + ':' + this.providerInfo.getPort()));
        String url = "/" + request.getTargetServiceUniqueName() + "/" + request.getMethodName();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("send request to url :{}", url);
        }
        DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, url, Unpooled.wrappedBuffer((byte[])request.getData().array()));
        HttpHeaders headers = httpRequest.headers();
        this.addToHeader(headers, (CharSequence)HttpHeaderNames.HOST, (CharSequence)hostName);
        this.addToHeader(headers, (CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (CharSequence)scheme.name());
        this.addToHeader(headers, (CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (CharSequence)HttpHeaderValues.GZIP);
        this.addToHeader(headers, (CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (CharSequence)HttpHeaderValues.DEFLATE);
        this.addToHeader(headers, "sofa_head_serialize_type", SerializerFactory.getAliasByCode(request.getSerializeType()));
        this.addToHeader(headers, "sofa_head_target_app", request.getTargetAppName());
        Map<String, Object> requestProps = request.getRequestProps();
        if (requestProps != null) {
            this.flatCopyTo("", requestProps, headers);
        }
        return httpRequest;
    }

    protected int sendHttpRequest(FullHttpRequest httpRequest, AbstractHttpClientHandler callback) {
        int requestId = this.streamId.getAndAdd(2);
        Channel channel = this.channel.channel();
        this.responseChannelHandler.put(requestId, channel.write((Object)httpRequest), callback);
        channel.flush();
        return requestId;
    }

    @Override
    public void oneWaySend(SofaRequest request, int timeout) throws SofaRpcException {
        throw new UnsupportedOperationException();
    }

    protected void beforeSend(RpcInternalContext context, SofaRequest request) {
        this.currentRequests.incrementAndGet();
        context.getStopWatch().tick().read();
        context.setLocalAddress(this.localAddress());
        if (EventBus.isEnable(ClientBeforeSendEvent.class)) {
            EventBus.post(new ClientBeforeSendEvent(request));
        }
    }

    protected void afterSend(RpcInternalContext context, SofaRequest request) {
        this.currentRequests.decrementAndGet();
        int cost = context.getStopWatch().tick().read();
        context.setAttachment("_req_ser_time", cost);
        if (EventBus.isEnable(ClientAfterSendEvent.class)) {
            EventBus.post(new ClientAfterSendEvent(request));
        }
    }

    @Override
    public void receiveRpcResponse(SofaResponse response) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleRpcRequest(SofaRequest request) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return this.channel == null ? null : this.channel.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return this.channel == null ? null : this.channel.localAddress();
    }

    protected void checkConnection() throws SofaRpcException {
        if (!this.isAvailable()) {
            throw new SofaRpcException(250, "channel is not available");
        }
    }

    protected SofaTimeOutException timeoutException(SofaRequest request, int timeout, Throwable e) {
        return new SofaTimeOutException(LogCodes.getLog("020100005", this.providerInfo.getProtocolType(), request.getTargetServiceUniqueName(), request.getMethodName(), this.providerInfo.toString(), StringUtils.objectsToString(request.getMethodArgs()), timeout), e);
    }

    protected void flatCopyTo(String prefix, Map<String, Object> sourceMap, HttpHeaders headers) {
        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
            String key = prefix + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                this.addToHeader(headers, key, (CharSequence)value);
                continue;
            }
            if (value instanceof Number) {
                this.addToHeader(headers, key, value.toString());
                continue;
            }
            if (!(value instanceof Map)) continue;
            this.flatCopyTo(key + ".", (Map)value, headers);
        }
    }

    private void addToHeader(HttpHeaders headers, CharSequence key, CharSequence value) {
        if (StringUtils.isNotEmpty(value)) {
            headers.add(key, (Object)value);
        }
    }
}

