/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.triple;

import com.alipay.sofa.rpc.codec.Serializer;
import com.alipay.sofa.rpc.codec.SerializerFactory;
import com.alipay.sofa.rpc.common.utils.ClassTypeUtils;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.tracer.sofatracer.TracingContextKey;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteArrayWrapperByteBuf;
import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import io.grpc.Context;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.Method;
import java.util.List;
import triple.Request;
import triple.Response;
import triple.SofaGenericServiceTriple;

public class GenericServiceImpl
extends SofaGenericServiceTriple.GenericServiceImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericServiceImpl.class);
    protected Object ref;
    protected Class proxyClass;

    public GenericServiceImpl(ProviderConfig providerConfig) {
        this.ref = providerConfig.getRef();
        this.proxyClass = providerConfig.getProxyClass();
    }

    public GenericServiceImpl(Object ref, Class proxyClass) {
        this.ref = ref;
        this.proxyClass = proxyClass;
    }

    @Override
    public void generic(Request request, StreamObserver<Response> responseObserver) {
        SofaRequest sofaRequest = (SofaRequest)TracingContextKey.getKeySofaRequest().get(Context.current());
        String methodName = sofaRequest.getMethodName();
        Class[] argTypes = this.getArgTypes(request);
        try {
            Serializer serializer = SerializerFactory.getSerializer(request.getSerializeType());
            Method declaredMethod = this.proxyClass.getDeclaredMethod(methodName, argTypes);
            Object result = declaredMethod.invoke(this.ref, this.getInvokeArgs(request, argTypes, serializer));
            Response.Builder builder = Response.newBuilder();
            builder.setSerializeType(request.getSerializeType());
            builder.setType(declaredMethod.getReturnType().getName());
            builder.setData(ByteString.copyFrom((byte[])serializer.encode(result, null).array()));
            Response build = builder.build();
            responseObserver.onNext((Object)build);
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            LOGGER.error("Invoke " + methodName + " error:", e);
            throw new SofaRpcRuntimeException(e);
        }
    }

    private Class[] getArgTypes(Request request) {
        ProtocolStringList argTypesList = request.getArgTypesList();
        int size = argTypesList.size();
        Class[] argTypes = new Class[size];
        for (int i = 0; i < size; ++i) {
            String typeName = (String)argTypesList.get(i);
            argTypes[i] = ClassTypeUtils.getClass(typeName);
        }
        return argTypes;
    }

    private Object[] getInvokeArgs(Request request, Class[] argTypes, Serializer serializer) {
        List<ByteString> argsList = request.getArgsList();
        Object[] args = new Object[argsList.size()];
        for (int i = 0; i < argsList.size(); ++i) {
            byte[] data = argsList.get(i).toByteArray();
            args[i] = serializer.decode((AbstractByteBuf)new ByteArrayWrapperByteBuf(data), argTypes[i], null);
        }
        return args;
    }
}

