/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.aft.impl;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.client.ProviderStatus;
import com.alipay.sofa.rpc.client.aft.FaultToleranceConfigManager;
import com.alipay.sofa.rpc.client.aft.InvocationStatDimension;
import com.alipay.sofa.rpc.client.aft.MeasureResultDetail;
import com.alipay.sofa.rpc.client.aft.ProviderInfoWeightManager;
import com.alipay.sofa.rpc.client.aft.RecoverStrategy;
import com.alipay.sofa.rpc.common.utils.CalculateUtils;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;

@Extension(value="weight")
public class WeightRecoverStrategy
implements RecoverStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(WeightRecoverStrategy.class);

    @Override
    public void recover(MeasureResultDetail measureResultDetail) {
        int originWeight;
        InvocationStatDimension statDimension = measureResultDetail.getInvocationStatDimension();
        ProviderInfo providerInfo = statDimension.getProviderInfo();
        if (providerInfo == null || providerInfo.getStatus() == ProviderStatus.WARMING_UP) {
            return;
        }
        Integer currentWeight = ProviderInfoWeightManager.getWeight(providerInfo);
        if (currentWeight == -1) {
            return;
        }
        String appName = statDimension.getAppName();
        double weightRecoverRate = FaultToleranceConfigManager.getWeightRecoverRate(appName);
        int recoverWeight = CalculateUtils.multiply(currentWeight, weightRecoverRate);
        if (recoverWeight >= (originWeight = statDimension.getOriginWeight())) {
            measureResultDetail.setRecoveredOriginWeight(true);
            ProviderInfoWeightManager.recoverOriginWeight(providerInfo, originWeight);
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, "the weight was recovered to origin value. serviceUniqueName:[" + statDimension.getService() + "],ip:[" + statDimension.getIp() + "],origin weight:[" + currentWeight + "],recover weight:[" + originWeight + "].");
            }
        } else {
            measureResultDetail.setRecoveredOriginWeight(false);
            boolean success = ProviderInfoWeightManager.recoverWeight(providerInfo, recoverWeight);
            if (success && LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, "the weight was recovered. serviceUniqueName:[" + statDimension.getService() + "],ip:[" + statDimension.getIp() + "],origin weight:[" + currentWeight + "],recover weight:[" + recoverWeight + "].");
            }
        }
    }
}

