/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.file.bufferfile;

import java.io.File;
import java.io.IOException;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.io.IOFactory;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.store.KvEntryFileWriter;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;

public class BufferFileEntryBuilder
implements KvEntryFileWriter {
    private final RandomAccessOutput output;

    public BufferFileEntryBuilder(String path) {
        try {
            this.output = IOFactory.createFileOutput(new File(path));
        }
        catch (IOException e) {
            throw new ComputerException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void write(KvEntry entry) throws IOException {
        entry.key().write(this.output);
        entry.value().write(this.output);
    }

    @Override
    public void finish() throws IOException {
        this.close();
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }
}

