/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.entry;

import java.io.IOException;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.io.BytesInput;
import org.apache.hugegraph.computer.core.io.BytesOutput;
import org.apache.hugegraph.computer.core.io.IOFactory;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.store.EntryIterator;
import org.apache.hugegraph.computer.core.store.buffer.SubKvEntriesInput;
import org.apache.hugegraph.computer.core.store.entry.CachedPointer;
import org.apache.hugegraph.computer.core.store.entry.DefaultKvEntry;
import org.apache.hugegraph.computer.core.store.entry.InlinePointer;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;
import org.apache.hugegraph.computer.core.store.entry.KvEntryWithFirstSubKv;
import org.apache.hugegraph.computer.core.store.entry.Pointer;

public final class EntriesUtil {
    public static KvEntry kvEntryFromInput(RandomAccessInput input, RandomAccessInput userAccessInput, boolean useInlinePointer, boolean valueWithSubKv) {
        try {
            if (useInlinePointer) {
                return EntriesUtil.inlinePointerKvEntry(input, valueWithSubKv);
            }
            return EntriesUtil.cachedPointerKvEntry(input, userAccessInput, valueWithSubKv);
        }
        catch (IOException e) {
            throw new ComputerException(e.getMessage(), (Throwable)e);
        }
    }

    public static KvEntry kvEntryFromInput(RandomAccessInput input, boolean useInlinePointer, boolean valueWithSubKv) {
        return EntriesUtil.kvEntryFromInput(input, input, useInlinePointer, valueWithSubKv);
    }

    private static KvEntry cachedPointerKvEntry(RandomAccessInput input, RandomAccessInput userAccessInput, boolean valueWithSubKv) throws IOException {
        int numSubKvEntries = 0;
        int keyLength = input.readFixedInt();
        long keyPosition = input.position();
        input.skip((long)keyLength);
        int valueLength = input.readFixedInt();
        long valuePosition = input.position();
        if (valueWithSubKv) {
            numSubKvEntries = input.readFixedInt();
            input.skip((long)(valueLength - 4));
        } else {
            input.skip((long)valueLength);
        }
        CachedPointer key = new CachedPointer(userAccessInput, keyPosition, keyLength);
        CachedPointer value = new CachedPointer(userAccessInput, valuePosition, valueLength);
        return new DefaultKvEntry(key, value, numSubKvEntries);
    }

    private static KvEntry inlinePointerKvEntry(RandomAccessInput input, boolean valueWithSubKv) throws IOException {
        int numSubEntries = 0;
        int keyLength = input.readFixedInt();
        byte[] keyBytes = input.readBytes(keyLength);
        int valueLength = input.readFixedInt();
        byte[] valueBytes = new byte[valueLength];
        if (valueWithSubKv) {
            numSubEntries = input.readFixedInt();
            valueBytes[0] = (byte)(numSubEntries & 0xFF);
            valueBytes[1] = (byte)(numSubEntries >> 8 & 0xFF);
            valueBytes[2] = (byte)(numSubEntries >> 16 & 0xFF);
            valueBytes[3] = (byte)(numSubEntries >> 24 & 0xFF);
            input.readFully(valueBytes, 4, valueLength - 4);
        } else {
            input.readFully(valueBytes);
        }
        InlinePointer key = new InlinePointer(keyBytes);
        InlinePointer value = new InlinePointer(valueBytes);
        return new DefaultKvEntry(key, value, numSubEntries);
    }

    public static KvEntry subKvEntryFromInput(RandomAccessInput input, RandomAccessInput userAccessInput, boolean useInlinePointer) {
        try {
            Pointer value;
            Pointer key;
            if (useInlinePointer) {
                byte[] keyBytes = input.readBytes(input.readFixedInt());
                key = new InlinePointer(keyBytes);
                byte[] valueBytes = input.readBytes(input.readFixedInt());
                value = new InlinePointer(valueBytes);
            } else {
                int keyLength = input.readFixedInt();
                key = new CachedPointer(userAccessInput, input.position(), keyLength);
                input.skip((long)keyLength);
                int valueLength = input.readFixedInt();
                value = new CachedPointer(userAccessInput, input.position(), valueLength);
                input.skip((long)valueLength);
            }
            return new DefaultKvEntry(key, value);
        }
        catch (IOException e) {
            throw new ComputerException(e.getMessage(), (Throwable)e);
        }
    }

    public static KvEntry subKvEntryFromInput(RandomAccessInput input, boolean useInlinePointer) {
        return EntriesUtil.subKvEntryFromInput(input, input, useInlinePointer);
    }

    public static KvEntryWithFirstSubKv kvEntryWithFirstSubKv(KvEntry entry) {
        try {
            BytesInput input = IOFactory.createBytesInput(entry.value().bytes());
            long subKvNum = input.readFixedInt();
            KvEntry firstSubKv = EntriesUtil.subKvEntryFromInput((RandomAccessInput)input, true);
            return new KvEntryWithFirstSubKv(entry.key(), entry.value(), firstSubKv, subKvNum);
        }
        catch (IOException e) {
            throw new ComputerException(e.getMessage(), (Throwable)e);
        }
    }

    public static BytesInput inputFromOutput(BytesOutput output) {
        return IOFactory.createBytesInput(output.buffer(), (int)output.position());
    }

    public static EntryIterator subKvIterFromEntry(KvEntry entry) {
        return new SubKvEntriesInput(entry);
    }
}

