/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sort.sorting;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hugegraph.computer.core.sort.sorting.AbstractInputsSorting;

public final class LoserTreeInputsSorting<T>
extends AbstractInputsSorting<T> {
    private static final Object INFINITY_LEAF = new Object();
    private final Object[] leaves;
    private final int size;
    private final int[] tree;

    public LoserTreeInputsSorting(Collection<? extends Iterator<T>> sources) {
        this(sources, null);
    }

    public LoserTreeInputsSorting(Collection<? extends Iterator<T>> sources, Comparator<? super T> comparator) {
        super(sources, comparator);
        this.size = sources.size();
        this.leaves = new Object[this.size];
        this.tree = new int[this.size];
        this.constructLoserTree();
    }

    @Override
    public boolean hasNext() {
        return !this.isEmpty();
    }

    @Override
    public T next() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int winnerIndex = this.tree[0];
        Object winner = this.leaves[winnerIndex];
        this.fill(winnerIndex);
        this.adjust(winnerIndex);
        return (T)winner;
    }

    private boolean isEmpty() {
        return this.leaves[this.tree[0]] == INFINITY_LEAF;
    }

    private void constructLoserTree() {
        int i;
        for (int i2 = 0; i2 < this.sources.length; ++i2) {
            this.leaves[i2] = this.sources[i2].hasNext() ? this.sources[i2].next() : INFINITY_LEAF;
        }
        int winner = 0;
        for (i = 0; i < this.size; ++i) {
            if (!this.beat(i, winner)) continue;
            winner = i;
        }
        Arrays.fill(this.tree, winner);
        for (i = this.size - 1; i >= 0; --i) {
            this.adjust(i);
        }
    }

    private void fill(int index) {
        Iterator source = this.sources[index];
        this.leaves[index] = source.hasNext() ? source.next() : INFINITY_LEAF;
    }

    private void adjust(int index) {
        for (int t = this.size + index >> 1; t > 0; t >>= 1) {
            if (!this.beat(this.tree[t], index)) continue;
            int temp = this.tree[t];
            this.tree[t] = index;
            index = temp;
        }
        this.tree[0] = index;
    }

    private boolean beat(int index1, int index2) {
        Object t1 = this.leaves[index1];
        Object t2 = this.leaves[index2];
        if (t1 == INFINITY_LEAF) {
            return false;
        }
        if (t2 == INFINITY_LEAF) {
            return true;
        }
        int result = this.compare(t1, t2);
        if (result == 0) {
            return index1 > index2;
        }
        return result < 0;
    }
}

