/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sort.sorter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hugegraph.computer.core.sort.flusher.PeekableIterator;
import org.apache.hugegraph.computer.core.sort.sorting.LoserTreeInputsSorting;
import org.apache.hugegraph.computer.core.store.entry.EntriesUtil;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;
import org.apache.hugegraph.util.E;

public class SubKvSorter
implements Iterator<KvEntry> {
    private final PeekableIterator<KvEntry> entries;
    private final int subKvSortPathNum;
    private final List<Iterator<KvEntry>> subKvMergeSources;
    private Iterator<KvEntry> subKvSorting;
    private KvEntry currentEntry;

    public SubKvSorter(PeekableIterator<KvEntry> entries, int subKvSortPathNum) {
        E.checkArgument((boolean)entries.hasNext(), (String)"Parameter entries can't be empty", (Object[])new Object[0]);
        E.checkArgument((subKvSortPathNum > 0 ? 1 : 0) != 0, (String)"Parameter subKvSortPathNum must be > 0", (Object[])new Object[0]);
        this.entries = entries;
        this.subKvSortPathNum = subKvSortPathNum;
        this.subKvMergeSources = new ArrayList<Iterator<KvEntry>>(this.subKvSortPathNum);
        this.init();
    }

    @Override
    public boolean hasNext() {
        return this.subKvSorting.hasNext();
    }

    @Override
    public KvEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.subKvSorting.next();
    }

    public KvEntry currentKv() {
        return this.currentEntry;
    }

    public void reset() {
        KvEntry entry;
        KvEntry next;
        if (!this.entries.hasNext()) {
            this.currentEntry = null;
            return;
        }
        this.subKvMergeSources.clear();
        assert (this.subKvSortPathNum > 0);
        do {
            entry = (KvEntry)this.entries.next();
            this.subKvMergeSources.add(new MergePath(this.entries, entry));
            next = this.entries.peek();
        } while (this.subKvMergeSources.size() != this.subKvSortPathNum && next != null && entry.key().compareTo(next.key()) == 0);
        this.subKvSorting = new LoserTreeInputsSorting<KvEntry>(this.subKvMergeSources);
        this.currentEntry = entry;
    }

    private void init() {
        this.reset();
    }

    private static class MergePath
    implements Iterator<KvEntry> {
        private final PeekableIterator<KvEntry> entries;
        private Iterator<KvEntry> subKvIter;
        private KvEntry currentEntry;

        public MergePath(PeekableIterator<KvEntry> entries, KvEntry currentEntry) {
            this.entries = entries;
            this.subKvIter = EntriesUtil.subKvIterFromEntry(currentEntry);
            this.currentEntry = currentEntry;
        }

        @Override
        public boolean hasNext() {
            return this.subKvIter.hasNext();
        }

        @Override
        public KvEntry next() {
            KvEntry nextEntry;
            KvEntry nextSubKvEntry = this.subKvIter.next();
            if (!this.subKvIter.hasNext() && (nextEntry = this.entries.peek()) != null && nextEntry.key().compareTo(this.currentEntry.key()) == 0) {
                this.currentEntry = (KvEntry)this.entries.next();
                this.subKvIter = EntriesUtil.subKvIterFromEntry(this.currentEntry);
            }
            return nextSubKvEntry;
        }
    }
}

