/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.session;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.hugegraph.computer.core.network.TransportConf;
import org.apache.hugegraph.computer.core.network.TransportState;

public abstract class TransportSession {
    protected static final AtomicIntegerFieldUpdater<TransportSession> MAX_REQUEST_ID_UPDATER = AtomicIntegerFieldUpdater.newUpdater(TransportSession.class, "maxRequestId");
    protected final TransportConf conf;
    protected volatile TransportState state;
    protected volatile int maxRequestId;
    protected volatile int maxAckId;
    protected volatile int finishId;

    protected TransportSession(TransportConf conf) {
        this.conf = conf;
        this.maxRequestId = -1;
        this.finishId = -1;
        this.maxAckId = -1;
        this.state = TransportState.READY;
    }

    protected void stateReady() {
        this.maxRequestId = -1;
        this.finishId = -1;
        this.maxAckId = -1;
        this.state = TransportState.READY;
    }

    protected void stateEstablished() {
        this.state = TransportState.ESTABLISHED;
    }

    public TransportState state() {
        return this.state;
    }

    public int nextRequestId() {
        return MAX_REQUEST_ID_UPDATER.incrementAndGet(this);
    }

    protected int genFinishId() {
        return this.maxRequestId + 1;
    }

    public int finishId() {
        return this.finishId;
    }

    public TransportConf conf() {
        return this.conf;
    }
}

