/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.computer.core.common.exception.TransportException;
import org.apache.hugegraph.computer.core.network.ConnectionId;
import org.apache.hugegraph.computer.core.network.MessageHandler;
import org.apache.hugegraph.computer.core.network.TransportUtil;
import org.apache.hugegraph.computer.core.network.buffer.FileRegionBuffer;
import org.apache.hugegraph.computer.core.network.buffer.NetworkBuffer;
import org.apache.hugegraph.computer.core.network.message.AckMessage;
import org.apache.hugegraph.computer.core.network.message.DataMessage;
import org.apache.hugegraph.computer.core.network.message.FinishMessage;
import org.apache.hugegraph.computer.core.network.message.StartMessage;
import org.apache.hugegraph.computer.core.network.netty.AbstractNettyHandler;
import org.apache.hugegraph.computer.core.network.netty.ChannelFutureListenerOnWrite;
import org.apache.hugegraph.computer.core.network.session.ServerSession;

public class NettyServerHandler
extends AbstractNettyHandler {
    private static final long INITIAL_DELAY = 0L;
    private final MessageHandler handler;
    private final ServerSession serverSession;
    private final ChannelFutureListenerOnWrite listenerOnWrite;
    private ScheduledFuture<?> respondAckTask;

    public NettyServerHandler(ServerSession serverSession, MessageHandler handler) {
        this.serverSession = serverSession;
        this.handler = handler;
        this.listenerOnWrite = new ChannelFutureListenerOnWrite(this.handler);
    }

    @Override
    protected void processStartMessage(ChannelHandlerContext ctx, Channel channel, StartMessage startMessage) {
        this.serverSession.onRecvStateStart();
        this.ackStartMessage(ctx);
    }

    @Override
    protected void processFinishMessage(ChannelHandlerContext ctx, Channel channel, FinishMessage finishMessage) {
        int finishId = finishMessage.requestId();
        boolean needAckFinish = this.serverSession.onRecvStateFinish(finishId);
        if (needAckFinish) {
            this.ackFinishMessage(ctx, this.serverSession.finishId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processDataMessage(ChannelHandlerContext ctx, Channel channel, DataMessage dataMessage) {
        NetworkBuffer body = dataMessage.body();
        try {
            int requestId = dataMessage.requestId();
            this.serverSession.onRecvData(requestId);
            if (body instanceof FileRegionBuffer) {
                this.processFileRegionBuffer(ctx, channel, dataMessage, (FileRegionBuffer)body);
            } else {
                this.handler.handle(dataMessage.type(), dataMessage.partition(), dataMessage.body());
                this.serverSession.onHandledData(requestId);
            }
        }
        finally {
            body.release();
        }
    }

    private void processFileRegionBuffer(ChannelHandlerContext ctx, Channel channel, DataMessage dataMessage, FileRegionBuffer fileRegionBuffer) {
        TransportUtil.setMaxBytesPerRead(channel, fileRegionBuffer.length());
        String outputPath = this.handler.genOutputPath(dataMessage.type(), dataMessage.partition());
        ChannelFuture channelFuture = fileRegionBuffer.transformFromChannel((SocketChannel)channel, outputPath);
        channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            try {
                if (future.isSuccess()) {
                    this.handler.handle(dataMessage.type(), dataMessage.partition(), dataMessage.body());
                    this.serverSession.onHandledData(dataMessage.requestId());
                } else {
                    this.exceptionCaught(ctx, future.cause());
                }
                TransportUtil.setMaxBytesPerRead(future.channel(), 16);
                future.channel().unsafe().recvBufAllocHandle().reset(future.channel().config());
                dataMessage.release();
            }
            catch (Throwable throwable) {
                this.exceptionCaught(ctx, throwable);
            }
        }));
    }

    @Override
    protected void processAckMessage(ChannelHandlerContext ctx, Channel channel, AckMessage ackMessage) {
        throw new UnsupportedOperationException("Server does not support processAckMessage()");
    }

    private void ackStartMessage(ChannelHandlerContext ctx) {
        AckMessage startAck = new AckMessage(0);
        ctx.writeAndFlush((Object)startAck).addListener((GenericFutureListener)this.listenerOnWrite);
        this.serverSession.completeStateStart();
        Channel channel = ctx.channel();
        this.handler.onStarted(TransportUtil.remoteConnectionId(channel));
        if (this.respondAckTask == null) {
            EventLoop eventExecutors = ctx.channel().eventLoop();
            this.respondAckTask = eventExecutors.scheduleWithFixedDelay(() -> this.checkAndRespondAck(ctx), 0L, this.serverSession.minAckInterval(), TimeUnit.MILLISECONDS);
        }
    }

    private void ackFinishMessage(ChannelHandlerContext ctx, int finishId) {
        AckMessage finishAck = new AckMessage(finishId);
        ctx.writeAndFlush((Object)finishAck).addListener((GenericFutureListener)this.listenerOnWrite);
        this.serverSession.completeStateFinish();
        Channel channel = ctx.channel();
        this.handler.onFinished(TransportUtil.remoteConnectionId(channel));
        if (this.respondAckTask != null) {
            this.respondAckTask.cancel(false);
            this.respondAckTask = null;
        }
    }

    private void ackDataMessage(ChannelHandlerContext ctx, int ackId) {
        AckMessage ackMessage = new AckMessage(ackId);
        ctx.writeAndFlush((Object)ackMessage).addListener((GenericFutureListener)this.listenerOnWrite);
        this.serverSession.onDataAckSent(ackId);
    }

    private void checkAndRespondAck(ChannelHandlerContext ctx) {
        if (this.serverSession.needAckFinish()) {
            this.ackFinishMessage(ctx, this.serverSession.finishId());
        } else if (this.serverSession.needAckData()) {
            this.ackDataMessage(ctx, this.serverSession.maxHandledId());
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        ConnectionId connectionId = TransportUtil.remoteConnectionId(channel);
        this.handler.onChannelActive(connectionId);
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        ConnectionId connectionId = TransportUtil.remoteConnectionId(channel);
        this.handler.onChannelInactive(connectionId);
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Channel channel = ctx.channel();
        TransportException exception = cause instanceof TransportException ? (TransportException)cause : new TransportException("%s when the server receive data from '%s'", cause, cause.getMessage(), TransportUtil.remoteAddress(channel));
        ConnectionId connectionId = TransportUtil.remoteConnectionId(channel);
        this.handler.exceptionCaught(exception, connectionId);
    }

    @Override
    protected ServerSession session() {
        return this.serverSession;
    }

    @Override
    protected MessageHandler transportHandler() {
        return this.handler;
    }
}

