/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.hugegraph.computer.core.common.exception.IllegalArgException;
import org.apache.hugegraph.computer.core.common.exception.TransportException;
import org.apache.hugegraph.computer.core.network.ConnectionId;
import org.apache.hugegraph.computer.core.network.TransportHandler;
import org.apache.hugegraph.computer.core.network.TransportUtil;
import org.apache.hugegraph.computer.core.network.message.AckMessage;
import org.apache.hugegraph.computer.core.network.message.DataMessage;
import org.apache.hugegraph.computer.core.network.message.FailMessage;
import org.apache.hugegraph.computer.core.network.message.FinishMessage;
import org.apache.hugegraph.computer.core.network.message.Message;
import org.apache.hugegraph.computer.core.network.message.MessageType;
import org.apache.hugegraph.computer.core.network.message.PingMessage;
import org.apache.hugegraph.computer.core.network.message.PongMessage;
import org.apache.hugegraph.computer.core.network.message.StartMessage;
import org.apache.hugegraph.computer.core.network.session.TransportSession;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public abstract class AbstractNettyHandler
extends SimpleChannelInboundHandler<Message> {
    private static final Logger LOG = Log.logger(AbstractNettyHandler.class);

    protected void channelRead0(ChannelHandlerContext ctx, Message msg) throws Exception {
        MessageType msgType;
        Channel channel = ctx.channel();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Receive remote message from '{}', message: {}", (Object)TransportUtil.remoteAddress(channel), (Object)msg);
        }
        if ((msgType = msg.type()).category() == MessageType.Category.DATA) {
            this.processDataMessage(ctx, channel, (DataMessage)msg);
            return;
        }
        switch (msgType) {
            case START: {
                this.processStartMessage(ctx, channel, (StartMessage)msg);
                break;
            }
            case FAIL: {
                this.processFailMessage(ctx, channel, (FailMessage)msg);
                break;
            }
            case ACK: {
                this.processAckMessage(ctx, channel, (AckMessage)msg);
                break;
            }
            case FINISH: {
                this.processFinishMessage(ctx, channel, (FinishMessage)msg);
                break;
            }
            case PING: {
                this.processPingMessage(ctx, channel, (PingMessage)msg);
                break;
            }
            case PONG: {
                this.processPongMessage(ctx, channel, (PongMessage)msg);
                break;
            }
            default: {
                throw new IllegalArgException("Unknown message type: %s", new Object[]{msgType});
            }
        }
    }

    protected abstract void processStartMessage(ChannelHandlerContext var1, Channel var2, StartMessage var3);

    protected abstract void processFinishMessage(ChannelHandlerContext var1, Channel var2, FinishMessage var3);

    protected abstract void processDataMessage(ChannelHandlerContext var1, Channel var2, DataMessage var3);

    protected abstract void processAckMessage(ChannelHandlerContext var1, Channel var2, AckMessage var3);

    protected void processPingMessage(ChannelHandlerContext ctx, Channel channel, PingMessage pingMessage) {
        ctx.writeAndFlush((Object)PongMessage.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
    }

    protected void processPongMessage(ChannelHandlerContext ctx, Channel channel, PongMessage pongMessage) {
    }

    protected void processFailMessage(ChannelHandlerContext ctx, Channel channel, FailMessage failMessage) {
        int errorCode = failMessage.errorCode();
        TransportException exception = new TransportException(errorCode, "Remote error from '%s', cause: %s", TransportUtil.remoteAddress(channel), failMessage.message());
        ConnectionId connectionId = TransportUtil.remoteConnectionId(channel);
        this.transportHandler().exceptionCaught(exception, connectionId);
    }

    @Deprecated
    protected void ackFailMessage(ChannelHandlerContext ctx, int failId, int errorCode, String message) {
        long timeout = this.session().conf().writeSocketTimeout();
        FailMessage failMessage = new FailMessage(failId, errorCode, message);
        ctx.writeAndFlush((Object)failMessage).awaitUninterruptibly(timeout);
    }

    protected abstract TransportSession session();

    protected abstract TransportHandler transportHandler();
}

