/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.io;

import java.io.IOException;
import java.util.Map;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.EdgeFrequency;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.properties.Properties;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.io.GraphComputeOutput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.store.entry.EntryOutput;
import org.apache.hugegraph.computer.core.store.entry.KvEntryWriter;
import org.apache.hugegraph.config.TypedOption;

public class StreamGraphOutput
implements GraphComputeOutput {
    private final EntryOutput out;
    private final EdgeFrequency frequency;

    public StreamGraphOutput(ComputerContext context, EntryOutput out) {
        this.out = out;
        this.frequency = (EdgeFrequency)context.config().get((TypedOption)ComputerOptions.INPUT_EDGE_FREQ);
    }

    public void writeVertex(Vertex vertex) throws IOException {
        this.out.writeEntry(out -> this.writeId(out, vertex.id()), out -> {
            this.writeLabel(out, vertex.label());
            this.writeProperties(out, vertex.properties());
        });
    }

    public void writeEdges(Vertex vertex) throws IOException {
        KvEntryWriter writer = this.out.writeEntry(out -> this.writeId(out, vertex.id()));
        if (this.frequency == EdgeFrequency.SINGLE) {
            for (Edge edge : vertex.edges()) {
                writer.writeSubKv(out -> this.writeId(out, edge.targetId()), out -> this.writeProperties(out, edge.properties()));
            }
        } else if (this.frequency == EdgeFrequency.SINGLE_PER_LABEL) {
            for (Edge edge : vertex.edges()) {
                writer.writeSubKv(out -> {
                    this.writeLabel(out, edge.label());
                    this.writeId(out, edge.targetId());
                }, out -> this.writeProperties(out, edge.properties()));
            }
        } else {
            assert (this.frequency == EdgeFrequency.MULTIPLE);
            for (Edge edge : vertex.edges()) {
                writer.writeSubKv(out -> {
                    this.writeLabel(out, edge.label());
                    this.writeLabel(out, edge.name());
                    this.writeId(out, edge.targetId());
                }, out -> this.writeProperties(out, edge.properties()));
            }
        }
        writer.writeFinish();
    }

    public void writeMessage(Id id, Value value) throws IOException {
        this.out.writeEntry(out -> this.writeId(out, id), out -> this.writeMessage(out, value));
    }

    public void writeId(RandomAccessOutput out, Id id) throws IOException {
        id.write(out);
    }

    public void writeValue(RandomAccessOutput out, Value value) throws IOException {
        out.writeByte((int)value.valueType().code());
        value.write(out);
    }

    private void writeMessage(RandomAccessOutput out, Value value) throws IOException {
        value.write(out);
    }

    private void writeProperties(RandomAccessOutput out, Properties properties) throws IOException {
        Map keyValues = properties.get();
        out.writeInt(keyValues.size());
        for (Map.Entry entry : keyValues.entrySet()) {
            out.writeUTF((String)entry.getKey());
            this.writeValue(out, (Value)entry.getValue());
        }
    }

    private void writeLabel(RandomAccessOutput output, String label) throws IOException {
        output.writeUTF(label);
    }
}

