/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hugegraph.computer.core.io.UnsafeBytesOutput;
import org.apache.hugegraph.util.E;

public class BufferedStreamOutput
extends UnsafeBytesOutput {
    private final int bufferCapacity;
    private final OutputStream output;
    private long outputOffset;

    public BufferedStreamOutput(OutputStream output) {
        this(output, 8192);
    }

    public BufferedStreamOutput(OutputStream output, int bufferCapacity) {
        super(bufferCapacity);
        E.checkArgument((bufferCapacity >= 8 ? 1 : 0) != 0, (String)"The parameter bufferSize must be >= 8", (Object[])new Object[0]);
        this.bufferCapacity = bufferCapacity;
        this.output = output;
        this.outputOffset = 0L;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.bufferAvailable() >= len) {
            super.write(b, off, len);
            return;
        }
        this.flushBuffer();
        if (this.bufferCapacity >= len) {
            super.write(b, off, len);
        } else {
            this.output.write(b, off, len);
            this.outputOffset += (long)len;
        }
    }

    @Override
    public long position() {
        return this.outputOffset + super.position();
    }

    @Override
    public void seek(long position) throws IOException {
        if (this.outputOffset > position || position > this.position()) {
            throw new IOException(String.format("The position %s is out of range [%s, %s]", position, this.outputOffset, this.position()));
        }
        super.seek(position - this.outputOffset);
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        E.checkArgument((bytesToSkip >= 0L ? 1 : 0) != 0, (String)"The parameter bytesToSkip must be >= 0, but got %s", (Object[])new Object[]{bytesToSkip});
        long positionBeforeSkip = this.outputOffset + super.position();
        if ((long)this.bufferAvailable() >= bytesToSkip) {
            super.skip(bytesToSkip);
            return positionBeforeSkip;
        }
        this.flushBuffer();
        if (bytesToSkip <= (long)this.bufferCapacity) {
            super.skip(bytesToSkip);
        } else {
            int len;
            this.outputOffset += bytesToSkip;
            byte[] buffer = super.buffer();
            for (int writeSize = (int)bytesToSkip; writeSize > 0; writeSize -= len) {
                len = Math.min(buffer.length, writeSize);
                this.output.write(buffer, 0, len);
            }
        }
        return positionBeforeSkip;
    }

    @Override
    public void writeFixedInt(long position, int v) throws IOException {
        if (position < this.outputOffset || position > this.position() - 4L) {
            if (position < this.outputOffset) {
                throw new IOException(String.format("Write int to position %s underflows the start position %s of the buffer", position, this.outputOffset));
            }
            throw new IOException(String.format("Write int to position %s overflows the write position %s", position, this.position()));
        }
        super.writeFixedInt(position - this.outputOffset, v);
    }

    @Override
    protected void require(int size) throws IOException {
        E.checkArgument((size <= this.bufferCapacity ? 1 : 0) != 0, (String)"The parameter size must be <= %s", (Object[])new Object[]{this.bufferCapacity});
        if (this.bufferAvailable() >= size) {
            return;
        }
        this.flushBuffer();
        if (size > this.bufferAvailable()) {
            throw new IOException(String.format("Write %s bytes to position %s overflows buffer %s", size, this.position(), this.bufferCapacity));
        }
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer();
        this.output.close();
    }

    private void flushBuffer() throws IOException {
        int bufferPosition = (int)super.position();
        if (bufferPosition == 0) {
            return;
        }
        this.output.write(this.buffer(), 0, bufferPosition);
        this.outputOffset += (long)bufferPosition;
        super.seek(0L);
    }

    private final int bufferAvailable() {
        return this.bufferCapacity - (int)super.position();
    }
}

