/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.input.loader;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.input.ElementFetcher;
import org.apache.hugegraph.computer.core.input.InputSplit;
import org.apache.hugegraph.computer.core.input.loader.FileInputSplit;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.iterator.FlatMapperIterator;
import org.apache.hugegraph.loader.builder.ElementBuilder;
import org.apache.hugegraph.loader.builder.SchemaCache;
import org.apache.hugegraph.loader.constant.Constants;
import org.apache.hugegraph.loader.executor.ComputerLoadOptions;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.reader.InputReader;
import org.apache.hugegraph.loader.reader.file.FileReader;
import org.apache.hugegraph.loader.reader.line.Line;
import org.apache.hugegraph.loader.source.InputSource;
import org.apache.hugegraph.loader.source.file.FileSource;
import org.apache.hugegraph.loader.util.JsonUtil;
import org.apache.hugegraph.structure.GraphElement;

public abstract class FileElementFetcher<T extends GraphElement>
implements ElementFetcher<T> {
    private final LoadContext context;
    private List<ElementBuilder<T>> builders;
    private InputReader inputReader;
    private FlatMapperIterator<Line, T> localBatch;
    private T next;

    public FileElementFetcher(Config config) {
        SchemaCache schemaCache;
        String schemaPath = (String)config.get((TypedOption)ComputerOptions.INPUT_LOADER_SCHEMA_PATH);
        try {
            String json = FileUtils.readFileToString((File)new File(schemaPath), (Charset)Constants.CHARSET);
            schemaCache = (SchemaCache)JsonUtil.fromJson((String)json, SchemaCache.class);
        }
        catch (IOException exception) {
            throw new ComputerException("Failed to load schema from file, path:%s", new Object[]{schemaPath});
        }
        ComputerLoadOptions options = new ComputerLoadOptions(schemaCache);
        this.context = new LoadContext(options);
    }

    @Override
    public void prepareLoadInputSplit(InputSplit split) {
        if (this.inputReader != null) {
            this.inputReader.close();
        }
        FileInputSplit fileInputSplit = (FileInputSplit)split;
        this.builders = this.elementBuilders(this.context, fileInputSplit.struct());
        this.inputReader = this.createReader(fileInputSplit);
        this.localBatch = new FlatMapperIterator((Iterator)this.inputReader, line -> {
            ArrayList<T> allElements = new ArrayList<T>();
            for (ElementBuilder<T> builder : this.builders) {
                List<T> elements = this.buildElement((Line)line, builder);
                allElements.addAll(elements);
            }
            return allElements.iterator();
        });
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.localBatch != null && this.localBatch.hasNext()) {
            this.next = (GraphElement)this.localBatch.next();
            return true;
        }
        this.localBatch = null;
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T current = this.next;
        this.next = null;
        return current;
    }

    private InputReader createReader(FileInputSplit split) {
        InputStruct struct = split.struct();
        FileSource source = (FileSource)struct.input();
        source.path(split.path());
        FileReader reader = (FileReader)InputReader.create((InputSource)struct.input());
        reader.init(this.context, struct);
        return reader;
    }

    protected List<T> buildElement(Line line, ElementBuilder<T> builder) {
        return builder.build(line.names(), line.values());
    }

    protected abstract List<ElementBuilder<T>> elementBuilders(LoadContext var1, InputStruct var2);

    public void close() {
        if (this.inputReader != null) {
            this.inputReader.close();
        }
    }
}

