/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.input.loader;

import java.util.ArrayList;
import java.util.List;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.input.EdgeFetcher;
import org.apache.hugegraph.computer.core.input.IdUtil;
import org.apache.hugegraph.computer.core.input.loader.FileElementFetcher;
import org.apache.hugegraph.loader.builder.EdgeBuilder;
import org.apache.hugegraph.loader.builder.ElementBuilder;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.mapping.EdgeMapping;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.reader.line.Line;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.schema.EdgeLabel;

public class FileEdgeFetcher
extends FileElementFetcher<Edge>
implements EdgeFetcher {
    public FileEdgeFetcher(Config config) {
        super(config);
    }

    @Override
    protected List<ElementBuilder<Edge>> elementBuilders(LoadContext context, InputStruct struct) {
        ArrayList<ElementBuilder<Edge>> builders = new ArrayList<ElementBuilder<Edge>>();
        for (EdgeMapping mapping : struct.edges()) {
            if (mapping.skip()) continue;
            builders.add((ElementBuilder<Edge>)new EdgeBuilder(context, struct, mapping));
        }
        return builders;
    }

    @Override
    protected List<Edge> buildElement(Line line, ElementBuilder<Edge> builder) {
        List<Edge> edges = super.buildElement(line, builder);
        for (Edge edge : edges) {
            EdgeLabel edgeLabel = (EdgeLabel)builder.schemaLabel();
            String edgeId = IdUtil.assignEdgeId(edge, edgeLabel);
            edge.id(edgeId);
        }
        return edges;
    }

    @Override
    public void close() {
        super.close();
    }
}

