/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hbase.regionserver.CSLMImmutableSegment;
import org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.MemStoreCompactionStrategy;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.regionserver.NonThreadSafeMemStoreSizing;
import org.apache.hadoop.hbase.regionserver.RegionServicesForStores;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.SegmentFactory;
import org.apache.hadoop.hbase.regionserver.VersionedSegmentsList;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CompactionPipeline {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionPipeline.class);
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 3 * ClassSize.REFERENCE + 8));
    public static final long DEEP_OVERHEAD = FIXED_OVERHEAD + (long)(2 * ClassSize.LINKEDLIST);
    private final RegionServicesForStores region;
    private final LinkedList<ImmutableSegment> pipeline = new LinkedList();
    private volatile LinkedList<ImmutableSegment> readOnlyCopy = new LinkedList();
    private volatile long version = 0L;

    public CompactionPipeline(RegionServicesForStores region) {
        this.region = region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushHead(MutableSegment segment) {
        NonThreadSafeMemStoreSizing memstoreAccounting = new NonThreadSafeMemStoreSizing();
        ImmutableSegment immutableSegment = SegmentFactory.instance().createImmutableSegment(segment, memstoreAccounting);
        if (this.region != null) {
            this.region.addMemStoreSize(memstoreAccounting.getDataSize(), memstoreAccounting.getHeapSize(), memstoreAccounting.getOffHeapSize(), memstoreAccounting.getCellsCount());
        }
        LinkedList<ImmutableSegment> linkedList = this.pipeline;
        synchronized (linkedList) {
            boolean res = this.addFirst(immutableSegment);
            this.readOnlyCopy = new LinkedList<ImmutableSegment>(this.pipeline);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedSegmentsList getVersionedList() {
        LinkedList<ImmutableSegment> linkedList = this.pipeline;
        synchronized (linkedList) {
            return new VersionedSegmentsList(this.readOnlyCopy, this.version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedSegmentsList getVersionedTail() {
        LinkedList<ImmutableSegment> linkedList = this.pipeline;
        synchronized (linkedList) {
            ArrayList<ImmutableSegment> segmentList = new ArrayList<ImmutableSegment>();
            if (!this.pipeline.isEmpty()) {
                segmentList.add(0, this.pipeline.getLast());
            }
            return new VersionedSegmentsList(segmentList, this.version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Increment is done under a synchronize block so safe")
    public boolean swap(VersionedSegmentsList versionedList, ImmutableSegment segment, boolean closeSuffix, boolean updateRegionSize) {
        List<ImmutableSegment> suffix;
        if (versionedList.getVersion() != this.version) {
            return false;
        }
        LinkedList<ImmutableSegment> linkedList = this.pipeline;
        synchronized (linkedList) {
            if (versionedList.getVersion() != this.version) {
                return false;
            }
            suffix = versionedList.getStoreSegments();
            LOG.debug("Swapping pipeline suffix; before={}, new segment={}", (Object)versionedList.getStoreSegments().size(), (Object)segment);
            this.swapSuffix(suffix, segment, closeSuffix);
            this.readOnlyCopy = new LinkedList<ImmutableSegment>(this.pipeline);
            ++this.version;
        }
        if (updateRegionSize && this.region != null) {
            long suffixDataSize = CompactionPipeline.getSegmentsKeySize(suffix);
            long suffixHeapSize = CompactionPipeline.getSegmentsHeapSize(suffix);
            long suffixOffHeapSize = CompactionPipeline.getSegmentsOffHeapSize(suffix);
            int suffixCellsCount = CompactionPipeline.getSegmentsCellsCount(suffix);
            long newDataSize = 0L;
            long newHeapSize = 0L;
            long newOffHeapSize = 0L;
            int newCellsCount = 0;
            if (segment != null) {
                newDataSize = segment.getDataSize();
                newHeapSize = segment.getHeapSize();
                newOffHeapSize = segment.getOffHeapSize();
                newCellsCount = segment.getCellsCount();
            }
            long dataSizeDelta = suffixDataSize - newDataSize;
            long heapSizeDelta = suffixHeapSize - newHeapSize;
            long offHeapSizeDelta = suffixOffHeapSize - newOffHeapSize;
            int cellsCountDelta = suffixCellsCount - newCellsCount;
            this.region.addMemStoreSize(-dataSizeDelta, -heapSizeDelta, -offHeapSizeDelta, -cellsCountDelta);
            LOG.debug("Suffix data size={}, new segment data size={}, suffix heap size={},new segment heap size={} \u3000suffix off heap size={}, new segment off heap size={}, suffix cells count={}, new segment cells count={}", new Object[]{suffixDataSize, newDataSize, suffixHeapSize, newHeapSize, suffixOffHeapSize, newOffHeapSize, suffixCellsCount, newCellsCount});
        }
        return true;
    }

    private static long getSegmentsHeapSize(List<? extends Segment> list) {
        long res = 0L;
        for (Segment segment : list) {
            res += segment.getHeapSize();
        }
        return res;
    }

    private static long getSegmentsOffHeapSize(List<? extends Segment> list) {
        long res = 0L;
        for (Segment segment : list) {
            res += segment.getOffHeapSize();
        }
        return res;
    }

    private static long getSegmentsKeySize(List<? extends Segment> list) {
        long res = 0L;
        for (Segment segment : list) {
            res += segment.getDataSize();
        }
        return res;
    }

    private static int getSegmentsCellsCount(List<? extends Segment> list) {
        int res = 0;
        for (Segment segment : list) {
            res += segment.getCellsCount();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flattenOneSegment(long requesterVersion, CompactingMemStore.IndexType idxType, MemStoreCompactionStrategy.Action action) {
        if (requesterVersion != this.version) {
            LOG.warn("Segment flattening failed, because versions do not match. Requester version: " + requesterVersion + ", actual version: " + this.version);
            return false;
        }
        LinkedList<ImmutableSegment> linkedList = this.pipeline;
        synchronized (linkedList) {
            if (requesterVersion != this.version) {
                LOG.warn("Segment flattening failed, because versions do not match");
                return false;
            }
            int i = 0;
            for (ImmutableSegment s : this.pipeline) {
                if (s.canBeFlattened()) {
                    s.waitForUpdates();
                    NonThreadSafeMemStoreSizing newMemstoreAccounting = new NonThreadSafeMemStoreSizing();
                    ImmutableSegment newS = SegmentFactory.instance().createImmutableSegmentByFlattening((CSLMImmutableSegment)s, idxType, newMemstoreAccounting, action);
                    this.replaceAtIndex(i, newS);
                    if (this.region != null) {
                        MemStoreSize mss = newMemstoreAccounting.getMemStoreSize();
                        this.region.addMemStoreSize(mss.getDataSize(), mss.getHeapSize(), mss.getOffHeapSize(), mss.getCellsCount());
                    }
                    LOG.debug("Compaction pipeline segment {} flattened", (Object)s);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.readOnlyCopy.isEmpty();
    }

    public List<? extends Segment> getSegments() {
        return this.readOnlyCopy;
    }

    public long size() {
        return this.readOnlyCopy.size();
    }

    public long getMinSequenceId() {
        long minSequenceId = Long.MAX_VALUE;
        LinkedList<ImmutableSegment> localCopy = this.readOnlyCopy;
        if (!localCopy.isEmpty()) {
            minSequenceId = ((Segment)localCopy.getLast()).getMinSequenceId();
        }
        return minSequenceId;
    }

    public MemStoreSize getTailSize() {
        LinkedList<ImmutableSegment> localCopy = this.readOnlyCopy;
        return localCopy.isEmpty() ? new MemStoreSize() : ((Segment)localCopy.peekLast()).getMemStoreSize();
    }

    public MemStoreSize getPipelineSize() {
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        LinkedList<ImmutableSegment> localCopy = this.readOnlyCopy;
        for (Segment segment : localCopy) {
            memStoreSizing.incMemStoreSize(segment.getMemStoreSize());
        }
        return memStoreSizing.getMemStoreSize();
    }

    private void swapSuffix(List<? extends Segment> suffix, ImmutableSegment segment, boolean closeSegmentsInSuffix) {
        this.pipeline.removeAll(suffix);
        if (segment != null) {
            this.pipeline.addLast(segment);
        }
        if (closeSegmentsInSuffix) {
            for (Segment segment2 : suffix) {
                segment2.close();
            }
        }
    }

    private void replaceAtIndex(int idx, ImmutableSegment newSegment) {
        this.pipeline.set(idx, newSegment);
        this.readOnlyCopy = new LinkedList<ImmutableSegment>(this.pipeline);
    }

    public Segment getTail() {
        List<? extends Segment> localCopy = this.getSegments();
        if (localCopy.isEmpty()) {
            return null;
        }
        return localCopy.get(localCopy.size() - 1);
    }

    private boolean addFirst(ImmutableSegment segment) {
        this.pipeline.addFirst(segment);
        return true;
    }

    private boolean validateSuffixList(LinkedList<ImmutableSegment> suffix) {
        if (suffix.isEmpty()) {
            return true;
        }
        Iterator<ImmutableSegment> pipelineBackwardIterator = this.pipeline.descendingIterator();
        Iterator<ImmutableSegment> suffixBackwardIterator = suffix.descendingIterator();
        while (suffixBackwardIterator.hasNext()) {
            ImmutableSegment pipelineCurrent;
            if (!pipelineBackwardIterator.hasNext()) {
                return false;
            }
            ImmutableSegment suffixCurrent = suffixBackwardIterator.next();
            if (suffixCurrent == (pipelineCurrent = pipelineBackwardIterator.next())) continue;
            return false;
        }
        return true;
    }
}

