/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public class MultiRowMutationEndpoint
extends MultiRowMutationProtos.MultiRowMutationService
implements RegionCoprocessor {
    private RegionCoprocessorEnvironment env;

    public void mutateRows(RpcController controller, MultiRowMutationProtos.MutateRowsRequest request, RpcCallback<MultiRowMutationProtos.MutateRowsResponse> done) {
        MultiRowMutationProtos.MutateRowsResponse response = MultiRowMutationProtos.MutateRowsResponse.getDefaultInstance();
        try {
            TreeSet<byte[]> rowsToLock = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            List mutateRequestList = request.getMutationRequestList();
            ArrayList<Mutation> mutations = new ArrayList<Mutation>(mutateRequestList.size());
            for (Object m : mutateRequestList) {
                mutations.add(ProtobufUtil.toMutation((ClientProtos.MutationProto)m));
            }
            RegionInfo regionInfo = this.env.getRegion().getRegionInfo();
            for (Mutation m : mutations) {
                if (!HRegion.rowIsInRange(regionInfo, m.getRow())) {
                    String msg = "Requested row out of range '" + Bytes.toStringBinary((byte[])m.getRow()) + "'";
                    if (rowsToLock.isEmpty()) {
                        throw new WrongRegionException(msg);
                    }
                    throw new DoNotRetryIOException(msg);
                }
                rowsToLock.add(m.getRow());
            }
            long nonceGroup = request.hasNonceGroup() ? request.getNonceGroup() : 0L;
            long nonce = request.hasNonce() ? request.getNonce() : 0L;
            this.env.getRegion().mutateRowsWithLocks(mutations, rowsToLock, nonceGroup, nonce);
        }
        catch (IOException e) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)response);
    }

    public Iterable<Service> getServices() {
        return Collections.singleton(this);
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }
}

