/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.concurrent;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Striped;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.apache.hugegraph.util.E;

public class KeyLock {
    private Striped<Lock> locks;

    public KeyLock() {
        this(Runtime.getRuntime().availableProcessors() << 2);
    }

    public KeyLock(int size) {
        this.locks = Striped.lock(size);
    }

    private int indexOf(Lock lock) {
        for (int i = 0; i < this.locks.size(); ++i) {
            if (this.locks.getAt(i) != lock) continue;
            return i;
        }
        return -1;
    }

    public final Lock lock(Object key) {
        E.checkArgument(key != null, "Lock key can't be null", new Object[0]);
        Lock lock = this.locks.get(key);
        lock.lock();
        return lock;
    }

    public final void unlock(Object key) {
        E.checkArgument(key != null, "Unlock key can't be null", new Object[0]);
        this.locks.get(key).unlock();
    }

    public final List<Lock> lockAll(Object ... keys) {
        E.checkArgument(keys != null && keys.length > 0, "Lock keys can't be null or empty", new Object[0]);
        ArrayList<Lock> locks = new ArrayList<Lock>(keys.length);
        for (Object key : keys) {
            E.checkArgument(key != null, "Lock key can't be null", new Object[0]);
            Lock lock = this.locks.get(key);
            locks.add(lock);
        }
        locks.sort((a, b) -> {
            int diff = a.hashCode() - b.hashCode();
            if (diff == 0 && a != b) {
                diff = this.indexOf((Lock)a) - this.indexOf((Lock)b);
                assert (diff != 0);
            }
            return diff;
        });
        for (Lock lock : locks) {
            lock.lock();
        }
        return Collections.unmodifiableList(locks);
    }

    public List<Lock> lockAll(Object key1, Object key2) {
        E.checkArgument(key1 != null, "Lock key can't be null", new Object[0]);
        E.checkArgument(key2 != null, "Lock key can't be null", new Object[0]);
        Lock lock1 = this.locks.get(key1);
        Lock lock2 = this.locks.get(key2);
        int diff = lock1.hashCode() - lock2.hashCode();
        if (diff == 0 && lock1 != lock2) {
            diff = this.indexOf(lock1) - this.indexOf(lock2);
            assert (diff != 0);
        }
        ImmutableList<Lock> locks = diff > 0 ? ImmutableList.of(lock2, lock1) : ImmutableList.of(lock1, lock2);
        for (Lock lock : locks) {
            lock.lock();
        }
        return locks;
    }

    public final void unlockAll(List<Lock> locks) {
        E.checkArgument(locks != null, "Unlock locks can't be null", new Object[0]);
        for (int i = locks.size(); i > 0; --i) {
            assert (this.indexOf(locks.get(i - 1)) != -1);
            locks.get(i - 1).unlock();
        }
    }
}

