/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.graphs;

import com.google.common.collect.ImmutableMap;
import jakarta.ws.rs.core.MultivaluedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.exception.InvalidResponseException;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.GraphMode;
import org.apache.hugegraph.structure.constant.GraphReadMode;
import org.apache.hugegraph.structure.constant.HugeType;

public class GraphsAPI
extends API {
    private static final String DELIMITER = "/";
    private static final String MODE = "mode";
    private static final String GRAPH_READ_MODE = "graph_read_mode";
    private static final String CLEAR = "clear";
    private static final String CONFIRM_MESSAGE = "confirm_message";

    public GraphsAPI(RestClient client) {
        super(client);
        this.path(this.type());
    }

    @Override
    protected String type() {
        return HugeType.GRAPHS.string();
    }

    public Map<String, String> create(String name, String cloneGraphName, String configText) {
        this.client.checkApiVersion("0.67", "dynamic graph add");
        MultivaluedHashMap<String, Object> headers = new MultivaluedHashMap<String, Object>();
        headers.add("Content-Type", "text/plain");
        ImmutableMap<String, Object> params = null;
        if (StringUtils.isNotEmpty(cloneGraphName)) {
            params = ImmutableMap.of("clone_graph_name", cloneGraphName);
        }
        RestResult result = this.client.post(GraphsAPI.joinPath(this.path(), name), configText, headers, params);
        return result.readObject(Map.class);
    }

    public Map<String, String> get(String name) {
        RestResult result = this.client.get(this.path(), name);
        return result.readObject(Map.class);
    }

    public List<String> list() {
        RestResult result = this.client.get(this.path());
        return result.readList(this.type(), String.class);
    }

    public void clear(String graph, String message) {
        this.client.delete(GraphsAPI.joinPath(this.path(), graph, CLEAR), ImmutableMap.of(CONFIRM_MESSAGE, message));
    }

    public void drop(String graph, String message) {
        this.client.checkApiVersion("0.67", "dynamic graph delete");
        this.client.delete(GraphsAPI.joinPath(this.path(), graph), ImmutableMap.of(CONFIRM_MESSAGE, message));
    }

    public void mode(String graph, GraphMode mode) {
        this.client.put(GraphsAPI.joinPath(this.path(), graph, MODE), null, (Object)mode);
    }

    public GraphMode mode(String graph) {
        RestResult result = this.client.get(GraphsAPI.joinPath(this.path(), graph), MODE);
        Map mode = result.readObject(Map.class);
        String value = (String)mode.get(MODE);
        if (value == null) {
            throw new InvalidResponseException("Invalid response, expect 'mode' in response", new Object[0]);
        }
        try {
            return GraphMode.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidResponseException("Invalid GraphMode value '%s'", value);
        }
    }

    public void readMode(String graph, GraphReadMode readMode) {
        this.client.checkApiVersion("0.59", "graph read mode");
        this.client.put(GraphsAPI.joinPath(this.path(), graph, GRAPH_READ_MODE), null, (Object)readMode);
    }

    public GraphReadMode readMode(String graph) {
        this.client.checkApiVersion("0.59", "graph read mode");
        RestResult result = this.client.get(GraphsAPI.joinPath(this.path(), graph), GRAPH_READ_MODE);
        Map readMode = result.readObject(Map.class);
        String value = (String)readMode.get(GRAPH_READ_MODE);
        if (value == null) {
            throw new InvalidResponseException("Invalid response, expect 'graph_read_mode' in response", new Object[0]);
        }
        try {
            return GraphReadMode.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidResponseException("Invalid GraphReadMode value '%s'", value);
        }
    }

    private static String joinPath(String path, String graph) {
        return String.join((CharSequence)DELIMITER, path, graph);
    }

    private static String joinPath(String path, String graph, String action) {
        return String.join((CharSequence)DELIMITER, path, graph, action);
    }
}

