/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.graph.value;

import java.io.IOException;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.value.ValueType;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.util.E;

public class FloatValue
extends Number
implements Value.Tvalue<Float> {
    private static final long serialVersionUID = 6098857579782490901L;
    private float value;

    public FloatValue() {
        this(0.0f);
    }

    public FloatValue(float value) {
        this.value = value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Float value() {
        return Float.valueOf(this.value);
    }

    public void value(float value) {
        this.value = value;
    }

    @Override
    public ValueType valueType() {
        return ValueType.FLOAT;
    }

    @Override
    public void assign(Value other) {
        this.checkAssign(other);
        this.value = ((FloatValue)other).value;
    }

    @Override
    public FloatValue copy() {
        return new FloatValue(this.value);
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public void read(RandomAccessInput in) throws IOException {
        this.value = in.readFloat();
    }

    @Override
    public void write(RandomAccessOutput out) throws IOException {
        out.writeFloat(this.value);
    }

    @Override
    public int compareTo(Value obj) {
        E.checkArgumentNotNull((Object)obj, (String)"The compare argument can't be null", (Object[])new Object[0]);
        int typeDiff = this.valueType().compareTo(obj.valueType());
        if (typeDiff != 0) {
            return typeDiff;
        }
        return Float.compare(this.value, ((FloatValue)obj).value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FloatValue)) {
            return false;
        }
        return ((FloatValue)obj).value == this.value;
    }

    public int hashCode() {
        return Float.hashCode(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

