/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.community.wcc;

import java.util.Iterator;
import org.apache.hugegraph.computer.core.combiner.Combiner;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.worker.Computation;
import org.apache.hugegraph.computer.core.worker.ComputationContext;

public class Wcc
implements Computation<Id> {
    public String name() {
        return "wcc";
    }

    public String category() {
        return "community";
    }

    public void compute0(ComputationContext context, Vertex vertex) {
        Id min = vertex.id();
        for (Edge edge : vertex.edges()) {
            if (edge.targetId().compareTo((Object)min) >= 0) continue;
            min = edge.targetId();
        }
        Id value = min;
        vertex.value((Value)value);
        vertex.inactivate();
        context.sendMessageToAllEdgesIf(vertex, (Value)value, (result, target) -> result.compareTo(target) < 0);
    }

    public void compute(ComputationContext context, Vertex vertex, Iterator<Id> messages) {
        Id message = (Id)Combiner.combineAll((Combiner)context.combiner(), messages);
        Id value = (Id)vertex.value();
        if (value.compareTo((Object)message) > 0) {
            vertex.value((Value)message);
            context.sendMessageToAllEdges(vertex, (Value)message);
        }
        vertex.inactivate();
    }
}

