/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.centrality.closeness;

import java.util.Iterator;
import org.apache.hugegraph.computer.algorithm.centrality.closeness.ClosenessMessage;
import org.apache.hugegraph.computer.algorithm.centrality.closeness.ClosenessValue;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.value.DoubleValue;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.worker.Computation;
import org.apache.hugegraph.computer.core.worker.ComputationContext;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.NumericUtil;
import org.slf4j.Logger;

public class ClosenessCentrality
implements Computation<ClosenessMessage> {
    private static final Logger LOG = Log.logger(ClosenessCentrality.class);
    public static final String OPTION_WEIGHT_PROPERTY = "closeness_centrality.weight_property";
    public static final String OPTION_SAMPLE_RATE = "closeness_centrality.sample_rate";
    private String weightProp;
    private double sampleRate;

    public String name() {
        return "closeness_centrality";
    }

    public String category() {
        return "centrality";
    }

    public void init(Config config) {
        this.weightProp = config.getString(OPTION_WEIGHT_PROPERTY, "");
        this.sampleRate = config.getDouble(OPTION_SAMPLE_RATE, 1.0);
        if (this.sampleRate <= 0.0 || this.sampleRate > 1.0) {
            throw new ComputerException("The param %s must be in (0.0, 1.0], actual got '%s'", new Object[]{OPTION_SAMPLE_RATE, this.sampleRate});
        }
    }

    public void close(Config config) {
    }

    public void compute0(ComputationContext context, Vertex vertex) {
        vertex.value((Value)new ClosenessValue());
        for (Edge edge : vertex.edges()) {
            Id senderId = vertex.id();
            double value = this.weightValue(edge.property(this.weightProp));
            DoubleValue distance = new DoubleValue(value);
            ClosenessMessage message = new ClosenessMessage(senderId, senderId, distance);
            context.sendMessage(edge.targetId(), (Value)message);
        }
    }

    public void compute(ComputationContext context, Vertex vertex, Iterator<ClosenessMessage> messages) {
        Id selfId = vertex.id();
        ClosenessValue localValue = (ClosenessValue)vertex.value();
        boolean active = false;
        while (messages.hasNext()) {
            Id startId;
            active = true;
            ClosenessMessage message = messages.next();
            Id senderId = message.senderId();
            if (selfId.equals(senderId) || selfId.equals(startId = message.startId())) continue;
            DoubleValue oldValue = (DoubleValue)localValue.get(startId);
            DoubleValue newValue = message.distance();
            if (oldValue != null && newValue.compareTo((Value)oldValue) >= 0) continue;
            localValue.put(startId, (Value)newValue);
            this.sendMessage(context, vertex, senderId, startId, newValue);
        }
        if (!active) {
            vertex.inactivate();
        }
    }

    private void sendMessage(ComputationContext context, Vertex vertex, Id senderId, Id startId, DoubleValue newValue) {
        Id selfId = vertex.id();
        double baseNewValue = this.weightValue((Value)newValue);
        for (Edge edge : vertex.edges()) {
            Id targetId = edge.targetId();
            if (senderId.equals(targetId) || startId.equals(targetId) || !this.sample(selfId, targetId, edge)) continue;
            double updatedValue = baseNewValue + this.weightValue(edge.property(this.weightProp));
            DoubleValue newDistance = new DoubleValue(updatedValue);
            ClosenessMessage message = new ClosenessMessage(selfId, startId, newDistance);
            context.sendMessage(targetId, (Value)message);
        }
    }

    private boolean sample(Id sourceId, Id targetId, Edge edge) {
        return Math.random() <= this.sampleRate;
    }

    private double weightValue(Value rawValue) {
        if (rawValue == null) {
            return 1.0;
        }
        if (rawValue.isNumber()) {
            return NumericUtil.convertToNumber((Object)rawValue).doubleValue();
        }
        throw new ComputerException("The weight property can only be either Long or Int or Double or Float, but got %s", new Object[]{rawValue.valueType()});
    }
}

