/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hugegraph.util.E;

public class BarrierEvent {
    private final Lock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();
    private volatile boolean signaled = false;

    public void await() throws InterruptedException {
        this.lock.lock();
        try {
            while (!this.signaled) {
                this.cond.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout) throws InterruptedException {
        E.checkArgument(timeout >= 0L, "The time must be >= 0, but got '%d'.", timeout);
        long deadline = System.currentTimeMillis() + timeout;
        this.lock.lock();
        try {
            while (!this.signaled) {
                timeout = deadline - System.currentTimeMillis();
                if (timeout > 0L) {
                    this.cond.await(timeout, TimeUnit.MILLISECONDS);
                }
                if (System.currentTimeMillis() < deadline) continue;
                boolean bl = this.signaled;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    public void reset() {
        this.lock.lock();
        try {
            this.signaled = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void signal() {
        this.lock.lock();
        try {
            this.signaled = true;
            this.cond.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void signalAll() {
        this.lock.lock();
        try {
            this.signaled = true;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

