//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        v3.20.1
// source: storage.proto

package storagepb

import (
	commonpb "github.com/apache/incubator-horaedb-proto/golang/pkg/commonpb"
	horaeprompb "github.com/apache/incubator-horaedb-proto/golang/pkg/horaeprompb"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ArrowPayload_Compression int32

const (
	ArrowPayload_NONE ArrowPayload_Compression = 0
	ArrowPayload_ZSTD ArrowPayload_Compression = 1
)

// Enum value maps for ArrowPayload_Compression.
var (
	ArrowPayload_Compression_name = map[int32]string{
		0: "NONE",
		1: "ZSTD",
	}
	ArrowPayload_Compression_value = map[string]int32{
		"NONE": 0,
		"ZSTD": 1,
	}
)

func (x ArrowPayload_Compression) Enum() *ArrowPayload_Compression {
	p := new(ArrowPayload_Compression)
	*p = x
	return p
}

func (x ArrowPayload_Compression) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ArrowPayload_Compression) Descriptor() protoreflect.EnumDescriptor {
	return file_storage_proto_enumTypes[0].Descriptor()
}

func (ArrowPayload_Compression) Type() protoreflect.EnumType {
	return &file_storage_proto_enumTypes[0]
}

func (x ArrowPayload_Compression) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ArrowPayload_Compression.Descriptor instead.
func (ArrowPayload_Compression) EnumDescriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{15, 0}
}

type RequestContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
}

func (x *RequestContext) Reset() {
	*x = RequestContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestContext) ProtoMessage() {}

func (x *RequestContext) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestContext.ProtoReflect.Descriptor instead.
func (*RequestContext) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{0}
}

func (x *RequestContext) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

type RouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Context *RequestContext `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	Tables  []string        `protobuf:"bytes,2,rep,name=tables,proto3" json:"tables,omitempty"`
}

func (x *RouteRequest) Reset() {
	*x = RouteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteRequest) ProtoMessage() {}

func (x *RouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteRequest.ProtoReflect.Descriptor instead.
func (*RouteRequest) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{1}
}

func (x *RouteRequest) GetContext() *RequestContext {
	if x != nil {
		return x.Context
	}
	return nil
}

func (x *RouteRequest) GetTables() []string {
	if x != nil {
		return x.Tables
	}
	return nil
}

type Endpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ip   string `protobuf:"bytes,1,opt,name=ip,proto3" json:"ip,omitempty"`
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
}

func (x *Endpoint) Reset() {
	*x = Endpoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Endpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Endpoint) ProtoMessage() {}

func (x *Endpoint) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Endpoint.ProtoReflect.Descriptor instead.
func (*Endpoint) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{2}
}

func (x *Endpoint) GetIp() string {
	if x != nil {
		return x.Ip
	}
	return ""
}

func (x *Endpoint) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

type Route struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Table    string    `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	Endpoint *Endpoint `protobuf:"bytes,2,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
}

func (x *Route) Reset() {
	*x = Route{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Route) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Route) ProtoMessage() {}

func (x *Route) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Route.ProtoReflect.Descriptor instead.
func (*Route) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{3}
}

func (x *Route) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *Route) GetEndpoint() *Endpoint {
	if x != nil {
		return x.Endpoint
	}
	return nil
}

type RouteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *commonpb.ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Routes []*Route                 `protobuf:"bytes,2,rep,name=routes,proto3" json:"routes,omitempty"`
}

func (x *RouteResponse) Reset() {
	*x = RouteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteResponse) ProtoMessage() {}

func (x *RouteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteResponse.ProtoReflect.Descriptor instead.
func (*RouteResponse) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{4}
}

func (x *RouteResponse) GetHeader() *commonpb.ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *RouteResponse) GetRoutes() []*Route {
	if x != nil {
		return x.Routes
	}
	return nil
}

type Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//
	//	*Value_Float64Value
	//	*Value_StringValue
	//	*Value_Int64Value
	//	*Value_Float32Value
	//	*Value_Int32Value
	//	*Value_Int16Value
	//	*Value_Int8Value
	//	*Value_BoolValue
	//	*Value_Uint64Value
	//	*Value_Uint32Value
	//	*Value_Uint16Value
	//	*Value_Uint8Value
	//	*Value_TimestampValue
	//	*Value_VarbinaryValue
	Value isValue_Value `protobuf_oneof:"value"`
}

func (x *Value) Reset() {
	*x = Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value) ProtoMessage() {}

func (x *Value) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value.ProtoReflect.Descriptor instead.
func (*Value) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{5}
}

func (m *Value) GetValue() isValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Value) GetFloat64Value() float64 {
	if x, ok := x.GetValue().(*Value_Float64Value); ok {
		return x.Float64Value
	}
	return 0
}

func (x *Value) GetStringValue() string {
	if x, ok := x.GetValue().(*Value_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *Value) GetInt64Value() int64 {
	if x, ok := x.GetValue().(*Value_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (x *Value) GetFloat32Value() float32 {
	if x, ok := x.GetValue().(*Value_Float32Value); ok {
		return x.Float32Value
	}
	return 0
}

func (x *Value) GetInt32Value() int32 {
	if x, ok := x.GetValue().(*Value_Int32Value); ok {
		return x.Int32Value
	}
	return 0
}

func (x *Value) GetInt16Value() int32 {
	if x, ok := x.GetValue().(*Value_Int16Value); ok {
		return x.Int16Value
	}
	return 0
}

func (x *Value) GetInt8Value() int32 {
	if x, ok := x.GetValue().(*Value_Int8Value); ok {
		return x.Int8Value
	}
	return 0
}

func (x *Value) GetBoolValue() bool {
	if x, ok := x.GetValue().(*Value_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (x *Value) GetUint64Value() uint64 {
	if x, ok := x.GetValue().(*Value_Uint64Value); ok {
		return x.Uint64Value
	}
	return 0
}

func (x *Value) GetUint32Value() uint32 {
	if x, ok := x.GetValue().(*Value_Uint32Value); ok {
		return x.Uint32Value
	}
	return 0
}

func (x *Value) GetUint16Value() uint32 {
	if x, ok := x.GetValue().(*Value_Uint16Value); ok {
		return x.Uint16Value
	}
	return 0
}

func (x *Value) GetUint8Value() uint32 {
	if x, ok := x.GetValue().(*Value_Uint8Value); ok {
		return x.Uint8Value
	}
	return 0
}

func (x *Value) GetTimestampValue() int64 {
	if x, ok := x.GetValue().(*Value_TimestampValue); ok {
		return x.TimestampValue
	}
	return 0
}

func (x *Value) GetVarbinaryValue() []byte {
	if x, ok := x.GetValue().(*Value_VarbinaryValue); ok {
		return x.VarbinaryValue
	}
	return nil
}

type isValue_Value interface {
	isValue_Value()
}

type Value_Float64Value struct {
	Float64Value float64 `protobuf:"fixed64,1,opt,name=float64_value,json=float64Value,proto3,oneof"`
}

type Value_StringValue struct {
	StringValue string `protobuf:"bytes,2,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type Value_Int64Value struct {
	Int64Value int64 `protobuf:"varint,3,opt,name=int64_value,json=int64Value,proto3,oneof"`
}

type Value_Float32Value struct {
	Float32Value float32 `protobuf:"fixed32,4,opt,name=float32_value,json=float32Value,proto3,oneof"`
}

type Value_Int32Value struct {
	Int32Value int32 `protobuf:"varint,5,opt,name=int32_value,json=int32Value,proto3,oneof"`
}

type Value_Int16Value struct {
	Int16Value int32 `protobuf:"varint,6,opt,name=int16_value,json=int16Value,proto3,oneof"`
}

type Value_Int8Value struct {
	Int8Value int32 `protobuf:"varint,7,opt,name=int8_value,json=int8Value,proto3,oneof"`
}

type Value_BoolValue struct {
	BoolValue bool `protobuf:"varint,8,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

type Value_Uint64Value struct {
	Uint64Value uint64 `protobuf:"varint,9,opt,name=uint64_value,json=uint64Value,proto3,oneof"`
}

type Value_Uint32Value struct {
	Uint32Value uint32 `protobuf:"varint,10,opt,name=uint32_value,json=uint32Value,proto3,oneof"`
}

type Value_Uint16Value struct {
	Uint16Value uint32 `protobuf:"varint,11,opt,name=uint16_value,json=uint16Value,proto3,oneof"`
}

type Value_Uint8Value struct {
	Uint8Value uint32 `protobuf:"varint,12,opt,name=uint8_value,json=uint8Value,proto3,oneof"`
}

type Value_TimestampValue struct {
	TimestampValue int64 `protobuf:"varint,13,opt,name=timestamp_value,json=timestampValue,proto3,oneof"`
}

type Value_VarbinaryValue struct {
	VarbinaryValue []byte `protobuf:"bytes,14,opt,name=varbinary_value,json=varbinaryValue,proto3,oneof"`
}

func (*Value_Float64Value) isValue_Value() {}

func (*Value_StringValue) isValue_Value() {}

func (*Value_Int64Value) isValue_Value() {}

func (*Value_Float32Value) isValue_Value() {}

func (*Value_Int32Value) isValue_Value() {}

func (*Value_Int16Value) isValue_Value() {}

func (*Value_Int8Value) isValue_Value() {}

func (*Value_BoolValue) isValue_Value() {}

func (*Value_Uint64Value) isValue_Value() {}

func (*Value_Uint32Value) isValue_Value() {}

func (*Value_Uint16Value) isValue_Value() {}

func (*Value_Uint8Value) isValue_Value() {}

func (*Value_TimestampValue) isValue_Value() {}

func (*Value_VarbinaryValue) isValue_Value() {}

type Field struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NameIndex uint32 `protobuf:"varint,1,opt,name=name_index,json=nameIndex,proto3" json:"name_index,omitempty"`
	Value     *Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Field) Reset() {
	*x = Field{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field) ProtoMessage() {}

func (x *Field) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field.ProtoReflect.Descriptor instead.
func (*Field) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{6}
}

func (x *Field) GetNameIndex() uint32 {
	if x != nil {
		return x.NameIndex
	}
	return 0
}

func (x *Field) GetValue() *Value {
	if x != nil {
		return x.Value
	}
	return nil
}

type FieldGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Timestamp int64    `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Fields    []*Field `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *FieldGroup) Reset() {
	*x = FieldGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldGroup) ProtoMessage() {}

func (x *FieldGroup) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldGroup.ProtoReflect.Descriptor instead.
func (*FieldGroup) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{7}
}

func (x *FieldGroup) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *FieldGroup) GetFields() []*Field {
	if x != nil {
		return x.Fields
	}
	return nil
}

type Tag struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NameIndex uint32 `protobuf:"varint,1,opt,name=name_index,json=nameIndex,proto3" json:"name_index,omitempty"`
	Value     *Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Tag) Reset() {
	*x = Tag{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tag) ProtoMessage() {}

func (x *Tag) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tag.ProtoReflect.Descriptor instead.
func (*Tag) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{8}
}

func (x *Tag) GetNameIndex() uint32 {
	if x != nil {
		return x.NameIndex
	}
	return 0
}

func (x *Tag) GetValue() *Value {
	if x != nil {
		return x.Value
	}
	return nil
}

type WriteSeriesEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Tags        []*Tag        `protobuf:"bytes,1,rep,name=tags,proto3" json:"tags,omitempty"`
	FieldGroups []*FieldGroup `protobuf:"bytes,2,rep,name=field_groups,json=fieldGroups,proto3" json:"field_groups,omitempty"`
}

func (x *WriteSeriesEntry) Reset() {
	*x = WriteSeriesEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteSeriesEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteSeriesEntry) ProtoMessage() {}

func (x *WriteSeriesEntry) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteSeriesEntry.ProtoReflect.Descriptor instead.
func (*WriteSeriesEntry) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{9}
}

func (x *WriteSeriesEntry) GetTags() []*Tag {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *WriteSeriesEntry) GetFieldGroups() []*FieldGroup {
	if x != nil {
		return x.FieldGroups
	}
	return nil
}

type WriteTableRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Table      string              `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	TagNames   []string            `protobuf:"bytes,2,rep,name=tag_names,json=tagNames,proto3" json:"tag_names,omitempty"`
	FieldNames []string            `protobuf:"bytes,3,rep,name=field_names,json=fieldNames,proto3" json:"field_names,omitempty"`
	Entries    []*WriteSeriesEntry `protobuf:"bytes,4,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *WriteTableRequest) Reset() {
	*x = WriteTableRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteTableRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteTableRequest) ProtoMessage() {}

func (x *WriteTableRequest) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteTableRequest.ProtoReflect.Descriptor instead.
func (*WriteTableRequest) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{10}
}

func (x *WriteTableRequest) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *WriteTableRequest) GetTagNames() []string {
	if x != nil {
		return x.TagNames
	}
	return nil
}

func (x *WriteTableRequest) GetFieldNames() []string {
	if x != nil {
		return x.FieldNames
	}
	return nil
}

func (x *WriteTableRequest) GetEntries() []*WriteSeriesEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

type WriteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Context       *RequestContext      `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	TableRequests []*WriteTableRequest `protobuf:"bytes,2,rep,name=table_requests,json=tableRequests,proto3" json:"table_requests,omitempty"`
}

func (x *WriteRequest) Reset() {
	*x = WriteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteRequest) ProtoMessage() {}

func (x *WriteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteRequest.ProtoReflect.Descriptor instead.
func (*WriteRequest) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{11}
}

func (x *WriteRequest) GetContext() *RequestContext {
	if x != nil {
		return x.Context
	}
	return nil
}

func (x *WriteRequest) GetTableRequests() []*WriteTableRequest {
	if x != nil {
		return x.TableRequests
	}
	return nil
}

type WriteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header  *commonpb.ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Success uint32                   `protobuf:"varint,2,opt,name=success,proto3" json:"success,omitempty"`
	Failed  uint32                   `protobuf:"varint,3,opt,name=failed,proto3" json:"failed,omitempty"`
}

func (x *WriteResponse) Reset() {
	*x = WriteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteResponse) ProtoMessage() {}

func (x *WriteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteResponse.ProtoReflect.Descriptor instead.
func (*WriteResponse) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{12}
}

func (x *WriteResponse) GetHeader() *commonpb.ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *WriteResponse) GetSuccess() uint32 {
	if x != nil {
		return x.Success
	}
	return 0
}

func (x *WriteResponse) GetFailed() uint32 {
	if x != nil {
		return x.Failed
	}
	return 0
}

type SqlQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Context *RequestContext `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	Tables  []string        `protobuf:"bytes,2,rep,name=tables,proto3" json:"tables,omitempty"`
	Sql     string          `protobuf:"bytes,3,opt,name=sql,proto3" json:"sql,omitempty"`
}

func (x *SqlQueryRequest) Reset() {
	*x = SqlQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlQueryRequest) ProtoMessage() {}

func (x *SqlQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlQueryRequest.ProtoReflect.Descriptor instead.
func (*SqlQueryRequest) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{13}
}

func (x *SqlQueryRequest) GetContext() *RequestContext {
	if x != nil {
		return x.Context
	}
	return nil
}

func (x *SqlQueryRequest) GetTables() []string {
	if x != nil {
		return x.Tables
	}
	return nil
}

func (x *SqlQueryRequest) GetSql() string {
	if x != nil {
		return x.Sql
	}
	return ""
}

type SqlQueryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *commonpb.ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Types that are assignable to Output:
	//
	//	*SqlQueryResponse_AffectedRows
	//	*SqlQueryResponse_Arrow
	Output isSqlQueryResponse_Output `protobuf_oneof:"output"`
}

func (x *SqlQueryResponse) Reset() {
	*x = SqlQueryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlQueryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlQueryResponse) ProtoMessage() {}

func (x *SqlQueryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlQueryResponse.ProtoReflect.Descriptor instead.
func (*SqlQueryResponse) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{14}
}

func (x *SqlQueryResponse) GetHeader() *commonpb.ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (m *SqlQueryResponse) GetOutput() isSqlQueryResponse_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (x *SqlQueryResponse) GetAffectedRows() uint32 {
	if x, ok := x.GetOutput().(*SqlQueryResponse_AffectedRows); ok {
		return x.AffectedRows
	}
	return 0
}

func (x *SqlQueryResponse) GetArrow() *ArrowPayload {
	if x, ok := x.GetOutput().(*SqlQueryResponse_Arrow); ok {
		return x.Arrow
	}
	return nil
}

type isSqlQueryResponse_Output interface {
	isSqlQueryResponse_Output()
}

type SqlQueryResponse_AffectedRows struct {
	AffectedRows uint32 `protobuf:"varint,2,opt,name=affected_rows,json=affectedRows,proto3,oneof"`
}

type SqlQueryResponse_Arrow struct {
	Arrow *ArrowPayload `protobuf:"bytes,3,opt,name=arrow,proto3,oneof"`
}

func (*SqlQueryResponse_AffectedRows) isSqlQueryResponse_Output() {}

func (*SqlQueryResponse_Arrow) isSqlQueryResponse_Output() {}

type ArrowPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RecordBatches [][]byte                 `protobuf:"bytes,1,rep,name=record_batches,json=recordBatches,proto3" json:"record_batches,omitempty"`
	Compression   ArrowPayload_Compression `protobuf:"varint,2,opt,name=compression,proto3,enum=storage.ArrowPayload_Compression" json:"compression,omitempty"`
}

func (x *ArrowPayload) Reset() {
	*x = ArrowPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArrowPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArrowPayload) ProtoMessage() {}

func (x *ArrowPayload) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArrowPayload.ProtoReflect.Descriptor instead.
func (*ArrowPayload) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{15}
}

func (x *ArrowPayload) GetRecordBatches() [][]byte {
	if x != nil {
		return x.RecordBatches
	}
	return nil
}

func (x *ArrowPayload) GetCompression() ArrowPayload_Compression {
	if x != nil {
		return x.Compression
	}
	return ArrowPayload_NONE
}

type PrometheusQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Context *RequestContext   `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	Expr    *horaeprompb.Expr `protobuf:"bytes,2,opt,name=expr,proto3" json:"expr,omitempty"`
	// use oneof to represent option for scalar value
	// https://github.com/protocolbuffers/protobuf/issues/1606
	//
	// Types that are assignable to LookbackDelta:
	//
	//	*PrometheusQueryRequest_Delta
	LookbackDelta isPrometheusQueryRequest_LookbackDelta `protobuf_oneof:"lookback_delta"`
}

func (x *PrometheusQueryRequest) Reset() {
	*x = PrometheusQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrometheusQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrometheusQueryRequest) ProtoMessage() {}

func (x *PrometheusQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrometheusQueryRequest.ProtoReflect.Descriptor instead.
func (*PrometheusQueryRequest) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{16}
}

func (x *PrometheusQueryRequest) GetContext() *RequestContext {
	if x != nil {
		return x.Context
	}
	return nil
}

func (x *PrometheusQueryRequest) GetExpr() *horaeprompb.Expr {
	if x != nil {
		return x.Expr
	}
	return nil
}

func (m *PrometheusQueryRequest) GetLookbackDelta() isPrometheusQueryRequest_LookbackDelta {
	if m != nil {
		return m.LookbackDelta
	}
	return nil
}

func (x *PrometheusQueryRequest) GetDelta() int64 {
	if x, ok := x.GetLookbackDelta().(*PrometheusQueryRequest_Delta); ok {
		return x.Delta
	}
	return 0
}

type isPrometheusQueryRequest_LookbackDelta interface {
	isPrometheusQueryRequest_LookbackDelta()
}

type PrometheusQueryRequest_Delta struct {
	Delta int64 `protobuf:"varint,3,opt,name=delta,proto3,oneof"`
}

func (*PrometheusQueryRequest_Delta) isPrometheusQueryRequest_LookbackDelta() {}

type PrometheusQueryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *commonpb.ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Samples within a time series must be ordered by time.
	Timeseries []*horaeprompb.TimeSeries `protobuf:"bytes,2,rep,name=timeseries,proto3" json:"timeseries,omitempty"`
}

func (x *PrometheusQueryResponse) Reset() {
	*x = PrometheusQueryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrometheusQueryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrometheusQueryResponse) ProtoMessage() {}

func (x *PrometheusQueryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrometheusQueryResponse.ProtoReflect.Descriptor instead.
func (*PrometheusQueryResponse) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{17}
}

func (x *PrometheusQueryResponse) GetHeader() *commonpb.ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *PrometheusQueryResponse) GetTimeseries() []*horaeprompb.TimeSeries {
	if x != nil {
		return x.Timeseries
	}
	return nil
}

type PrometheusRemoteQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Context *RequestContext `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	// Encoded query for
	// https://github.com/prometheus/prometheus/blob/v2.43.0/prompb/remote.proto#L67
	Query []byte `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
}

func (x *PrometheusRemoteQueryRequest) Reset() {
	*x = PrometheusRemoteQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrometheusRemoteQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrometheusRemoteQueryRequest) ProtoMessage() {}

func (x *PrometheusRemoteQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrometheusRemoteQueryRequest.ProtoReflect.Descriptor instead.
func (*PrometheusRemoteQueryRequest) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{18}
}

func (x *PrometheusRemoteQueryRequest) GetContext() *RequestContext {
	if x != nil {
		return x.Context
	}
	return nil
}

func (x *PrometheusRemoteQueryRequest) GetQuery() []byte {
	if x != nil {
		return x.Query
	}
	return nil
}

type PrometheusRemoteQueryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *commonpb.ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Encoded response for
	// https://github.com/prometheus/prometheus/blob/v2.43.0/prompb/remote.proto#L74
	Response []byte `protobuf:"bytes,2,opt,name=response,proto3" json:"response,omitempty"`
}

func (x *PrometheusRemoteQueryResponse) Reset() {
	*x = PrometheusRemoteQueryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_storage_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrometheusRemoteQueryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrometheusRemoteQueryResponse) ProtoMessage() {}

func (x *PrometheusRemoteQueryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_storage_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrometheusRemoteQueryResponse.ProtoReflect.Descriptor instead.
func (*PrometheusRemoteQueryResponse) Descriptor() ([]byte, []int) {
	return file_storage_proto_rawDescGZIP(), []int{19}
}

func (x *PrometheusRemoteQueryResponse) GetHeader() *commonpb.ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *PrometheusRemoteQueryResponse) GetResponse() []byte {
	if x != nil {
		return x.Response
	}
	return nil
}

var File_storage_proto protoreflect.FileDescriptor

var file_storage_proto_rawDesc = []byte{
	0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x07, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x1a, 0x0c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x10, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65,
	0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x2c, 0x0a, 0x0e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x22, 0x59, 0x0a, 0x0c, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x73, 0x22, 0x2e, 0x0a, 0x08, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x70, 0x12, 0x12, 0x0a,
	0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x70, 0x6f, 0x72,
	0x74, 0x22, 0x4c, 0x0a, 0x05, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x12, 0x2d, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22,
	0x67, 0x0a, 0x0d, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x2e, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x12, 0x26, 0x0a, 0x06, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x0e, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x52, 0x06, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x22, 0x96, 0x04, 0x0a, 0x05, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x25, 0x0a, 0x0d, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x36, 0x34, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0c, 0x66, 0x6c, 0x6f,
	0x61, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21,
	0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x25, 0x0a, 0x0d, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x33, 0x32, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x0c, 0x66, 0x6c, 0x6f, 0x61,
	0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x33,
	0x32, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52,
	0x0a, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x69,
	0x6e, 0x74, 0x31, 0x36, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05,
	0x48, 0x00, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x31, 0x36, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f,
	0x0a, 0x0a, 0x69, 0x6e, 0x74, 0x38, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x05, 0x48, 0x00, 0x52, 0x09, 0x69, 0x6e, 0x74, 0x38, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x1f, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x23, 0x0a, 0x0c, 0x75, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x04, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x69, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x75, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x00, 0x52, 0x0b, 0x75,
	0x69, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x75, 0x69,
	0x6e, 0x74, 0x31, 0x36, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0d,
	0x48, 0x00, 0x52, 0x0b, 0x75, 0x69, 0x6e, 0x74, 0x31, 0x36, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x21, 0x0a, 0x0b, 0x75, 0x69, 0x6e, 0x74, 0x38, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0d, 0x48, 0x00, 0x52, 0x0a, 0x75, 0x69, 0x6e, 0x74, 0x38, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x29, 0x0a, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0e, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x29, 0x0a,
	0x0f, 0x76, 0x61, 0x72, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0e, 0x76, 0x61, 0x72, 0x62, 0x69, 0x6e,
	0x61, 0x72, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x22, 0x4c, 0x0a, 0x05, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x61,
	0x6d, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09,
	0x6e, 0x61, 0x6d, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x24, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0x52, 0x0a, 0x0a, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x1c, 0x0a,
	0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x26, 0x0a, 0x06, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x06, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x73, 0x22, 0x4a, 0x0a, 0x03, 0x54, 0x61, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x61,
	0x6d, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09,
	0x6e, 0x61, 0x6d, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x24, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0x6c, 0x0a, 0x10, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x20, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x0c, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x61, 0x67, 0x52,
	0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x36, 0x0a, 0x0c, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x52, 0x0b, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x22, 0x9c, 0x01,
	0x0a, 0x11, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x61, 0x67,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x74, 0x61,
	0x67, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x33, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0x84, 0x01, 0x0a,
	0x0c, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x12, 0x41, 0x0a, 0x0e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x52, 0x0d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x73, 0x22, 0x71, 0x0a, 0x0d, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2e, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06,
	0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x22, 0x6e, 0x0a, 0x0f, 0x53, 0x71, 0x6c, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a, 0x07, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x16, 0x0a, 0x06,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x71, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x73, 0x71, 0x6c, 0x22, 0xa2, 0x01, 0x0a, 0x10, 0x53, 0x71, 0x6c, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2e, 0x0a, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x25, 0x0a, 0x0d, 0x61,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0d, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x52, 0x6f,
	0x77, 0x73, 0x12, 0x2d, 0x0a, 0x05, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x15, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x41, 0x72, 0x72, 0x6f,
	0x77, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x05, 0x61, 0x72, 0x72, 0x6f,
	0x77, 0x42, 0x08, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x22, 0x9d, 0x01, 0x0a, 0x0c,
	0x41, 0x72, 0x72, 0x6f, 0x77, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x25, 0x0a, 0x0e,
	0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0c, 0x52, 0x0d, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x73, 0x12, 0x43, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x41, 0x72, 0x72, 0x6f, 0x77, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e,
	0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x63, 0x6f, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x21, 0x0a, 0x0b, 0x43, 0x6f, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10,
	0x00, 0x12, 0x08, 0x0a, 0x04, 0x5a, 0x53, 0x54, 0x44, 0x10, 0x01, 0x22, 0x9b, 0x01, 0x0a, 0x16,
	0x50, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x24, 0x0a, 0x04, 0x65, 0x78, 0x70,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74,
	0x68, 0x65, 0x75, 0x73, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x52, 0x04, 0x65, 0x78, 0x70, 0x72, 0x12,
	0x16, 0x0a, 0x05, 0x64, 0x65, 0x6c, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00,
	0x52, 0x05, 0x64, 0x65, 0x6c, 0x74, 0x61, 0x42, 0x10, 0x0a, 0x0e, 0x6c, 0x6f, 0x6f, 0x6b, 0x62,
	0x61, 0x63, 0x6b, 0x5f, 0x64, 0x65, 0x6c, 0x74, 0x61, 0x22, 0x81, 0x01, 0x0a, 0x17, 0x50, 0x72,
	0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2e, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x36, 0x0a, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x72, 0x6f, 0x6d,
	0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x22, 0x67, 0x0a,
	0x1c, 0x50, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x52, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x22, 0x6b, 0x0a, 0x1d, 0x50, 0x72, 0x6f, 0x6d, 0x65, 0x74,
	0x68, 0x65, 0x75, 0x73, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2e, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x32, 0x8a, 0x04, 0x0a, 0x0e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x38, 0x0a, 0x05, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12,
	0x15, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x12, 0x38, 0x0a, 0x05, 0x57, 0x72, 0x69, 0x74, 0x65, 0x12, 0x15, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x40, 0x0a, 0x0b, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x57, 0x72, 0x69, 0x74, 0x65, 0x12, 0x15, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x12, 0x41, 0x0a, 0x08,
	0x53, 0x71, 0x6c, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x18, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x53, 0x71, 0x6c, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x19, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x53, 0x71, 0x6c,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12,
	0x49, 0x0a, 0x0e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x71, 0x6c, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x18, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x53, 0x71, 0x6c, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x53, 0x71, 0x6c, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x30, 0x01, 0x12, 0x62, 0x0a, 0x0f, 0x50, 0x72,
	0x6f, 0x6d, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x25, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65,
	0x75, 0x73, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x50,
	0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x50,
	0x0a, 0x09, 0x50, 0x72, 0x6f, 0x6d, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1f, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75,
	0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x42, 0x6c, 0x0a, 0x21, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x68,
	0x6f, 0x72, 0x61, 0x65, 0x64, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x42, 0x07, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5a, 0x3e,
	0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2f, 0x69, 0x6e, 0x63, 0x75, 0x62, 0x61, 0x74, 0x6f, 0x72, 0x2d, 0x68, 0x6f, 0x72, 0x61,
	0x65, 0x64, 0x62, 0x2d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x70, 0x62, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_storage_proto_rawDescOnce sync.Once
	file_storage_proto_rawDescData = file_storage_proto_rawDesc
)

func file_storage_proto_rawDescGZIP() []byte {
	file_storage_proto_rawDescOnce.Do(func() {
		file_storage_proto_rawDescData = protoimpl.X.CompressGZIP(file_storage_proto_rawDescData)
	})
	return file_storage_proto_rawDescData
}

var file_storage_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_storage_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_storage_proto_goTypes = []interface{}{
	(ArrowPayload_Compression)(0),         // 0: storage.ArrowPayload.Compression
	(*RequestContext)(nil),                // 1: storage.RequestContext
	(*RouteRequest)(nil),                  // 2: storage.RouteRequest
	(*Endpoint)(nil),                      // 3: storage.Endpoint
	(*Route)(nil),                         // 4: storage.Route
	(*RouteResponse)(nil),                 // 5: storage.RouteResponse
	(*Value)(nil),                         // 6: storage.Value
	(*Field)(nil),                         // 7: storage.Field
	(*FieldGroup)(nil),                    // 8: storage.FieldGroup
	(*Tag)(nil),                           // 9: storage.Tag
	(*WriteSeriesEntry)(nil),              // 10: storage.WriteSeriesEntry
	(*WriteTableRequest)(nil),             // 11: storage.WriteTableRequest
	(*WriteRequest)(nil),                  // 12: storage.WriteRequest
	(*WriteResponse)(nil),                 // 13: storage.WriteResponse
	(*SqlQueryRequest)(nil),               // 14: storage.SqlQueryRequest
	(*SqlQueryResponse)(nil),              // 15: storage.SqlQueryResponse
	(*ArrowPayload)(nil),                  // 16: storage.ArrowPayload
	(*PrometheusQueryRequest)(nil),        // 17: storage.PrometheusQueryRequest
	(*PrometheusQueryResponse)(nil),       // 18: storage.PrometheusQueryResponse
	(*PrometheusRemoteQueryRequest)(nil),  // 19: storage.PrometheusRemoteQueryRequest
	(*PrometheusRemoteQueryResponse)(nil), // 20: storage.PrometheusRemoteQueryResponse
	(*commonpb.ResponseHeader)(nil),       // 21: common.ResponseHeader
	(*horaeprompb.Expr)(nil),              // 22: prometheus.Expr
	(*horaeprompb.TimeSeries)(nil),        // 23: prometheus.TimeSeries
}
var file_storage_proto_depIdxs = []int32{
	1,  // 0: storage.RouteRequest.context:type_name -> storage.RequestContext
	3,  // 1: storage.Route.endpoint:type_name -> storage.Endpoint
	21, // 2: storage.RouteResponse.header:type_name -> common.ResponseHeader
	4,  // 3: storage.RouteResponse.routes:type_name -> storage.Route
	6,  // 4: storage.Field.value:type_name -> storage.Value
	7,  // 5: storage.FieldGroup.fields:type_name -> storage.Field
	6,  // 6: storage.Tag.value:type_name -> storage.Value
	9,  // 7: storage.WriteSeriesEntry.tags:type_name -> storage.Tag
	8,  // 8: storage.WriteSeriesEntry.field_groups:type_name -> storage.FieldGroup
	10, // 9: storage.WriteTableRequest.entries:type_name -> storage.WriteSeriesEntry
	1,  // 10: storage.WriteRequest.context:type_name -> storage.RequestContext
	11, // 11: storage.WriteRequest.table_requests:type_name -> storage.WriteTableRequest
	21, // 12: storage.WriteResponse.header:type_name -> common.ResponseHeader
	1,  // 13: storage.SqlQueryRequest.context:type_name -> storage.RequestContext
	21, // 14: storage.SqlQueryResponse.header:type_name -> common.ResponseHeader
	16, // 15: storage.SqlQueryResponse.arrow:type_name -> storage.ArrowPayload
	0,  // 16: storage.ArrowPayload.compression:type_name -> storage.ArrowPayload.Compression
	1,  // 17: storage.PrometheusQueryRequest.context:type_name -> storage.RequestContext
	22, // 18: storage.PrometheusQueryRequest.expr:type_name -> prometheus.Expr
	21, // 19: storage.PrometheusQueryResponse.header:type_name -> common.ResponseHeader
	23, // 20: storage.PrometheusQueryResponse.timeseries:type_name -> prometheus.TimeSeries
	1,  // 21: storage.PrometheusRemoteQueryRequest.context:type_name -> storage.RequestContext
	21, // 22: storage.PrometheusRemoteQueryResponse.header:type_name -> common.ResponseHeader
	2,  // 23: storage.StorageService.Route:input_type -> storage.RouteRequest
	12, // 24: storage.StorageService.Write:input_type -> storage.WriteRequest
	12, // 25: storage.StorageService.StreamWrite:input_type -> storage.WriteRequest
	14, // 26: storage.StorageService.SqlQuery:input_type -> storage.SqlQueryRequest
	14, // 27: storage.StorageService.StreamSqlQuery:input_type -> storage.SqlQueryRequest
	19, // 28: storage.StorageService.PromRemoteQuery:input_type -> storage.PrometheusRemoteQueryRequest
	17, // 29: storage.StorageService.PromQuery:input_type -> storage.PrometheusQueryRequest
	5,  // 30: storage.StorageService.Route:output_type -> storage.RouteResponse
	13, // 31: storage.StorageService.Write:output_type -> storage.WriteResponse
	13, // 32: storage.StorageService.StreamWrite:output_type -> storage.WriteResponse
	15, // 33: storage.StorageService.SqlQuery:output_type -> storage.SqlQueryResponse
	15, // 34: storage.StorageService.StreamSqlQuery:output_type -> storage.SqlQueryResponse
	20, // 35: storage.StorageService.PromRemoteQuery:output_type -> storage.PrometheusRemoteQueryResponse
	18, // 36: storage.StorageService.PromQuery:output_type -> storage.PrometheusQueryResponse
	30, // [30:37] is the sub-list for method output_type
	23, // [23:30] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_storage_proto_init() }
func file_storage_proto_init() {
	if File_storage_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_storage_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Endpoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Route); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Tag); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteSeriesEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteTableRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlQueryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArrowPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrometheusQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrometheusQueryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrometheusRemoteQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_storage_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrometheusRemoteQueryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_storage_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*Value_Float64Value)(nil),
		(*Value_StringValue)(nil),
		(*Value_Int64Value)(nil),
		(*Value_Float32Value)(nil),
		(*Value_Int32Value)(nil),
		(*Value_Int16Value)(nil),
		(*Value_Int8Value)(nil),
		(*Value_BoolValue)(nil),
		(*Value_Uint64Value)(nil),
		(*Value_Uint32Value)(nil),
		(*Value_Uint16Value)(nil),
		(*Value_Uint8Value)(nil),
		(*Value_TimestampValue)(nil),
		(*Value_VarbinaryValue)(nil),
	}
	file_storage_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*SqlQueryResponse_AffectedRows)(nil),
		(*SqlQueryResponse_Arrow)(nil),
	}
	file_storage_proto_msgTypes[16].OneofWrappers = []interface{}{
		(*PrometheusQueryRequest_Delta)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_storage_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_storage_proto_goTypes,
		DependencyIndexes: file_storage_proto_depIdxs,
		EnumInfos:         file_storage_proto_enumTypes,
		MessageInfos:      file_storage_proto_msgTypes,
	}.Build()
	File_storage_proto = out.File
	file_storage_proto_rawDesc = nil
	file_storage_proto_goTypes = nil
	file_storage_proto_depIdxs = nil
}
