//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        v3.20.1
// source: cluster.proto

package clusterpb

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type NodeState int32

const (
	NodeState_ONLINE  NodeState = 0
	NodeState_OFFLINE NodeState = 1
)

// Enum value maps for NodeState.
var (
	NodeState_name = map[int32]string{
		0: "ONLINE",
		1: "OFFLINE",
	}
	NodeState_value = map[string]int32{
		"ONLINE":  0,
		"OFFLINE": 1,
	}
)

func (x NodeState) Enum() *NodeState {
	p := new(NodeState)
	*p = x
	return p
}

func (x NodeState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeState) Descriptor() protoreflect.EnumDescriptor {
	return file_cluster_proto_enumTypes[0].Descriptor()
}

func (NodeState) Type() protoreflect.EnumType {
	return &file_cluster_proto_enumTypes[0]
}

func (x NodeState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeState.Descriptor instead.
func (NodeState) EnumDescriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{0}
}

type ShardRole int32

const (
	ShardRole_LEADER   ShardRole = 0
	ShardRole_FOLLOWER ShardRole = 1
)

// Enum value maps for ShardRole.
var (
	ShardRole_name = map[int32]string{
		0: "LEADER",
		1: "FOLLOWER",
	}
	ShardRole_value = map[string]int32{
		"LEADER":   0,
		"FOLLOWER": 1,
	}
)

func (x ShardRole) Enum() *ShardRole {
	p := new(ShardRole)
	*p = x
	return p
}

func (x ShardRole) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ShardRole) Descriptor() protoreflect.EnumDescriptor {
	return file_cluster_proto_enumTypes[1].Descriptor()
}

func (ShardRole) Type() protoreflect.EnumType {
	return &file_cluster_proto_enumTypes[1]
}

func (x ShardRole) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ShardRole.Descriptor instead.
func (ShardRole) EnumDescriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{1}
}

type Cluster_TopologyType int32

const (
	Cluster_UNKNOWN Cluster_TopologyType = 0
	Cluster_STATIC  Cluster_TopologyType = 1
	Cluster_DYNAMIC Cluster_TopologyType = 2
)

// Enum value maps for Cluster_TopologyType.
var (
	Cluster_TopologyType_name = map[int32]string{
		0: "UNKNOWN",
		1: "STATIC",
		2: "DYNAMIC",
	}
	Cluster_TopologyType_value = map[string]int32{
		"UNKNOWN": 0,
		"STATIC":  1,
		"DYNAMIC": 2,
	}
)

func (x Cluster_TopologyType) Enum() *Cluster_TopologyType {
	p := new(Cluster_TopologyType)
	*p = x
	return p
}

func (x Cluster_TopologyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_TopologyType) Descriptor() protoreflect.EnumDescriptor {
	return file_cluster_proto_enumTypes[2].Descriptor()
}

func (Cluster_TopologyType) Type() protoreflect.EnumType {
	return &file_cluster_proto_enumTypes[2]
}

func (x Cluster_TopologyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_TopologyType.Descriptor instead.
func (Cluster_TopologyType) EnumDescriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{5, 0}
}

type ClusterView_ClusterState int32

const (
	ClusterView_EMPTY             ClusterView_ClusterState = 0
	ClusterView_PREPARE_REBALANCE ClusterView_ClusterState = 1
	ClusterView_AWAITING_CLOSE    ClusterView_ClusterState = 2
	ClusterView_AWAITING_OPEN     ClusterView_ClusterState = 3
	ClusterView_STABLE            ClusterView_ClusterState = 4
)

// Enum value maps for ClusterView_ClusterState.
var (
	ClusterView_ClusterState_name = map[int32]string{
		0: "EMPTY",
		1: "PREPARE_REBALANCE",
		2: "AWAITING_CLOSE",
		3: "AWAITING_OPEN",
		4: "STABLE",
	}
	ClusterView_ClusterState_value = map[string]int32{
		"EMPTY":             0,
		"PREPARE_REBALANCE": 1,
		"AWAITING_CLOSE":    2,
		"AWAITING_OPEN":     3,
		"STABLE":            4,
	}
)

func (x ClusterView_ClusterState) Enum() *ClusterView_ClusterState {
	p := new(ClusterView_ClusterState)
	*p = x
	return p
}

func (x ClusterView_ClusterState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClusterView_ClusterState) Descriptor() protoreflect.EnumDescriptor {
	return file_cluster_proto_enumTypes[3].Descriptor()
}

func (ClusterView_ClusterState) Type() protoreflect.EnumType {
	return &file_cluster_proto_enumTypes[3]
}

func (x ClusterView_ClusterState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClusterView_ClusterState.Descriptor instead.
func (ClusterView_ClusterState) EnumDescriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{6, 0}
}

type PartitionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Info:
	//
	//	*PartitionInfo_Hash
	//	*PartitionInfo_Key
	//	*PartitionInfo_Random
	Info isPartitionInfo_Info `protobuf_oneof:"info"`
}

func (x *PartitionInfo) Reset() {
	*x = PartitionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cluster_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionInfo) ProtoMessage() {}

func (x *PartitionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionInfo.ProtoReflect.Descriptor instead.
func (*PartitionInfo) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{0}
}

func (m *PartitionInfo) GetInfo() isPartitionInfo_Info {
	if m != nil {
		return m.Info
	}
	return nil
}

func (x *PartitionInfo) GetHash() *HashPartitionInfo {
	if x, ok := x.GetInfo().(*PartitionInfo_Hash); ok {
		return x.Hash
	}
	return nil
}

func (x *PartitionInfo) GetKey() *KeyPartitionInfo {
	if x, ok := x.GetInfo().(*PartitionInfo_Key); ok {
		return x.Key
	}
	return nil
}

func (x *PartitionInfo) GetRandom() *RandomPartitionInfo {
	if x, ok := x.GetInfo().(*PartitionInfo_Random); ok {
		return x.Random
	}
	return nil
}

type isPartitionInfo_Info interface {
	isPartitionInfo_Info()
}

type PartitionInfo_Hash struct {
	Hash *HashPartitionInfo `protobuf:"bytes,1,opt,name=hash,proto3,oneof"`
}

type PartitionInfo_Key struct {
	Key *KeyPartitionInfo `protobuf:"bytes,2,opt,name=key,proto3,oneof"`
}

type PartitionInfo_Random struct {
	Random *RandomPartitionInfo `protobuf:"bytes,3,opt,name=random,proto3,oneof"`
}

func (*PartitionInfo_Hash) isPartitionInfo_Info() {}

func (*PartitionInfo_Key) isPartitionInfo_Info() {}

func (*PartitionInfo_Random) isPartitionInfo_Info() {}

type PartitionDefinition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are assignable to OriginName:
	//
	//	*PartitionDefinition_Origin
	OriginName isPartitionDefinition_OriginName `protobuf_oneof:"origin_name"`
}

func (x *PartitionDefinition) Reset() {
	*x = PartitionDefinition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cluster_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionDefinition) ProtoMessage() {}

func (x *PartitionDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionDefinition.ProtoReflect.Descriptor instead.
func (*PartitionDefinition) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *PartitionDefinition) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *PartitionDefinition) GetOriginName() isPartitionDefinition_OriginName {
	if m != nil {
		return m.OriginName
	}
	return nil
}

func (x *PartitionDefinition) GetOrigin() string {
	if x, ok := x.GetOriginName().(*PartitionDefinition_Origin); ok {
		return x.Origin
	}
	return ""
}

type isPartitionDefinition_OriginName interface {
	isPartitionDefinition_OriginName()
}

type PartitionDefinition_Origin struct {
	Origin string `protobuf:"bytes,2,opt,name=origin,proto3,oneof"`
}

func (*PartitionDefinition_Origin) isPartitionDefinition_OriginName() {}

type HashPartitionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version     int32                  `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Definitions []*PartitionDefinition `protobuf:"bytes,2,rep,name=definitions,proto3" json:"definitions,omitempty"`
	Expr        []byte                 `protobuf:"bytes,3,opt,name=expr,proto3" json:"expr,omitempty"`
	Linear      bool                   `protobuf:"varint,4,opt,name=linear,proto3" json:"linear,omitempty"`
}

func (x *HashPartitionInfo) Reset() {
	*x = HashPartitionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cluster_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HashPartitionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HashPartitionInfo) ProtoMessage() {}

func (x *HashPartitionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HashPartitionInfo.ProtoReflect.Descriptor instead.
func (*HashPartitionInfo) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *HashPartitionInfo) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *HashPartitionInfo) GetDefinitions() []*PartitionDefinition {
	if x != nil {
		return x.Definitions
	}
	return nil
}

func (x *HashPartitionInfo) GetExpr() []byte {
	if x != nil {
		return x.Expr
	}
	return nil
}

func (x *HashPartitionInfo) GetLinear() bool {
	if x != nil {
		return x.Linear
	}
	return false
}

type KeyPartitionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version      int32                  `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Definitions  []*PartitionDefinition `protobuf:"bytes,2,rep,name=definitions,proto3" json:"definitions,omitempty"`
	PartitionKey []string               `protobuf:"bytes,3,rep,name=partition_key,json=partitionKey,proto3" json:"partition_key,omitempty"`
	Linear       bool                   `protobuf:"varint,4,opt,name=linear,proto3" json:"linear,omitempty"`
}

func (x *KeyPartitionInfo) Reset() {
	*x = KeyPartitionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cluster_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyPartitionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyPartitionInfo) ProtoMessage() {}

func (x *KeyPartitionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyPartitionInfo.ProtoReflect.Descriptor instead.
func (*KeyPartitionInfo) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *KeyPartitionInfo) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *KeyPartitionInfo) GetDefinitions() []*PartitionDefinition {
	if x != nil {
		return x.Definitions
	}
	return nil
}

func (x *KeyPartitionInfo) GetPartitionKey() []string {
	if x != nil {
		return x.PartitionKey
	}
	return nil
}

func (x *KeyPartitionInfo) GetLinear() bool {
	if x != nil {
		return x.Linear
	}
	return false
}

type RandomPartitionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Definitions []*PartitionDefinition `protobuf:"bytes,1,rep,name=definitions,proto3" json:"definitions,omitempty"`
}

func (x *RandomPartitionInfo) Reset() {
	*x = RandomPartitionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cluster_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RandomPartitionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RandomPartitionInfo) ProtoMessage() {}

func (x *RandomPartitionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RandomPartitionInfo.ProtoReflect.Descriptor instead.
func (*RandomPartitionInfo) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{4}
}

func (x *RandomPartitionInfo) GetDefinitions() []*PartitionDefinition {
	if x != nil {
		return x.Definitions
	}
	return nil
}

// example:
// cluster 1: v1/cluster/1 -> horaemeta.Cluster
// cluster 2: v1/cluster/2 -> horaemeta.Cluster
type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id           uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Name         string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	MinNodeCount uint32 `protobuf:"varint,3,opt,name=min_node_count,json=minNodeCount,proto3" json:"min_node_count,omitempty"`
	// the number of shard replication
	ReplicationFactor uint32 `protobuf:"varint,4,opt,name=replication_factor,json=replicationFactor,proto3" json:"replication_factor,omitempty"`
	ShardTotal        uint32 `protobuf:"varint,5,opt,name=shard_total,json=shardTotal,proto3" json:"shard_total,omitempty"`
	CreatedAt         uint64 `protobuf:"varint,6,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Deprecated: This field is deprecated after HoraeDB v1.2.0 .
	PartitionTableRatioOfNodes uint32               `protobuf:"varint,7,opt,name=partition_table_ratio_of_nodes,json=partitionTableRatioOfNodes,proto3" json:"partition_table_ratio_of_nodes,omitempty"`
	ModifiedAt                 uint64               `protobuf:"varint,8,opt,name=modified_at,json=modifiedAt,proto3" json:"modified_at,omitempty"`
	EnableSchedule             bool                 `protobuf:"varint,9,opt,name=enable_schedule,json=enableSchedule,proto3" json:"enable_schedule,omitempty"`
	TopologyType               Cluster_TopologyType `protobuf:"varint,10,opt,name=topology_type,json=topologyType,proto3,enum=cluster.Cluster_TopologyType" json:"topology_type,omitempty"`
	// The maximum number of concurrent executing procedures in a single
	// `BatchProcedure`, it is only used in `TransferLeaderBatchProcedure` now.
	ProcedureExecutingBatchSize uint32 `protobuf:"varint,11,opt,name=procedure_executing_batch_size,json=procedureExecutingBatchSize,proto3" json:"procedure_executing_batch_size,omitempty"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cluster_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *Cluster) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetMinNodeCount() uint32 {
	if x != nil {
		return x.MinNodeCount
	}
	return 0
}

func (x *Cluster) GetReplicationFactor() uint32 {
	if x != nil {
		return x.ReplicationFactor
	}
	return 0
}

func (x *Cluster) GetShardTotal() uint32 {
	if x != nil {
		return x.ShardTotal
	}
	return 0
}

func (x *Cluster) GetCreatedAt() uint64 {
	if x != nil {
		return x.CreatedAt
	}
	return 0
}

func (x *Cluster) GetPartitionTableRatioOfNodes() uint32 {
	if x != nil {
		return x.PartitionTableRatioOfNodes
	}
	return 0
}

func (x *Cluster) GetModifiedAt() uint64 {
	if x != nil {
		return x.ModifiedAt
	}
	return 0
}

func (x *Cluster) GetEnableSchedule() bool {
	if x != nil {
		return x.EnableSchedule
	}
	return false
}

func (x *Cluster) GetTopologyType() Cluster_TopologyType {
	if x != nil {
		return x.TopologyType
	}
	return Cluster_UNKNOWN
}

func (x *Cluster) GetProcedureExecutingBatchSize() uint32 {
	if x != nil {
		return x.ProcedureExecutingBatchSize
	}
	return 0
}

// example:
// cluster 1: v1/cluster/1/view/latest_version -> 99
//
//	v1/cluster/1/view/99 -> horaemeta.ClusterView
//	v1/cluster/1/view/98 -> horaemeta.ClusterView
type ClusterView struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClusterId  uint32                   `protobuf:"varint,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	Version    uint64                   `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	State      ClusterView_ClusterState `protobuf:"varint,3,opt,name=state,proto3,enum=cluster.ClusterView_ClusterState" json:"state,omitempty"`
	ShardNodes []*ShardNode             `protobuf:"bytes,4,rep,name=shard_nodes,json=shardNodes,proto3" json:"shard_nodes,omitempty"`
	// cluster view's changed cause
	Cause     string `protobuf:"bytes,5,opt,name=cause,proto3" json:"cause,omitempty"`
	CreatedAt uint64 `protobuf:"varint,6,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
}

func (x *ClusterView) Reset() {
	*x = ClusterView{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cluster_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterView) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterView) ProtoMessage() {}

func (x *ClusterView) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterView.ProtoReflect.Descriptor instead.
func (*ClusterView) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *ClusterView) GetClusterId() uint32 {
	if x != nil {
		return x.ClusterId
	}
	return 0
}

func (x *ClusterView) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *ClusterView) GetState() ClusterView_ClusterState {
	if x != nil {
		return x.State
	}
	return ClusterView_EMPTY
}

func (x *ClusterView) GetShardNodes() []*ShardNode {
	if x != nil {
		return x.ShardNodes
	}
	return nil
}

func (x *ClusterView) GetCause() string {
	if x != nil {
		return x.Cause
	}
	return ""
}

func (x *ClusterView) GetCreatedAt() uint64 {
	if x != nil {
		return x.CreatedAt
	}
	return 0
}

type ShardNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id        uint32    `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	ShardRole ShardRole `protobuf:"varint,2,opt,name=shard_role,json=shardRole,proto3,enum=cluster.ShardRole" json:"shard_role,omitempty"`
	Node      string    `protobuf:"bytes,3,opt,name=node,proto3" json:"node,omitempty"`
}

func (x *ShardNode) Reset() {
	*x = ShardNode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cluster_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShardNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShardNode) ProtoMessage() {}

func (x *ShardNode) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShardNode.ProtoReflect.Descriptor instead.
func (*ShardNode) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *ShardNode) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *ShardNode) GetShardRole() ShardRole {
	if x != nil {
		return x.ShardRole
	}
	return ShardRole_LEADER
}

func (x *ShardNode) GetNode() string {
	if x != nil {
		return x.Node
	}
	return ""
}

// example:
// cluster 1: v1/cluster/1/schema/1 -> horaemeta.Schema
//
//	v1/cluster/1/schema/2 -> horaemeta.Schema
//	v1/cluster/1/schema/3 -> horaemeta.Schema
type Schema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id        uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	ClusterId uint32 `protobuf:"varint,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	Name      string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	CreatedAt uint64 `protobuf:"varint,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
}

func (x *Schema) Reset() {
	*x = Schema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cluster_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Schema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema) ProtoMessage() {}

func (x *Schema) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema.ProtoReflect.Descriptor instead.
func (*Schema) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{8}
}

func (x *Schema) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Schema) GetClusterId() uint32 {
	if x != nil {
		return x.ClusterId
	}
	return 0
}

func (x *Schema) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Schema) GetCreatedAt() uint64 {
	if x != nil {
		return x.CreatedAt
	}
	return 0
}

// example:
// cluster 1: v1/cluster/1/schema/1/table/1 -> horaemeta.Table
//
//	v1/cluster/1/schema/1/table/2 -> horaemeta.Table
//	v1/cluster/1/schema/1/table/3 -> horaemeta.Table
//	v1/cluster/1/schema/2/table/4 -> horaemeta.Table
//
// cluster 1 tableName-> ID :
//
//	v1/cluster/1/schema/1/table_name_to_id/table1 -> 1
//	v1/cluster/1/schema/1/table_name_to_id/table2 -> 2
//	v1/cluster/1/schema/1/table_name_to_id/table3 -> 3
//	v1/cluster/1/schema/2/table_name_to_id/table4 -> 4
type Table struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id            uint64         `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Name          string         `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	SchemaId      uint32         `protobuf:"varint,3,opt,name=schema_id,json=schemaId,proto3" json:"schema_id,omitempty"`
	Desc          string         `protobuf:"bytes,4,opt,name=desc,proto3" json:"desc,omitempty"`
	CreatedAt     uint64         `protobuf:"varint,5,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	PartitionInfo *PartitionInfo `protobuf:"bytes,6,opt,name=partition_info,json=partitionInfo,proto3" json:"partition_info,omitempty"`
}

func (x *Table) Reset() {
	*x = Table{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cluster_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Table) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Table) ProtoMessage() {}

func (x *Table) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Table.ProtoReflect.Descriptor instead.
func (*Table) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{9}
}

func (x *Table) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Table) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Table) GetSchemaId() uint32 {
	if x != nil {
		return x.SchemaId
	}
	return 0
}

func (x *Table) GetDesc() string {
	if x != nil {
		return x.Desc
	}
	return ""
}

func (x *Table) GetCreatedAt() uint64 {
	if x != nil {
		return x.CreatedAt
	}
	return 0
}

func (x *Table) GetPartitionInfo() *PartitionInfo {
	if x != nil {
		return x.PartitionInfo
	}
	return nil
}

// example:
// cluster 1: v1/cluster/1/shard_view/1/latest_version -> 9
//
//	v1/cluster/1/shard_view/1/9 -> horaemeta.ShardView
//	v1/cluster/1/shard_view/1/8 -> horaemeta.ShardView
//	v1/cluster/1/shard_view/2/latest_version -> 3
//	v1/cluster/1/shard_view/2/3 -> horaemeta.ShardView
type ShardView struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ShardId   uint32   `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	Version   uint64   `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	TableIds  []uint64 `protobuf:"varint,3,rep,packed,name=table_ids,json=tableIds,proto3" json:"table_ids,omitempty"`
	CreatedAt uint64   `protobuf:"varint,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
}

func (x *ShardView) Reset() {
	*x = ShardView{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cluster_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShardView) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShardView) ProtoMessage() {}

func (x *ShardView) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShardView.ProtoReflect.Descriptor instead.
func (*ShardView) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{10}
}

func (x *ShardView) GetShardId() uint32 {
	if x != nil {
		return x.ShardId
	}
	return 0
}

func (x *ShardView) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *ShardView) GetTableIds() []uint64 {
	if x != nil {
		return x.TableIds
	}
	return nil
}

func (x *ShardView) GetCreatedAt() uint64 {
	if x != nil {
		return x.CreatedAt
	}
	return 0
}

// example:
// cluster 1: v1/cluster/1/node/127.0.0.1:8081 -> value is horaemeta.Node
//
//	v1/cluster/1/node/127.0.0.2:8081 -> value is horaemeta.Node
type Node struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name          string     `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Stats         *NodeStats `protobuf:"bytes,2,opt,name=stats,proto3" json:"stats,omitempty"`
	LastTouchTime uint64     `protobuf:"varint,3,opt,name=last_touch_time,json=lastTouchTime,proto3" json:"last_touch_time,omitempty"`
	State         NodeState  `protobuf:"varint,4,opt,name=state,proto3,enum=cluster.NodeState" json:"state,omitempty"`
}

func (x *Node) Reset() {
	*x = Node{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cluster_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Node) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Node) ProtoMessage() {}

func (x *Node) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Node.ProtoReflect.Descriptor instead.
func (*Node) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{11}
}

func (x *Node) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Node) GetStats() *NodeStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

func (x *Node) GetLastTouchTime() uint64 {
	if x != nil {
		return x.LastTouchTime
	}
	return 0
}

func (x *Node) GetState() NodeState {
	if x != nil {
		return x.State
	}
	return NodeState_ONLINE
}

type NodeStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Lease       uint32 `protobuf:"varint,1,opt,name=lease,proto3" json:"lease,omitempty"`
	Zone        string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	NodeVersion string `protobuf:"bytes,3,opt,name=node_version,json=nodeVersion,proto3" json:"node_version,omitempty"`
}

func (x *NodeStats) Reset() {
	*x = NodeStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cluster_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeStats) ProtoMessage() {}

func (x *NodeStats) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeStats.ProtoReflect.Descriptor instead.
func (*NodeStats) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{12}
}

func (x *NodeStats) GetLease() uint32 {
	if x != nil {
		return x.Lease
	}
	return 0
}

func (x *NodeStats) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *NodeStats) GetNodeVersion() string {
	if x != nil {
		return x.NodeVersion
	}
	return ""
}

var File_cluster_proto protoreflect.FileDescriptor

var file_cluster_proto_rawDesc = []byte{
	0x0a, 0x0d, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0xb0, 0x01, 0x0a, 0x0d, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x30, 0x0a, 0x04, 0x68, 0x61,
	0x73, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x04, 0x68, 0x61, 0x73, 0x68, 0x12, 0x2d, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x4b, 0x65, 0x79, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x36, 0x0a, 0x06, 0x72,
	0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x52, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x06, 0x72, 0x61, 0x6e,
	0x64, 0x6f, 0x6d, 0x42, 0x06, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x52, 0x0a, 0x13, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e,
	0x42, 0x0d, 0x0a, 0x0b, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x99, 0x01, 0x0a, 0x11, 0x48, 0x61, 0x73, 0x68, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x3e, 0x0a, 0x0b, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x12, 0x0a, 0x04, 0x65, 0x78, 0x70, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x65,
	0x78, 0x70, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x06, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x72, 0x22, 0xa9, 0x01, 0x0a, 0x10,
	0x4b, 0x65, 0x79, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x0b, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x64,
	0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12,
	0x16, 0x0a, 0x06, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x06, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x72, 0x22, 0x55, 0x0a, 0x13, 0x52, 0x61, 0x6e, 0x64, 0x6f,
	0x6d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3e,
	0x0a, 0x0b, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0b, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x8f,
	0x04, 0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x24,
	0x0a, 0x0e, 0x6d, 0x69, 0x6e, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x4e, 0x6f, 0x64, 0x65, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x11, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x63,
	0x74, 0x6f, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x54,
	0x6f, 0x74, 0x61, 0x6c, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x61, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x41, 0x74, 0x12, 0x42, 0x0a, 0x1e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x5f, 0x6f, 0x66, 0x5f,
	0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x1a, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x61, 0x74, 0x69, 0x6f,
	0x4f, 0x66, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x6f, 0x64, 0x69, 0x66,
	0x69, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x6d, 0x6f,
	0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x41, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0e, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x12, 0x42, 0x0a, 0x0d, 0x74, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x54, 0x6f, 0x70, 0x6f, 0x6c,
	0x6f, 0x67, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x74, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x43, 0x0a, 0x1e, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x64, 0x75,
	0x72, 0x65, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x1b, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x64, 0x75, 0x72, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x42, 0x61, 0x74, 0x63, 0x68, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x34, 0x0a, 0x0c, 0x54, 0x6f,
	0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e,
	0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x41, 0x54, 0x49,
	0x43, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x10, 0x02,
	0x22, 0xce, 0x02, 0x0a, 0x0b, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x56, 0x69, 0x65, 0x77,
	0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x56, 0x69, 0x65, 0x77, 0x2e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x33, 0x0a, 0x0b, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x6e, 0x6f, 0x64, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x0a, 0x73, 0x68, 0x61,
	0x72, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x22, 0x63, 0x0a, 0x0c,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x09, 0x0a, 0x05,
	0x45, 0x4d, 0x50, 0x54, 0x59, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x52, 0x45, 0x50, 0x41,
	0x52, 0x45, 0x5f, 0x52, 0x45, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x12,
	0x0a, 0x0e, 0x41, 0x57, 0x41, 0x49, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x4c, 0x4f, 0x53, 0x45,
	0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x41, 0x57, 0x41, 0x49, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x4f,
	0x50, 0x45, 0x4e, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10,
	0x04, 0x22, 0x62, 0x0a, 0x09, 0x53, 0x68, 0x61, 0x72, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x31,
	0x0a, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x12, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x68, 0x61,
	0x72, 0x64, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x09, 0x73, 0x68, 0x61, 0x72, 0x64, 0x52, 0x6f, 0x6c,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x6f, 0x64, 0x65, 0x22, 0x6a, 0x0a, 0x06, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41,
	0x74, 0x22, 0xba, 0x01, 0x0a, 0x05, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x08, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04,
	0x64, 0x65, 0x73, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x64, 0x65, 0x73, 0x63,
	0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12,
	0x3d, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x7c,
	0x0a, 0x09, 0x53, 0x68, 0x61, 0x72, 0x64, 0x56, 0x69, 0x65, 0x77, 0x12, 0x19, 0x0a, 0x08, 0x73,
	0x68, 0x61, 0x72, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x73,
	0x68, 0x61, 0x72, 0x64, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x1b, 0x0a, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x04, 0x52, 0x08, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x64, 0x73, 0x12, 0x1d, 0x0a,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x22, 0x96, 0x01, 0x0a,
	0x04, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x74, 0x6f, 0x75, 0x63,
	0x68, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0d, 0x6c, 0x61,
	0x73, 0x74, 0x54, 0x6f, 0x75, 0x63, 0x68, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x58, 0x0a, 0x09, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x05, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x6e, 0x6f, 0x64, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2a,
	0x24, 0x0a, 0x09, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0a, 0x0a, 0x06,
	0x4f, 0x4e, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4f, 0x46, 0x46, 0x4c,
	0x49, 0x4e, 0x45, 0x10, 0x01, 0x2a, 0x25, 0x0a, 0x09, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x6f,
	0x6c, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x45, 0x41, 0x44, 0x45, 0x52, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x46, 0x4f, 0x4c, 0x4c, 0x4f, 0x57, 0x45, 0x52, 0x10, 0x01, 0x42, 0x40, 0x5a, 0x3e,
	0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2f, 0x69, 0x6e, 0x63, 0x75, 0x62, 0x61, 0x74, 0x6f, 0x72, 0x2d, 0x68, 0x6f, 0x72, 0x61,
	0x65, 0x64, 0x62, 0x2d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x70, 0x62, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_cluster_proto_rawDescOnce sync.Once
	file_cluster_proto_rawDescData = file_cluster_proto_rawDesc
)

func file_cluster_proto_rawDescGZIP() []byte {
	file_cluster_proto_rawDescOnce.Do(func() {
		file_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(file_cluster_proto_rawDescData)
	})
	return file_cluster_proto_rawDescData
}

var file_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_cluster_proto_goTypes = []interface{}{
	(NodeState)(0),                // 0: cluster.NodeState
	(ShardRole)(0),                // 1: cluster.ShardRole
	(Cluster_TopologyType)(0),     // 2: cluster.Cluster.TopologyType
	(ClusterView_ClusterState)(0), // 3: cluster.ClusterView.ClusterState
	(*PartitionInfo)(nil),         // 4: cluster.PartitionInfo
	(*PartitionDefinition)(nil),   // 5: cluster.PartitionDefinition
	(*HashPartitionInfo)(nil),     // 6: cluster.HashPartitionInfo
	(*KeyPartitionInfo)(nil),      // 7: cluster.KeyPartitionInfo
	(*RandomPartitionInfo)(nil),   // 8: cluster.RandomPartitionInfo
	(*Cluster)(nil),               // 9: cluster.Cluster
	(*ClusterView)(nil),           // 10: cluster.ClusterView
	(*ShardNode)(nil),             // 11: cluster.ShardNode
	(*Schema)(nil),                // 12: cluster.Schema
	(*Table)(nil),                 // 13: cluster.Table
	(*ShardView)(nil),             // 14: cluster.ShardView
	(*Node)(nil),                  // 15: cluster.Node
	(*NodeStats)(nil),             // 16: cluster.NodeStats
}
var file_cluster_proto_depIdxs = []int32{
	6,  // 0: cluster.PartitionInfo.hash:type_name -> cluster.HashPartitionInfo
	7,  // 1: cluster.PartitionInfo.key:type_name -> cluster.KeyPartitionInfo
	8,  // 2: cluster.PartitionInfo.random:type_name -> cluster.RandomPartitionInfo
	5,  // 3: cluster.HashPartitionInfo.definitions:type_name -> cluster.PartitionDefinition
	5,  // 4: cluster.KeyPartitionInfo.definitions:type_name -> cluster.PartitionDefinition
	5,  // 5: cluster.RandomPartitionInfo.definitions:type_name -> cluster.PartitionDefinition
	2,  // 6: cluster.Cluster.topology_type:type_name -> cluster.Cluster.TopologyType
	3,  // 7: cluster.ClusterView.state:type_name -> cluster.ClusterView.ClusterState
	11, // 8: cluster.ClusterView.shard_nodes:type_name -> cluster.ShardNode
	1,  // 9: cluster.ShardNode.shard_role:type_name -> cluster.ShardRole
	4,  // 10: cluster.Table.partition_info:type_name -> cluster.PartitionInfo
	16, // 11: cluster.Node.stats:type_name -> cluster.NodeStats
	0,  // 12: cluster.Node.state:type_name -> cluster.NodeState
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_cluster_proto_init() }
func file_cluster_proto_init() {
	if File_cluster_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_cluster_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cluster_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionDefinition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cluster_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HashPartitionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cluster_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyPartitionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cluster_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RandomPartitionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cluster_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cluster_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClusterView); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cluster_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShardNode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cluster_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Schema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cluster_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Table); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cluster_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShardView); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cluster_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Node); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cluster_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_cluster_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*PartitionInfo_Hash)(nil),
		(*PartitionInfo_Key)(nil),
		(*PartitionInfo_Random)(nil),
	}
	file_cluster_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*PartitionDefinition_Origin)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_cluster_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_cluster_proto_goTypes,
		DependencyIndexes: file_cluster_proto_depIdxs,
		EnumInfos:         file_cluster_proto_enumTypes,
		MessageInfos:      file_cluster_proto_msgTypes,
	}.Build()
	File_cluster_proto = out.File
	file_cluster_proto_rawDesc = nil
	file_cluster_proto_goTypes = nil
	file_cluster_proto_depIdxs = nil
}
