/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.messages.PlcPingResponse;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.s7.readwrite.TPKTPacket;
import org.apache.plc4x.java.s7.readwrite.protocol.S7HMux;
import org.apache.plc4x.java.s7.readwrite.protocol.S7HMuxImpl;
import org.apache.plc4x.java.spi.configuration.ConfigurationFactory;
import org.apache.plc4x.java.spi.configuration.PlcConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.connection.ChannelFactory;
import org.apache.plc4x.java.spi.connection.DefaultNettyPlcConnection;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.events.CloseConnectionEvent;
import org.apache.plc4x.java.spi.events.ConnectedEvent;
import org.apache.plc4x.java.spi.events.DisconnectEvent;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7HPlcConnection
extends DefaultNettyPlcConnection
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(S7HPlcConnection.class);
    private static final String MULTIPLEXER = "MULTIPLEXER";
    private Boolean closed = false;
    private ScheduledFuture<?> scf = null;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("plc4x-s7ha-thread-%d").daemon(true).priority(10).build());
    protected final ChannelFactory secondaryChannelFactory;
    protected Channel primaryChannel = null;
    protected Channel secondaryChannel = null;
    protected final MessageToMessageCodec<ByteBuf, ByteBuf> s7hmux;
    protected int slicePing = 0;
    protected int sliceRetryTime = 0;

    public S7HPlcConnection(boolean canPing, boolean canRead, boolean canWrite, boolean canSubscribe, boolean canBrowse, PlcTagHandler tagHandler, PlcValueHandler valueHandler, PlcConnectionConfiguration configuration, ChannelFactory channelFactory, ChannelFactory secondaryChannelFactory, boolean fireDiscoverEvent, boolean awaitSessionSetupComplete, boolean awaitSessionDisconnectComplete, boolean awaitSessionDiscoverComplete, ProtocolStackConfigurer<TPKTPacket> stackConfigurer, BaseOptimizer optimizer, PlcAuthentication authentication) {
        super(canPing, canRead, canWrite, canSubscribe, canBrowse, tagHandler, valueHandler, configuration, channelFactory, fireDiscoverEvent, awaitSessionSetupComplete, awaitSessionDisconnectComplete, awaitSessionDiscoverComplete, stackConfigurer, optimizer, authentication);
        this.secondaryChannelFactory = secondaryChannelFactory;
        this.s7hmux = new S7HMuxImpl();
    }

    public void connect() throws PlcConnectionException {
        try {
            CompletableFuture sessionSetupCompleteFuture = new CompletableFuture();
            CompletableFuture sessionDiscoveredCompleteFuture = new CompletableFuture();
            if (this.channelFactory == null) {
                throw new PlcConnectionException("No primary channel factory provided");
            }
            ConfigurationFactory.configure((PlcConfiguration)this.configuration, (Object)this.channelFactory);
            if (this.secondaryChannelFactory != null) {
                ConfigurationFactory.configure((PlcConfiguration)this.configuration, (Object)this.secondaryChannelFactory);
            }
            if (this.channel == null) {
                this.channel = new EmbeddedChannel(new ChannelHandler[]{this.getChannelHandler(sessionSetupCompleteFuture, this.sessionDisconnectCompleteFuture, sessionDiscoveredCompleteFuture)});
                this.channel.pipeline().addFirst(new ChannelHandler[]{new LoggingHandler("DOOM")});
                this.channel.pipeline().addFirst("Multiplexor", this.s7hmux);
            }
            ((S7HMux)this.s7hmux).setEmbededhannel(this.channel, this.configuration);
            this.doPrimaryTcpConnections();
            if (this.secondaryChannelFactory != null) {
                this.doSecondaryTcpConnections();
            }
            if (this.primaryChannel == null && this.secondaryChannel == null) {
                this.sendChannelDisconectEvent();
                throw new PlcConnectionException("Connection is not possible.");
            }
            this.scf = this.executor.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.SECONDS);
            this.sendChannelCreatedEvent();
            if (this.awaitSessionSetupComplete) {
                sessionSetupCompleteFuture.get();
            }
            this.connected = true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PlcConnectionException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new PlcConnectionException((Throwable)e);
        }
    }

    public void close() throws PlcConnectionException {
        if (this.closed.booleanValue()) {
            return;
        }
        try {
            this.scf.cancel(true);
        }
        catch (Exception ex) {
            logger.info(ex.toString());
        }
        if (this.primaryChannel != null && this.primaryChannel.isActive()) {
            try {
                this.primaryChannel.pipeline().remove(MULTIPLEXER);
                this.primaryChannel.pipeline().fireUserEventTriggered((Object)new CloseConnectionEvent());
                this.primaryChannel.eventLoop().shutdownGracefully();
            }
            catch (Exception ex) {
                logger.info(ex.toString());
            }
        }
        if (this.secondaryChannel != null && this.secondaryChannel.isActive()) {
            this.secondaryChannel.pipeline().remove(MULTIPLEXER);
            this.secondaryChannel.pipeline().fireUserEventTriggered((Object)new CloseConnectionEvent());
            this.secondaryChannel.eventLoop().shutdownGracefully();
        }
        this.channel.pipeline().fireUserEventTriggered((Object)new DisconnectEvent());
        this.scf.cancel(true);
        this.executor.shutdown();
        this.closed = true;
    }

    public boolean isConnected() {
        return (Boolean)this.channel.attr(S7HMuxImpl.IS_CONNECTED).get();
    }

    public void doPrimaryTcpConnections() {
        try {
            this.primaryChannel = this.channelFactory.createChannel((ChannelHandler)new LoggingHandler(LogLevel.TRACE));
        }
        catch (Exception ex) {
            this.primaryChannel = null;
            logger.info(ex.toString());
        }
        if (this.primaryChannel != null && this.primaryChannel.isActive()) {
            this.primaryChannel.pipeline().addFirst(MULTIPLEXER, this.s7hmux);
            ((S7HMux)this.s7hmux).setPrimaryChannel(this.primaryChannel);
        }
    }

    public void doSecondaryTcpConnections() {
        try {
            this.secondaryChannel = this.secondaryChannelFactory.createChannel((ChannelHandler)new LoggingHandler(LogLevel.TRACE));
        }
        catch (Exception ex) {
            this.secondaryChannel = null;
            logger.info(ex.toString());
        }
        if (this.secondaryChannel != null && this.secondaryChannel.isActive()) {
            this.secondaryChannel.pipeline().addFirst(MULTIPLEXER, this.s7hmux);
            ((S7HMux)this.s7hmux).setSecondaryChannel(this.secondaryChannel);
        }
    }

    protected void sendChannelDisconectEvent() {
        logger.trace("Channels was not created, firing DisconnectEvent Event");
        this.channel.pipeline().fireUserEventTriggered((Object)new DisconnectEvent());
    }

    @Override
    public void run() {
        if (((Boolean)this.channel.attr(S7HMuxImpl.WAS_CONNECTED).get()).booleanValue() && ((Boolean)this.channel.attr(S7HMuxImpl.IS_CONNECTED).get()).booleanValue()) {
            this.channel.attr(S7HMuxImpl.WAS_CONNECTED).set((Object)false);
            this.channel.pipeline().fireUserEventTriggered((Object)new ConnectedEvent());
        }
        if (((Boolean)this.channel.attr(S7HMuxImpl.IS_PING_ACTIVE).get()).booleanValue()) {
            if (this.slicePing >= (Integer)this.channel.attr(S7HMuxImpl.PING_TIME).get()) {
                this.ping();
                this.slicePing = 0;
            }
            ++this.slicePing;
        } else {
            this.slicePing = 0;
        }
        if (this.sliceRetryTime >= (Integer)this.channel.attr(S7HMuxImpl.RETRY_TIME).get()) {
            if (this.primaryChannel != null) {
                if (!this.primaryChannel.isActive()) {
                    logger.info("Creating prymary connection.");
                    this.primaryChannel.eventLoop().shutdownGracefully();
                    this.doPrimaryTcpConnections();
                } else if (this.secondaryChannel == null && ((Boolean)this.channel.attr(S7HMuxImpl.WAS_CONNECTED).get()).booleanValue() && !((Boolean)this.channel.attr(S7HMuxImpl.IS_CONNECTED).get()).booleanValue()) {
                    logger.info("Reconnecting primary channel.");
                    if (((S7HMux)this.s7hmux).getTCPChannel() != null) {
                        ((S7HMux)this.s7hmux).setPrimaryChannel(this.primaryChannel);
                    }
                }
            } else {
                logger.info("Creating firts prymary connection.");
                this.doPrimaryTcpConnections();
            }
            if (this.secondaryChannel != null) {
                if (!this.secondaryChannel.isActive()) {
                    logger.info("Creating secondary connection.");
                    this.secondaryChannel.eventLoop().shutdownGracefully();
                    this.doSecondaryTcpConnections();
                } else if (this.primaryChannel == null && ((Boolean)this.channel.attr(S7HMuxImpl.WAS_CONNECTED).get()).booleanValue() && !((Boolean)this.channel.attr(S7HMuxImpl.IS_CONNECTED).get()).booleanValue()) {
                    logger.info("Reconnecting secondary channel.");
                    if (((S7HMux)this.s7hmux).getTCPChannel() != null) {
                        ((S7HMux)this.s7hmux).setSecondaryChannel(this.secondaryChannel);
                    }
                }
            } else if (this.secondaryChannelFactory != null) {
                logger.info("Creating firts secondary connection.");
                this.doSecondaryTcpConnections();
            }
            this.sliceRetryTime = 0;
        }
        if ((Integer)this.channel.attr(S7HMuxImpl.RETRY_TIME).get() > 0) {
            ++this.sliceRetryTime;
        }
        this.connected = (Boolean)this.channel.attr(S7HMuxImpl.IS_CONNECTED).get();
        logger.trace("*************************************************\r\nINSTAMCIA PRIMARIO      : " + (this.primaryChannel == null ? "NULL" : this.primaryChannel.toString()) + "\r\n" + "ACTIVO PRIMARIO         : " + (this.primaryChannel == null ? "NULL" : Boolean.valueOf(this.primaryChannel.isActive())) + "\r\n" + "INSTAMCIA SECUNDARIO    : " + (this.secondaryChannel == null ? "NULL" : this.secondaryChannel.toString()) + "\r\n" + "ACTIVO SECUNDARIO       : " + (this.secondaryChannel == null ? "NULL" : Boolean.valueOf(this.secondaryChannel.isActive())) + "\r\n" + "CANAL CONECTADO?        : " + this.channel.attr(S7HMuxImpl.IS_CONNECTED).get() + "\r\n" + "CANAL ESTUVO CONECTADO? : " + this.channel.attr(S7HMuxImpl.WAS_CONNECTED).get() + "\r\n" + "CONTADORES              : " + this.slicePing + " : " + this.sliceRetryTime + "\r\n" + "*************************************************");
    }

    public CompletableFuture<? extends PlcPingResponse> ping() {
        if (((Boolean)this.channel.attr(S7HMuxImpl.IS_CONNECTED).get()).booleanValue()) {
            this.executor.execute(() -> {
                PlcReadRequest.Builder builder = this.readRequestBuilder();
                builder.addTagAddress("value", "%MX1.0:BOOL");
                PlcReadRequest readRequest = builder.build();
                try {
                    PlcReadResponse readResponse = (PlcReadResponse)readRequest.execute().get(2L, TimeUnit.SECONDS);
                    logger.debug("PING: " + readResponse.getResponseCode("value"));
                }
                catch (Exception ex) {
                    logger.info("PING: " + ex);
                }
            });
        }
        return null;
    }
}

