/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.queue.impl;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hertzbeat.common.config.CommonProperties;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.common.serialize.KafkaMetricsDataDeserializer;
import org.apache.hertzbeat.common.serialize.KafkaMetricsDataSerializer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="common.queue", name={"type"}, havingValue="kafka")
public class KafkaCommonDataQueue
implements CommonDataQueue,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(KafkaCommonDataQueue.class);
    private final ReentrantLock metricDataToAlertLock = new ReentrantLock();
    private final ReentrantLock metricDataToStorageLock = new ReentrantLock();
    private final ReentrantLock serviceDiscoveryDataLock = new ReentrantLock();
    private final LinkedBlockingQueue<CollectRep.MetricsData> metricsDataToAlertQueue;
    private final LinkedBlockingQueue<CollectRep.MetricsData> metricsDataToStorageQueue;
    private final LinkedBlockingQueue<CollectRep.MetricsData> serviceDiscoveryDataQueue;
    private final CommonProperties.KafkaProperties kafka;
    private KafkaProducer<Long, CollectRep.MetricsData> metricsDataProducer;
    private KafkaConsumer<Long, CollectRep.MetricsData> metricsDataToAlertConsumer;
    private KafkaConsumer<Long, CollectRep.MetricsData> metricsDataToStorageConsumer;
    private KafkaConsumer<Long, CollectRep.MetricsData> serviceDiscoveryDataConsumer;

    public KafkaCommonDataQueue(CommonProperties properties) {
        if (properties == null || properties.getQueue() == null || properties.getQueue().getKafka() == null) {
            log.error("init error, please config common.queue.kafka props in application.yml");
            throw new IllegalArgumentException("please config common.queue.kafka props");
        }
        this.kafka = properties.getQueue().getKafka();
        this.metricsDataToAlertQueue = new LinkedBlockingQueue();
        this.metricsDataToStorageQueue = new LinkedBlockingQueue();
        this.serviceDiscoveryDataQueue = new LinkedBlockingQueue();
        this.initDataQueue();
    }

    private void initDataQueue() {
        try {
            HashMap<String, Object> producerConfig = new HashMap<String, Object>(3);
            producerConfig.put("bootstrap.servers", this.kafka.getServers());
            producerConfig.put("acks", "all");
            producerConfig.put("retries", 3);
            this.metricsDataProducer = new KafkaProducer(producerConfig, (Serializer)new LongSerializer(), (Serializer)new KafkaMetricsDataSerializer());
            HashMap<String, Object> consumerConfig = new HashMap<String, Object>(4);
            consumerConfig.put("bootstrap.servers", this.kafka.getServers());
            consumerConfig.put("max.poll.records", "50");
            consumerConfig.put("enable.auto.commit", false);
            consumerConfig.put("max.poll.interval.ms", "900000");
            consumerConfig.put("group.id", "default-consumer");
            HashMap<String, String> metricsToAlertConsumerConfig = new HashMap<String, String>(consumerConfig);
            metricsToAlertConsumerConfig.put("group.id", "metrics-alert-consumer");
            this.metricsDataToAlertConsumer = new KafkaConsumer(metricsToAlertConsumerConfig, (Deserializer)new LongDeserializer(), (Deserializer)new KafkaMetricsDataDeserializer());
            this.metricsDataToAlertConsumer.subscribe(Collections.singletonList(this.kafka.getMetricsDataTopic()));
            HashMap<String, String> metricsToStorageConsumerConfig = new HashMap<String, String>(consumerConfig);
            metricsToStorageConsumerConfig.put("group.id", "metrics-persistent-consumer");
            this.metricsDataToStorageConsumer = new KafkaConsumer(metricsToStorageConsumerConfig, (Deserializer)new LongDeserializer(), (Deserializer)new KafkaMetricsDataDeserializer());
            this.metricsDataToStorageConsumer.subscribe(Collections.singletonList(this.kafka.getMetricsDataTopic()));
            HashMap<String, String> serviceDiscoveryDataConsumerConfig = new HashMap<String, String>(consumerConfig);
            serviceDiscoveryDataConsumerConfig.put("group.id", "service-discovery-data-consumer");
            this.serviceDiscoveryDataConsumer = new KafkaConsumer(serviceDiscoveryDataConsumerConfig, (Deserializer)new LongDeserializer(), (Deserializer)new KafkaMetricsDataDeserializer());
            this.serviceDiscoveryDataConsumer.subscribe(Collections.singletonList(this.kafka.getServiceDiscoveryDataTopic()));
        }
        catch (Exception e) {
            log.error("please config common.queue.kafka props correctly", (Throwable)e);
            throw e;
        }
    }

    @Override
    public CollectRep.MetricsData pollServiceDiscoveryData() throws InterruptedException {
        return this.genericPollDataFunction(this.serviceDiscoveryDataQueue, this.serviceDiscoveryDataConsumer, this.serviceDiscoveryDataLock);
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToAlerter() throws InterruptedException {
        return this.genericPollDataFunction(this.metricsDataToAlertQueue, this.metricsDataToAlertConsumer, this.metricDataToAlertLock);
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToStorage() throws InterruptedException {
        return this.genericPollDataFunction(this.metricsDataToStorageQueue, this.metricsDataToStorageConsumer, this.metricDataToStorageLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T genericPollDataFunction(LinkedBlockingQueue<T> dataQueue, KafkaConsumer<Long, T> dataConsumer, ReentrantLock lock) throws InterruptedException {
        Object pollData = dataQueue.poll();
        if (pollData != null) {
            return pollData;
        }
        lock.lockInterruptibly();
        try {
            ConsumerRecords records = dataConsumer.poll(Duration.ofSeconds(1L));
            int index = 0;
            for (ConsumerRecord record : records) {
                if (index == 0) {
                    pollData = record.value();
                } else {
                    dataQueue.offer(record.value());
                }
                ++index;
            }
            dataConsumer.commitAsync();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            lock.unlock();
        }
        return pollData;
    }

    @Override
    public void sendMetricsData(CollectRep.MetricsData metricsData) {
        if (this.metricsDataProducer != null) {
            ProducerRecord record = new ProducerRecord(this.kafka.getMetricsDataTopic(), (Object)metricsData);
            this.metricsDataProducer.send(record);
        } else {
            log.error("metricsDataProducer is not enabled");
        }
    }

    @Override
    public void sendMetricsDataToStorage(CollectRep.MetricsData metricsData) {
        if (this.metricsDataProducer != null) {
            ProducerRecord record = new ProducerRecord(this.kafka.getMetricsDataToStorageTopic(), (Object)metricsData);
            this.metricsDataProducer.send(record);
        } else {
            log.error("metricsDataProducer is not enabled");
        }
    }

    @Override
    public void sendServiceDiscoveryData(CollectRep.MetricsData metricsData) {
        if (this.metricsDataProducer != null) {
            ProducerRecord record = new ProducerRecord(this.kafka.getServiceDiscoveryDataTopic(), (Object)metricsData);
            this.metricsDataProducer.send(record);
        } else {
            log.error("metricsDataProducer is not enabled");
        }
    }

    public void destroy() throws Exception {
        if (this.metricsDataProducer != null) {
            this.metricsDataProducer.close();
        }
        if (this.metricsDataToAlertConsumer != null) {
            this.metricsDataToAlertConsumer.close();
        }
        if (this.metricsDataToStorageConsumer != null) {
            this.metricsDataToStorageConsumer.close();
        }
        if (this.serviceDiscoveryDataConsumer != null) {
            this.serviceDiscoveryDataConsumer.close();
        }
    }
}

