/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.function;

import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.LoopState;
import com.mongodb.lang.Nullable;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Supplier;

@NotThreadSafe
public final class RetryState {
    public static final int RETRIES = 1;
    private static final int INFINITE_ATTEMPTS = Integer.MAX_VALUE;
    private final LoopState loopState;
    private final int attempts;
    @Nullable
    private Throwable exception;

    public RetryState(int retries) {
        Assertions.assertTrue(retries >= 0);
        this.loopState = new LoopState();
        this.attempts = retries == Integer.MAX_VALUE ? Integer.MAX_VALUE : retries + 1;
    }

    public RetryState() {
        this(Integer.MAX_VALUE);
    }

    void advanceOrThrow(RuntimeException attemptException, BiFunction<Throwable, Throwable, Throwable> exceptionTransformer, BiPredicate<RetryState, Throwable> retryPredicate) throws RuntimeException {
        try {
            this.doAdvanceOrThrow(attemptException, exceptionTransformer, retryPredicate, true);
        }
        catch (Error | RuntimeException unchecked) {
            throw unchecked;
        }
        catch (Throwable checked) {
            throw new AssertionError((Object)checked);
        }
    }

    void advanceOrThrow(Throwable attemptException, BiFunction<Throwable, Throwable, Throwable> exceptionTransformer, BiPredicate<RetryState, Throwable> retryPredicate) throws Throwable {
        this.doAdvanceOrThrow(attemptException, exceptionTransformer, retryPredicate, false);
    }

    private void doAdvanceOrThrow(Throwable attemptException, BiFunction<Throwable, Throwable, Throwable> exceptionTransformer, BiPredicate<RetryState, Throwable> retryPredicate, boolean onlyRuntimeExceptions) throws Throwable {
        Assertions.assertTrue(this.attempt() < this.attempts);
        Assertions.assertNotNull(attemptException);
        if (onlyRuntimeExceptions) {
            Assertions.assertTrue(RetryState.isRuntime(attemptException));
        }
        Assertions.assertTrue(!this.isFirstAttempt() || this.exception == null);
        Throwable newlyChosenException = RetryState.transformException(this.exception, attemptException, onlyRuntimeExceptions, exceptionTransformer);
        if (this.isLastAttempt()) {
            this.exception = newlyChosenException;
            throw this.exception;
        }
        boolean retry = this.shouldRetry(this, attemptException, newlyChosenException, onlyRuntimeExceptions, retryPredicate);
        this.exception = newlyChosenException;
        if (!retry) {
            throw this.exception;
        }
        Assertions.assertTrue(this.loopState.advance());
    }

    private static Throwable transformException(@Nullable Throwable previouslyChosenException, Throwable attemptException, boolean onlyRuntimeExceptions, BiFunction<Throwable, Throwable, Throwable> exceptionTransformer) {
        Throwable result;
        if (onlyRuntimeExceptions && previouslyChosenException != null) {
            Assertions.assertTrue(RetryState.isRuntime(previouslyChosenException));
        }
        try {
            result = Assertions.assertNotNull(exceptionTransformer.apply(previouslyChosenException, attemptException));
            if (onlyRuntimeExceptions) {
                Assertions.assertTrue(RetryState.isRuntime(result));
            }
        }
        catch (Throwable exceptionTransformerException) {
            if (onlyRuntimeExceptions && !RetryState.isRuntime(exceptionTransformerException)) {
                throw exceptionTransformerException;
            }
            if (previouslyChosenException != null) {
                exceptionTransformerException.addSuppressed(previouslyChosenException);
            }
            exceptionTransformerException.addSuppressed(attemptException);
            throw exceptionTransformerException;
        }
        return result;
    }

    private boolean shouldRetry(RetryState readOnlyRetryState, Throwable attemptException, Throwable newlyChosenException, boolean onlyRuntimeExceptions, BiPredicate<RetryState, Throwable> retryPredicate) {
        try {
            return retryPredicate.test(readOnlyRetryState, attemptException);
        }
        catch (Throwable retryPredicateException) {
            if (onlyRuntimeExceptions && !RetryState.isRuntime(retryPredicateException)) {
                throw retryPredicateException;
            }
            retryPredicateException.addSuppressed(newlyChosenException);
            throw retryPredicateException;
        }
    }

    private static boolean isRuntime(@Nullable Throwable exception) {
        return exception instanceof RuntimeException;
    }

    public void breakAndThrowIfRetryAnd(Supplier<Boolean> predicate) throws RuntimeException {
        Assertions.assertFalse(this.loopState.isLastIteration());
        if (!this.isFirstAttempt()) {
            Assertions.assertNotNull(this.exception);
            Assertions.assertTrue(this.exception instanceof RuntimeException);
            RuntimeException localException = (RuntimeException)this.exception;
            try {
                if (predicate.get().booleanValue()) {
                    this.loopState.markAsLastIteration();
                }
            }
            catch (RuntimeException predicateException) {
                predicateException.addSuppressed(localException);
                throw predicateException;
            }
            if (this.loopState.isLastIteration()) {
                throw localException;
            }
        }
    }

    public boolean breakAndCompleteIfRetryAnd(Supplier<Boolean> predicate, SingleResultCallback<?> callback) {
        try {
            this.breakAndThrowIfRetryAnd(predicate);
            return false;
        }
        catch (Throwable t) {
            callback.onResult(null, t);
            return true;
        }
    }

    public void markAsLastAttempt() {
        this.loopState.markAsLastIteration();
    }

    public boolean isFirstAttempt() {
        return this.loopState.isFirstIteration();
    }

    public boolean isLastAttempt() {
        return this.attempt() == this.attempts - 1 || this.loopState.isLastIteration();
    }

    public int attempt() {
        return this.loopState.iteration();
    }

    public int attempts() {
        return this.attempts == Integer.MAX_VALUE ? 0 : this.attempts;
    }

    public Optional<Throwable> exception() {
        Assertions.assertTrue(this.exception == null || !this.isFirstAttempt());
        return Optional.ofNullable(this.exception);
    }

    public <V> RetryState attach(LoopState.AttachmentKey<V> key, V value, boolean autoRemove) {
        this.loopState.attach(key, value, autoRemove);
        return this;
    }

    public <V> Optional<V> attachment(LoopState.AttachmentKey<V> key) {
        return this.loopState.attachment(key);
    }

    public String toString() {
        return "RetryState{loopState=" + this.loopState + ", attempts=" + (this.attempts == Integer.MAX_VALUE ? "infinite" : Integer.valueOf(this.attempts)) + ", exception=" + this.exception + '}';
    }
}

