/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport.tls;

import org.snmp4j.smi.OctetString;

public class SecurityNameMapping {
    private OctetString fingerprint;
    private OctetString data;
    private CertMappingType type;
    private OctetString securityName;

    public SecurityNameMapping(OctetString fingerprint, OctetString data, CertMappingType type, OctetString securityName) {
        this.fingerprint = fingerprint;
        this.data = data;
        this.type = type;
        this.securityName = securityName;
    }

    public OctetString getFingerprint() {
        return this.fingerprint;
    }

    public OctetString getData() {
        return this.data;
    }

    public CertMappingType getType() {
        return this.type;
    }

    public OctetString getSecurityName() {
        return this.securityName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityNameMapping that = (SecurityNameMapping)o;
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        if (this.fingerprint != null ? !this.fingerprint.equals(that.fingerprint) : that.fingerprint != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.fingerprint != null ? this.fingerprint.hashCode() : 0;
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SecurityNameMapping{fingerprint=" + this.fingerprint + ", data=" + this.data + ", type=" + this.type + ", securityName=" + this.securityName + "}";
    }

    public static enum CertMappingType {
        Specified,
        SANRFC822Name,
        SANDNSName,
        SANIpAddress,
        SANAny,
        CommonName;

    }
}

