/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcTagRequest;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderWriterArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.PlcReader;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DefaultPlcReadRequest
implements PlcReadRequest,
PlcTagRequest,
Serializable {
    private final PlcReader reader;
    private final LinkedHashMap<String, PlcTag> tags;

    public DefaultPlcReadRequest(PlcReader reader, LinkedHashMap<String, PlcTag> tags) {
        this.reader = reader;
        this.tags = tags;
    }

    public CompletableFuture<PlcReadResponse> execute() {
        return this.reader.read(this);
    }

    public int getNumberOfTags() {
        return this.tags.size();
    }

    public LinkedHashSet<String> getTagNames() {
        return new LinkedHashSet<String>(this.tags.keySet());
    }

    public PlcTag getTag(String name) {
        return this.tags.get(name);
    }

    public List<PlcTag> getTags() {
        return new LinkedList<PlcTag>(this.tags.values());
    }

    public PlcReader getReader() {
        return this.reader;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcReadRequest", new WithWriterArgs[0]);
        writeBuffer.pushContext("PlcTagRequest", new WithWriterArgs[0]);
        writeBuffer.pushContext("tags", WithReaderWriterArgs.WithRenderAsList(true));
        for (Map.Entry<String, PlcTag> tagEntry : this.tags.entrySet()) {
            String tagName = tagEntry.getKey();
            writeBuffer.pushContext(tagName, new WithWriterArgs[0]);
            PlcTag tag = tagEntry.getValue();
            if (!(tag instanceof Serializable)) {
                throw new RuntimeException("Error serializing. Tag doesn't implement Serializable");
            }
            ((Serializable)tag).serialize(writeBuffer);
            writeBuffer.popContext(tagName, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("tags", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcTagRequest", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcReadRequest", new WithWriterArgs[0]);
    }

    public static class Builder
    implements PlcReadRequest.Builder {
        private final PlcReader reader;
        private final PlcTagHandler tagHandler;
        private final Map<String, Supplier<PlcTag>> tags;

        public Builder(PlcReader reader, PlcTagHandler tagHandler) {
            this.reader = reader;
            this.tagHandler = tagHandler;
            this.tags = new LinkedHashMap<String, Supplier<PlcTag>>();
        }

        public PlcReadRequest.Builder addTagAddress(String name, String tagAddress) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tags.put(name, () -> this.tagHandler.parseTag(tagAddress));
            return this;
        }

        public PlcReadRequest.Builder addTag(String name, PlcTag tag) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tags.put(name, () -> tag);
            return this;
        }

        public PlcReadRequest build() {
            LinkedHashMap<String, PlcTag> parsedTags = new LinkedHashMap<String, PlcTag>();
            this.tags.forEach((name, tagSupplier) -> {
                PlcTag plcTag = parsedTags.put((String)name, (PlcTag)tagSupplier.get());
            });
            return new DefaultPlcReadRequest(this.reader, parsedTags);
        }
    }
}

