/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.plc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.PlcProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.PlcConnectionManager;
import org.apache.plc4x.java.api.PlcDriverManager;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPlcCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(AbstractPlcCollectImpl.class);
    private static final String[] DRIVER_LIST = new String[]{"s7", "modbus-tcp"};
    private static final String[] ADDRESS_SYNTAX = new String[]{"discrete-input", "coil", "input-register", "holding-register"};
    private static final String COIL = "coil";
    private static final PlcConnectionManager CONNECTION_MANAGER = PlcDriverManager.getDefault().getConnectionManager();

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics == null || metrics.getPlc() == null) {
            throw new IllegalArgumentException("PLC collect must have PLC params");
        }
        if (metrics.getPlc().getDriverName() == null || !ArrayUtils.contains((Object[])DRIVER_LIST, (Object)metrics.getPlc().getDriverName())) {
            throw new IllegalArgumentException("PLC collect must have valid driver name");
        }
        if (!ArrayUtils.contains((Object[])ADDRESS_SYNTAX, (Object)metrics.getPlc().getAddressSyntax())) {
            throw new IllegalArgumentException("PLC collect must have valid address syntax");
        }
        if (metrics.getPlc().getRegisterAddresses() == null || metrics.getPlc().getRegisterAddresses().isEmpty()) {
            throw new IllegalArgumentException("PLC collect must have register address");
        }
        if (Objects.nonNull(metrics.getPlc().getTimeout())) {
            try {
                Long.parseLong(metrics.getPlc().getTimeout());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("PLC collect must have valid timeout");
            }
        }
        AtomicInteger addressCount = new AtomicInteger();
        metrics.getPlc().getRegisterAddresses().forEach(address -> {
            if (address.contains("[") && address.contains("]")) {
                String[] addressArray = address.split("\\[");
                String num = addressArray[1].replace("]", "");
                addressCount.addAndGet(Integer.parseInt(num));
            } else {
                addressCount.addAndGet(1);
            }
        });
        List aliasFields = metrics.getAliasFields();
        if (Objects.isNull(aliasFields)) {
            throw new IllegalArgumentException("Please ensure that the number of aliasFields (tagName) in yml matches the number of registered addressesNumber of AliasFields(tagList): 0 ,but Number of addresses:" + addressCount.get());
        }
        int tagListCount = aliasFields.size() - 1;
        if (aliasFields.size() - 1 != addressCount.get()) {
            throw new IllegalArgumentException("Please ensure that the number of aliasFields (tagName) in yml matches the number of registered addressesNumber of AliasFields(tagList): " + tagListCount + " ,but Number of addresses:" + addressCount.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        long startTime = System.currentTimeMillis();
        PlcProtocol plcProtocol = metrics.getPlc();
        PlcConnection plcConnection = null;
        try {
            String connectionString = this.getConnectionString(metrics);
            plcConnection = CONNECTION_MANAGER.getConnection(connectionString);
            if (!plcConnection.getMetadata().isReadSupported()) {
                log.error("This connection doesn't support reading.");
            }
            if (!plcConnection.getMetadata().isWriteSupported()) {
                log.error("This connection doesn't support writing.");
            }
            PlcReadRequest readRequest = this.buildRequest(metrics, plcConnection);
            PlcReadResponse response = (PlcReadResponse)readRequest.execute().get(Long.parseLong(plcProtocol.getTimeout()), TimeUnit.MILLISECONDS);
            long responseTime = System.currentTimeMillis() - startTime;
            Map<Object, Object> resultMap = new HashMap<String, String>();
            for (String tagName : response.getTagNames()) {
                if (response.getResponseCode(tagName) == PlcResponseCode.OK) {
                    int numValues = response.getNumberOfValues(tagName);
                    log.info("{}: {}", (Object)tagName, (Object)response.getPlcValue(tagName));
                    if (numValues == 1) {
                        resultMap.put(tagName, response.getPlcValue(tagName).toString());
                        continue;
                    }
                    for (int i = 0; i < numValues; ++i) {
                        resultMap.put(tagName + "-" + i, response.getObject(tagName, i).toString());
                    }
                    continue;
                }
                log.error("Error[{}]: {}", (Object)tagName, (Object)response.getResponseCode(tagName).name());
            }
            if (COIL.equals(plcProtocol.getAddressSyntax())) {
                resultMap = resultMap.entrySet().stream().peek(obj -> obj.setValue(String.valueOf(Boolean.TRUE.equals(Boolean.valueOf((String)obj.getValue())) ? 1 : 0))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            resultMap.put("responseTime", Long.toString(responseTime));
            List aliasFields = metrics.getAliasFields();
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            for (String field : aliasFields) {
                String fieldValue = (String)resultMap.get(field);
                valueRowBuilder.addColumn(Objects.requireNonNullElse(fieldValue, "&nbsp;"));
            }
            builder.addValueRow(valueRowBuilder.build());
        }
        catch (Exception e) {
            builder.setCode(CollectRep.Code.FAIL);
            String message = CommonUtil.getMessageFromThrowable((Throwable)e);
            builder.setMsg(message);
            log.warn(message, (Throwable)e);
        }
        finally {
            if (plcConnection != null) {
                try {
                    plcConnection.close();
                }
                catch (Exception e) {
                    log.warn(e.getMessage());
                }
            }
        }
    }

    protected abstract String getConnectionString(Metrics var1);

    protected abstract PlcReadRequest buildRequest(Metrics var1, PlcConnection var2);
}

