/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.reconnect;

import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.desc.EP;
import dm.jdbc.desc.EPGroup;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.filter.reconnect.ReconnectController$1;
import dm.jdbc.filter.reconnect.ReconnectController$Switch;
import dm.jdbc.processor.BaseThread;
import dm.jdbc.util.CacheQueue;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ReconnectController
extends BaseThread {
    private static ILogger log = LogFactory.getLog(ReconnectController.class);
    public static final CacheQueue connQueue = new ReconnectController$1(Integer.MAX_VALUE, false);
    boolean stop = false;

    public ReconnectController() {
        super("Reconnect-Controller");
    }

    @Override
    public void run() {
        HashMap<String, EPGroup> hashMap = new HashMap<String, EPGroup>();
        while (!this.stop) {
            try {
                hashMap.clear();
                DmSvcConf.GLOBAL.reload();
                int n2 = connQueue.size();
                int n3 = 0;
                while (n3 < n2) {
                    DmdbConnection dmdbConnection = (DmdbConnection)connQueue.get();
                    if (dmdbConnection != null) {
                        connQueue.put(dmdbConnection);
                        if (dmdbConnection.epGroup != null && !hashMap.containsKey(dmdbConnection.epGroup.name)) {
                            hashMap.put(dmdbConnection.epGroup.name, dmdbConnection.epGroup);
                            if (dmdbConnection.epGroup.checkTime <= 0L || System.currentTimeMillis() - dmdbConnection.epGroup.checkTime >= (long)dmdbConnection.epGroup.checkFreq) {
                                dmdbConnection.epGroup.user = dmdbConnection.user;
                                dmdbConnection.epGroup.password = dmdbConnection.password;
                                if ((dmdbConnection.epGroup.reconnect & 4) != 0) {
                                    this.loadBalance(dmdbConnection.epGroup);
                                }
                                if ((dmdbConnection.epGroup.reconnect & 2) != 0) {
                                    this.headFirst(dmdbConnection.epGroup);
                                }
                                dmdbConnection.epGroup.checkTime = System.currentTimeMillis();
                            }
                        }
                        ++n3;
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                log.warn(this, "run", throwable.getMessage());
            }
            MiscUtil.sleep(1000L);
        }
    }

    private void loadBalance(EPGroup ePGroup) {
        Object object2;
        EP[] ePArray = new EP[ePGroup.epList.size()];
        int n2 = 0;
        for (Object object2 : ePGroup.epList) {
            if (!this.checkEp(ePGroup, (EP)object2)) continue;
            ePArray[n2++] = object2;
        }
        if (n2 == 0) {
            log.debug("LoadBalanceFilter no alive ep: EPGroup [" + ePGroup.name + "]");
            return;
        }
        object2 = this.calcSwitches(ePArray.length == n2 ? ePArray : Arrays.copyOf(ePArray, n2), ePGroup.allowRange);
        Iterator iterator = object2.iterator();
        block1: while (iterator.hasNext()) {
            ReconnectController$Switch reconnectController$Switch = (ReconnectController$Switch)iterator.next();
            int n3 = connQueue.size();
            int n4 = 0;
            while (n4 < n3) {
                DmdbConnection dmdbConnection = (DmdbConnection)connQueue.get();
                if (dmdbConnection == null) continue block1;
                connQueue.put(dmdbConnection);
                if (StringUtil.equals(dmdbConnection.epGroup.name, ePGroup.name) && dmdbConnection.ep.equals(reconnectController$Switch.sourceSite)) {
                    dmdbConnection.switchToEpSeqno = reconnectController$Switch.destSite.epSeqno;
                    continue block1;
                }
                ++n4;
            }
        }
    }

    private void headFirst(EPGroup ePGroup) {
        EP[] ePArray = new EP[ePGroup.epList.size()];
        int n2 = 0;
        for (EP eP : ePGroup.epList) {
            if (!this.checkEp(ePGroup, eP)) continue;
            ePArray[n2++] = eP;
        }
        int n3 = connQueue.size();
        int n4 = 0;
        while (n4 < n3) {
            DmdbConnection dmdbConnection = (DmdbConnection)connQueue.get();
            if (dmdbConnection == null) break;
            connQueue.put(dmdbConnection);
            if (StringUtil.equals(dmdbConnection.epGroup.name, ePGroup.name)) {
                int n5 = 0;
                while (n5 < dmdbConnection.ep.epSeqno) {
                    if (((EP)ePGroup.epList.get((int)n5)).alive) {
                        log.debug("head first mark :" + dmdbConnection.switchToEpSeqno + " -> " + n5);
                        dmdbConnection.switchToEpSeqno = n5;
                        break;
                    }
                    ++n5;
                }
            }
            ++n4;
        }
    }

    public boolean checkEp(EPGroup ePGroup, EP eP) {
        block5: {
            DmdbConnection dmdbConnection;
            block4: {
                dmdbConnection = null;
                try {
                    dmdbConnection = new DmdbConnection(ePGroup.props);
                    dmdbConnection.epGroup = ePGroup;
                    dmdbConnection.user = ePGroup.user;
                    dmdbConnection.password = ePGroup.password;
                    eP.connect(dmdbConnection);
                    DmdbResultSet dmdbResultSet = DriverUtil.executeQuery(dmdbConnection, "select count(*) from v$sessions");
                    if (!dmdbResultSet.next()) break block4;
                    eP.sessions = dmdbResultSet.getLong(1);
                }
                catch (Exception exception) {
                    try {
                        log.debug("LoadBalanceFilter get sessions failed: EP [" + eP + "]", exception);
                    }
                    catch (Throwable throwable) {
                        MiscUtil.close(dmdbConnection);
                        throw throwable;
                    }
                    MiscUtil.close(dmdbConnection);
                    break block5;
                }
                MiscUtil.close(dmdbConnection);
                return true;
            }
            MiscUtil.close(dmdbConnection);
        }
        return false;
    }

    public List calcSwitches(EP[] ePArray, int n2) {
        ArrayList<ReconnectController$Switch> arrayList = new ArrayList<ReconnectController$Switch>();
        int n3 = 0;
        EP[] ePArray2 = ePArray;
        int n4 = ePArray.length;
        int n5 = 0;
        while (n5 < n4) {
            EP eP = ePArray2[n5];
            n3 = (int)((long)n3 + eP.sessions);
            ++n5;
        }
        int n6 = (int)((double)(n3 / ePArray.length) * (1.0 - (double)n2 / 100.0));
        block1: while (true) {
            Arrays.sort(ePArray, EP.sessionComparator);
            EP eP = ePArray[0];
            EP eP2 = ePArray[ePArray.length - 1];
            long l2 = eP.sessions;
            long l3 = eP2.sessions;
            long l4 = Math.min((long)n6 - l2, l3 - (long)n6);
            if (l4 <= 0L) break;
            int n7 = 0;
            while (true) {
                if ((long)n7 >= l4) continue block1;
                --eP2.sessions;
                ++eP.sessions;
                arrayList.add(new ReconnectController$Switch(this, (EP)eP2.clone(), (EP)eP.clone()));
                ++n7;
            }
            break;
        }
        log.debug("load balance mark :" + Arrays.toString(arrayList.toArray()));
        return arrayList;
    }
}

