/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import java.io.Reader;
import java.nio.CharBuffer;
import java.sql.SQLException;

public class DmdbReader
extends Reader {
    public static final int IS_BLOB = 1;
    public static final int IS_CLOB = 2;
    public static final int IS_CHAR = 3;
    private int typeFlag;
    private Object obj = null;
    private int objPos;
    private long objLength = -1L;
    private boolean cut = false;
    private char[] buf;
    private int bufPos = 0;
    private boolean closed;

    public DmdbReader(Object object) {
        this.obj = object;
        this.objPos = 0;
        this.closed = false;
        if (object instanceof DmdbClob) {
            this.typeFlag = 2;
            this.objLength = (int)((DmdbClob)object).do_length();
        } else if (object instanceof DmdbBlob) {
            this.typeFlag = 1;
            this.objLength = (int)((DmdbBlob)object).do_length();
        } else if (object instanceof String) {
            this.typeFlag = 3;
            this.obj = ((String)object).toCharArray();
            this.objLength = ((char[])this.obj).length;
        } else if (object instanceof byte[]) {
            this.typeFlag = 3;
            this.obj = ConvertUtil.ASCIIBytesToJavaChars((byte[])object, 0, ((byte[])object).length);
            this.objLength = ((char[])this.obj).length;
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
    }

    protected DmdbReader(DmdbClob dmdbClob, long l2, long l3) {
        this(dmdbClob);
        this.objPos = (int)(l2 - 1L);
        this.objLength = dmdbClob.do_length();
        this.objLength = Math.min(this.objLength, (long)this.objPos + l3);
        this.cut = this.objPos > 0 || this.objLength < dmdbClob.do_length();
    }

    public Object useRealObject(long l2) {
        switch (this.typeFlag) {
            case 1: 
            case 2: {
                if (this.objPos != 0 || this.cut || -1L != l2 && l2 < this.objLength) break;
                return this.obj;
            }
        }
        return this;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) {
        if (this.closed) {
            DBError.throwIOException(DBError.ECJDBC_STREAM_CLOSED.reason);
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > cArray.length) {
            DBError.throwIOException(DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.reason);
        } else if (this.avaliable() == 0) {
            return -1;
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5 = this.bufLeaveLen();
            if (n5 == 0 && (n5 = this.fillBuffer()) <= 0) break;
            int n6 = n3 - n4;
            int n7 = Math.min(n6, n5);
            System.arraycopy(this.buf, this.bufPos, cArray, n2, n7);
            this.bufPos += n7;
            n2 += n7;
            n4 += n7;
        }
        return n4;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void mark(int n2) {
        super.mark(n2);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() {
        return super.read();
    }

    @Override
    public int read(char[] cArray) {
        return super.read(cArray);
    }

    @Override
    public int read(CharBuffer charBuffer) {
        return super.read(charBuffer);
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public long skip(long l2) {
        if (this.typeFlag == 1) {
            return super.skip(l2);
        }
        int n2 = (int)Math.min((long)this.avaliable(), l2);
        if (n2 <= 0) {
            return 0L;
        }
        int n3 = this.bufLeaveLen();
        if (n2 < n3) {
            this.bufPos += n2;
        } else {
            this.objPos += n2 - n3;
            this.fillBuffer();
        }
        return n2;
    }

    private int avaliable() {
        return (int)((long)this.bufLeaveLen() + this.objLength - (long)this.objPos);
    }

    private int bufLeaveLen() {
        return this.buf == null ? 0 : this.buf.length - this.bufPos;
    }

    private int fillBuffer() {
        switch (this.typeFlag) {
            case 1: {
                return this.readFromBlob(32640);
            }
            case 2: {
                return this.readFromClob(16320);
            }
            case 3: {
                return this.readFromChars();
            }
        }
        DBError.throwIOException(DBError.ECJDBC_DATA_CONVERTION_ERROR.reason);
        return 0;
    }

    private int readFromChars() {
        int n2 = (int)(this.objLength - (long)this.objPos);
        int n3 = 0;
        if (n2 <= 0) {
            return -1;
        }
        this.buf = (char[])this.obj;
        n3 = this.buf == null ? 0 : this.buf.length;
        this.objPos += n3;
        this.bufPos = 0;
        return n3;
    }

    private int readFromBlob(int n2) {
        int n3;
        int n4;
        DmdbBlob dmdbBlob;
        block3: {
            dmdbBlob = (DmdbBlob)this.obj;
            n4 = (int)(this.objLength - (long)this.objPos);
            n3 = 0;
            if (n4 > 0) break block3;
            return -1;
        }
        try {
            n2 = Math.min(n4, n2);
            byte[] byArray = dmdbBlob.do_getBytes(this.objPos + 1, n2);
            this.buf = byArray == null ? new char[]{} : ByteUtil.getString(byArray, 0, byArray.length, dmdbBlob.connection.getServerEncoding()).toCharArray();
            n3 = this.buf == null ? 0 : this.buf.length;
            this.objPos += n3;
            this.bufPos = 0;
        }
        catch (SQLException sQLException) {
            DBError.throwIOException(sQLException.getMessage());
        }
        return n3;
    }

    private int readFromClob(int n2) {
        int n3;
        int n4;
        DmdbClob dmdbClob;
        block3: {
            dmdbClob = (DmdbClob)this.obj;
            n4 = (int)(this.objLength - (long)this.objPos);
            n3 = 0;
            if (n4 > 0) break block3;
            return -1;
        }
        try {
            n2 = Math.min(n4, n2);
            String string = dmdbClob.do_getSubString(this.objPos + 1, n2);
            this.buf = string == null ? new char[]{} : string.toCharArray();
            n3 = this.buf == null ? 0 : this.buf.length;
            this.objPos += n2;
            this.bufPos = 0;
        }
        catch (SQLException sQLException) {
            DBError.throwIOException(sQLException.getMessage());
        }
        return n3;
    }
}

