/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.sd;

import java.time.Duration;
import java.util.Arrays;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;

public class DnsSdCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(DnsSdCollectImpl.class);
    private static final int DEFAULT_TIME_OUT = 3;

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics.getDns_sd() == null) {
            throw new IllegalArgumentException("DNS SD configuration cannot be null");
        }
        if (metrics.getDns_sd().getHost() == null || metrics.getDns_sd().getHost().isEmpty()) {
            throw new IllegalArgumentException("DNS host cannot be null or empty");
        }
        if (metrics.getDns_sd().getPort() == null || metrics.getDns_sd().getPort().isEmpty()) {
            throw new IllegalArgumentException("DNS port cannot be null or empty");
        }
        if (metrics.getDns_sd().getRecordType() == null || metrics.getDns_sd().getRecordType().isEmpty()) {
            throw new IllegalArgumentException("DNS record type cannot be null or empty");
        }
        if (metrics.getDns_sd().getRecordName() == null || metrics.getDns_sd().getRecordName().isEmpty()) {
            throw new IllegalArgumentException("DNS record name cannot be null or empty");
        }
    }

    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        String hostName = metrics.getDns_sd().getHost();
        int type = Integer.parseInt(metrics.getDns_sd().getRecordType());
        Type.check((int)type);
        String recordName = metrics.getDns_sd().getRecordName();
        try {
            Lookup lookup = new Lookup(recordName, type);
            SimpleResolver resolver = new SimpleResolver(metrics.getDns_sd().getHost());
            resolver.setPort(Integer.parseInt(metrics.getDns_sd().getPort()));
            resolver.setTimeout(Duration.ofMillis(3L));
            lookup.setResolver((Resolver)resolver);
            lookup.setCache(null);
            lookup.run();
            if (lookup.getResult() != 0) {
                String msg = String.format("DNS lookup failed for: %s, error: %s", recordName, lookup.getErrorString());
                log.warn(msg);
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg(msg);
                return;
            }
            Record[] records = lookup.getAnswers();
            if (records == null || records.length == 0) {
                log.info("No record type: {} records found for host: {}", (Object)type, (Object)hostName);
                builder.setCode(CollectRep.Code.SUCCESS);
                return;
            }
            this.processRecords(builder, records, type);
        }
        catch (TextParseException e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.warn("Failed to parse dns query... {}", (Object)errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        catch (Exception e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.error("Failed to fetch dns sd...{}", (Object)errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
    }

    private void processRecords(CollectRep.MetricsData.Builder builder, Record[] records, int recordType) {
        switch (recordType) {
            case 1: {
                this.processARecords(builder, records);
                break;
            }
            case 28: {
                this.processAAAARecords(builder, records);
                break;
            }
            case 33: {
                this.processSrvRecords(builder, records);
                break;
            }
            case 15: {
                this.processMxRecords(builder, records);
                break;
            }
            case 2: {
                this.processNsRecords(builder, records);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid record type: " + recordType);
            }
        }
    }

    private void processARecords(CollectRep.MetricsData.Builder builder, Record[] records) {
        Arrays.stream(records).filter(ARecord.class::isInstance).map(ARecord.class::cast).forEach(aRecord -> {
            CollectRep.ValueRow.Builder row = CollectRep.ValueRow.newBuilder();
            row.addColumn(aRecord.getAddress().getHostAddress());
            row.addColumn("");
            builder.addValueRow(row.build());
        });
    }

    private void processAAAARecords(CollectRep.MetricsData.Builder builder, Record[] records) {
        Arrays.stream(records).filter(AAAARecord.class::isInstance).map(AAAARecord.class::cast).forEach(aaaaRecord -> {
            CollectRep.ValueRow.Builder row = CollectRep.ValueRow.newBuilder();
            row.addColumn(aaaaRecord.getAddress().getHostAddress());
            row.addColumn("");
            builder.addValueRow(row.build());
        });
    }

    private void processSrvRecords(CollectRep.MetricsData.Builder builder, Record[] records) {
        Arrays.stream(records).filter(SRVRecord.class::isInstance).map(SRVRecord.class::cast).forEach(srvRecord -> {
            CollectRep.ValueRow.Builder row = CollectRep.ValueRow.newBuilder();
            row.addColumn(srvRecord.getTarget().toString(true));
            row.addColumn(String.valueOf(srvRecord.getPort()));
            builder.addValueRow(row.build());
        });
    }

    private void processMxRecords(CollectRep.MetricsData.Builder builder, Record[] records) {
        Arrays.stream(records).filter(MXRecord.class::isInstance).map(MXRecord.class::cast).forEach(mxRecord -> {
            CollectRep.ValueRow.Builder row = CollectRep.ValueRow.newBuilder();
            row.addColumn(mxRecord.getTarget().toString(true));
            row.addColumn("");
            builder.addValueRow(row.build());
        });
    }

    private void processNsRecords(CollectRep.MetricsData.Builder builder, Record[] records) {
        Arrays.stream(records).filter(NSRecord.class::isInstance).map(NSRecord.class::cast).forEach(nsRecord -> {
            CollectRep.ValueRow.Builder row = CollectRep.ValueRow.newBuilder();
            row.addColumn(nsRecord.getTarget().toString(true));
            row.addColumn("");
            builder.addValueRow(row.build());
        });
    }

    public String supportProtocol() {
        return "dns_sd";
    }
}

