/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.integrity;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.integrity.IpmiIntegrity;

public abstract class AbstractIpmiIntegrity
implements IpmiIntegrity {
    private final Mac mac;

    public AbstractIpmiIntegrity(String algorithm) throws NoSuchAlgorithmException {
        this.mac = Mac.getInstance(algorithm);
    }

    @Override
    public void setKey(byte[] key) throws InvalidKeyException {
        SecretKeySpec secretKey = new SecretKeySpec(key, this.mac.getAlgorithm());
        this.mac.init(secretKey);
    }

    @Override
    public void setData(byte[] data) {
        this.mac.update(data);
    }

    @Override
    public byte[] getHash() {
        int cutLength;
        byte[] hash = this.mac.doFinal();
        if (hash.length > (cutLength = this.getHashLength())) {
            hash = Arrays.copyOf(hash, cutLength);
        }
        return hash;
    }
}

