/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.jdbc.SqlExceptionUtils;
import java.sql.SQLException;
import java.sql.Savepoint;

public class JdbcSavepoint
implements Savepoint {
    final int id;
    final String name;

    JdbcSavepoint(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (this.name != null) {
            throw SqlExceptionUtils.clientError("Cannot get ID from a named savepoint, please use getSavepointName() instead");
        }
        return this.id;
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (this.name == null) {
            throw SqlExceptionUtils.clientError("Cannot get name from an un-named savepoint, please use getSavepointId() instead");
        }
        return this.name;
    }

    public String toString() {
        return "JdbcSavepoint [id=" + this.id + ", name=" + this.name + ']';
    }
}

