/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages.utils;

import java.nio.charset.StandardCharsets;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ResponseItem<T>
implements Serializable {
    private final PlcResponseCode code;
    private final T value;

    public ResponseItem(PlcResponseCode code, T value) {
        this.code = code;
        this.value = value;
    }

    public PlcResponseCode getCode() {
        return this.code;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("ResponseItem", new WithWriterArgs[0]);
        String codeName = this.code.name();
        writeBuffer.writeString("code", codeName.getBytes(StandardCharsets.UTF_8).length * 8, codeName, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
        if (this.value != null) {
            writeBuffer.pushContext("value", new WithWriterArgs[0]);
            if (!(this.value instanceof Serializable)) {
                throw new RuntimeException("Error serializing. Tag value doesn't implement XmlSerializable");
            }
            ((Serializable)this.value).serialize(writeBuffer);
            writeBuffer.popContext("value", new WithWriterArgs[0]);
        }
        writeBuffer.popContext("ResponseItem", new WithWriterArgs[0]);
    }
}

