/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcBrowseRequest;
import org.apache.plc4x.java.api.messages.PlcBrowseRequestInterceptor;
import org.apache.plc4x.java.api.messages.PlcBrowseResponse;
import org.apache.plc4x.java.api.model.PlcQuery;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.PlcBrowser;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DefaultPlcBrowseRequest
implements PlcBrowseRequest,
Serializable {
    private final PlcBrowser browser;
    private final LinkedHashMap<String, PlcQuery> queries;

    public DefaultPlcBrowseRequest(PlcBrowser browser, LinkedHashMap<String, PlcQuery> queries) {
        this.browser = browser;
        this.queries = queries;
    }

    public CompletableFuture<PlcBrowseResponse> execute() {
        return this.browser.browse(this);
    }

    public CompletableFuture<? extends PlcBrowseResponse> executeWithInterceptor(PlcBrowseRequestInterceptor interceptor) {
        return this.browser.browseWithInterceptor(this, interceptor);
    }

    public PlcBrowser getBrowser() {
        return this.browser;
    }

    public LinkedHashSet<String> getQueryNames() {
        return new LinkedHashSet<String>(this.queries.keySet());
    }

    public PlcQuery getQuery(String name) {
        return this.queries.get(name);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcBrowseRequest", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcBrowseRequest", new WithWriterArgs[0]);
    }

    public static class Builder
    implements PlcBrowseRequest.Builder {
        private final PlcBrowser browser;
        private final PlcTagHandler tagHandler;
        private final LinkedHashMap<String, Supplier<PlcQuery>> queries;

        public Builder(PlcBrowser browser, PlcTagHandler tagHandler) {
            this.browser = browser;
            this.tagHandler = tagHandler;
            this.queries = new LinkedHashMap();
        }

        public Builder addQuery(String name, String query) {
            if (this.queries.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate query definition '" + name + "'");
            }
            this.queries.put(name, () -> this.tagHandler.parseQuery(query));
            return this;
        }

        public PlcBrowseRequest build() {
            LinkedHashMap<String, PlcQuery> parsedQueries = new LinkedHashMap<String, PlcQuery>();
            this.queries.forEach((name, tagQuery) -> {
                PlcQuery plcQuery = parsedQueries.put((String)name, (PlcQuery)tagQuery.get());
            });
            return new DefaultPlcBrowseRequest(this.browser, parsedQueries);
        }
    }
}

