/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.lang.reflect.Field;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PlcMessageToMessageCodec<INBOUND_IN, OUTBOUND_IN>
extends MessageToMessageCodec<INBOUND_IN, OUTBOUND_IN> {
    private static final Logger logger = LoggerFactory.getLogger(PlcMessageToMessageCodec.class);
    private ChannelHandler prevChannelHandler = null;

    protected PlcMessageToMessageCodec() {
    }

    protected PlcMessageToMessageCodec(Class<? extends INBOUND_IN> inboundMessageType, Class<? extends OUTBOUND_IN> outboundMessageType) {
        super(inboundMessageType, outboundMessageType);
    }

    protected ChannelHandler getPrevChannelHandler(ChannelHandlerContext ctx) {
        if (this.prevChannelHandler == null) {
            try {
                Field prevField = FieldUtils.getField(ctx.getClass(), (String)"prev", (boolean)true);
                if (prevField != null) {
                    ChannelHandlerContext prevContext = (ChannelHandlerContext)prevField.get(ctx);
                    this.prevChannelHandler = prevContext.handler();
                }
            }
            catch (Exception e) {
                logger.error("Error accessing field 'prev'", (Throwable)e);
            }
        }
        return this.prevChannelHandler;
    }
}

