/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.X509TrustManager;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportStateReference;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.SecurityLevel;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.DtlsAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.AbstractServerSocket;
import org.snmp4j.transport.ConnectionOrientedTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.transport.MessageLengthDecoder;
import org.snmp4j.transport.SocketTimeout;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.transport.TransportStateListener;
import org.snmp4j.transport.TransportType;
import org.snmp4j.transport.tls.DefaultSSLEngineConfiguration;
import org.snmp4j.transport.tls.SSLEngineConfigurator;
import org.snmp4j.transport.tls.TLSTMExtendedTrustManager;
import org.snmp4j.transport.tls.TLSTMTrustManagerFactory;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;
import org.snmp4j.transport.tls.X509TlsTransportMappingConfig;
import org.snmp4j.util.CommonTimer;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerTask;

public class DTLSTM
extends DefaultUdpTransportMapping
implements X509TlsTransportMappingConfig,
ConnectionOrientedTransportMapping<UdpAddress> {
    private static final LogAdapter logger = LogFactory.getLogger(DTLSTM.class);
    public static final int MAX_HANDSHAKE_LOOPS = 100;
    public static final int DEFAULT_SOCKET_TIMEOUT = 5000;
    public static final int DEFAULT_HANDSHAKE_TIMEOUT = 5000;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 300000;
    private static final int DEFAULT_DTLS_HANDSHAKE_THREADPOOL_SIZE = 2;
    private long nextSessionID = 1L;
    private final Map<InetSocketAddress, SocketEntry> sockets = new ConcurrentHashMap<InetSocketAddress, SocketEntry>();
    private CommonTimer socketCleaner;
    private SSLEngineConfigurator sslEngineConfigurator;
    private TlsTmSecurityCallback<X509Certificate> securityCallback;
    private CounterSupport counterSupport;
    private long connectionTimeout = 300000L;
    private int handshakeTimeout = 5000;
    public static final String DEFAULT_DTLSTM_PROTOCOLS = "DTLSv1.2";
    public static final int MAX_TLS_PAYLOAD_SIZE = 65536;
    private String localCertificateAlias;
    private String keyStore;
    private String keyStorePassword;
    private String trustStore;
    private String trustStorePassword;
    private String[] dtlsProtocols;
    private TLSTMTrustManagerFactory trustManagerFactory = new DefaultDTLSTMTrustManagerFactory();
    private PKIXRevocationChecker pkixRevocationChecker;
    private String x509CertificateRevocationListURI;
    private ThreadPool dtlsHandshakeThreadPool;
    private int dtlsHandshakeThreadPoolSize = 2;
    private boolean serverEnabled = false;
    private transient List<TransportStateListener> transportStateListeners;

    public DTLSTM() throws IOException {
        super(new DtlsAddress(InetAddress.getLocalHost(), 0));
        this.counterSupport = CounterSupport.getInstance();
        this.maxInboundMessageSize = 65536;
        this.setSocketTimeout(5000);
    }

    public DTLSTM(DtlsAddress address) throws IOException {
        this(address, true);
    }

    public DTLSTM(DtlsAddress address, boolean serverEnabled) throws IOException {
        super(address);
        this.serverEnabled = serverEnabled;
        this.maxInboundMessageSize = 65536;
        this.counterSupport = CounterSupport.getInstance();
        this.setSocketTimeout(5000);
        try {
            if (Class.forName("javax.net.ssl.X509ExtendedTrustManager") != null) {
                Class<?> trustManagerFactoryClass = Class.forName("org.snmp4j.transport.tls.DTLSTMExtendedTrustManagerFactory");
                Constructor<?> c = trustManagerFactoryClass.getConstructors()[0];
                TLSTMTrustManagerFactory trustManagerFactory = (TLSTMTrustManagerFactory)c.newInstance(this);
                this.setTrustManagerFactory(trustManagerFactory);
            }
        }
        catch (ClassNotFoundException trustManagerFactoryClass) {
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new IOException("Failed to init DTLSTMTrustManagerFactory: " + ex.getMessage(), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new IOException("Failed to setup DTLSTMTrustManagerFactory: " + ex.getMessage(), ex);
        }
        catch (InstantiationException ex) {
            throw new IOException("Failed to instantiate DTLSTMTrustManagerFactory: " + ex.getMessage(), ex);
        }
    }

    public DTLSTM(TlsTmSecurityCallback<X509Certificate> securityCallback, DtlsAddress serverAddress) throws IOException {
        this(securityCallback, serverAddress, CounterSupport.getInstance());
    }

    public DTLSTM(TlsTmSecurityCallback<X509Certificate> securityCallback, DtlsAddress serverAddress, CounterSupport counterSupport) throws IOException {
        this(securityCallback, serverAddress, counterSupport, true);
    }

    public DTLSTM(TlsTmSecurityCallback<X509Certificate> securityCallback, DtlsAddress serverAddress, CounterSupport counterSupport, boolean serverEnabled) throws IOException {
        this(serverAddress, serverEnabled);
        this.maxInboundMessageSize = 65536;
        this.setSocketTimeout(5000);
        this.securityCallback = securityCallback;
        this.counterSupport = counterSupport;
    }

    @Override
    public synchronized void listen() throws IOException {
        this.dtlsHandshakeThreadPool = ThreadPool.create("DTLSTM_" + this.getListenAddress(), this.getDtlsHandshakeThreadPoolSize());
        if (this.connectionTimeout > 0L) {
            this.socketCleaner = SNMP4JSettings.getTimerFactory().createTimer();
        }
        super.listen();
    }

    @Override
    public void close() throws IOException {
        for (SocketEntry socketEntry : this.sockets.values()) {
            socketEntry.closeSession();
        }
        super.close();
        if (this.dtlsHandshakeThreadPool != null) {
            this.dtlsHandshakeThreadPool.stop();
        }
        this.sockets.clear();
        if (this.socketCleaner != null) {
            this.socketCleaner.cancel();
        }
        this.socketCleaner = null;
        this.dtlsHandshakeThreadPool = null;
    }

    @Override
    public TransportType getSupportedTransportType() {
        return this.serverEnabled ? TransportType.any : TransportType.sender;
    }

    public int getDtlsHandshakeThreadPoolSize() {
        return this.dtlsHandshakeThreadPoolSize;
    }

    public void setDtlsHandshakeThreadPoolSize(int dtlsHandshakeThreadPoolSize) {
        this.dtlsHandshakeThreadPoolSize = dtlsHandshakeThreadPoolSize;
    }

    @Override
    public String getLocalCertificateAlias() {
        if (this.localCertificateAlias == null) {
            return System.getProperty("org.snmp4j.arg.tlsLocalID", null);
        }
        return this.localCertificateAlias;
    }

    @Override
    public String[] getProtocolVersions() {
        if (this.dtlsProtocols == null) {
            String s = System.getProperty(this.getProtocolVersionPropertyName(), DEFAULT_DTLSTM_PROTOCOLS);
            return s.split(",");
        }
        return this.dtlsProtocols;
    }

    @Override
    public String getProtocolVersionPropertyName() {
        return "org.snmp4j.arg.dtlsVersion";
    }

    @Override
    public void setProtocolVersions(String[] dtlsProtocols) {
        this.dtlsProtocols = dtlsProtocols;
    }

    @Override
    public String getKeyStore() {
        if (this.keyStore == null) {
            return System.getProperty("javax.net.ssl.keyStore");
        }
        return this.keyStore;
    }

    @Override
    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    public String getKeyStorePassword() {
        if (this.keyStorePassword == null) {
            return System.getProperty("javax.net.ssl.keyStorePassword");
        }
        return this.keyStorePassword;
    }

    @Override
    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    @Override
    public String getTrustStore() {
        if (this.trustStore == null) {
            return System.getProperty("javax.net.ssl.trustStore");
        }
        return this.trustStore;
    }

    @Override
    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    @Override
    public String getTrustStorePassword() {
        if (this.trustStorePassword == null) {
            return System.getProperty("javax.net.ssl.trustStorePassword");
        }
        return this.trustStorePassword;
    }

    @Override
    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    @Override
    public void setLocalCertificateAlias(String localCertificateAlias) {
        this.localCertificateAlias = localCertificateAlias;
    }

    public CounterSupport getCounterSupport() {
        return this.counterSupport;
    }

    @Override
    public Class<? extends Address> getSupportedAddressClass() {
        return DtlsAddress.class;
    }

    @Override
    public Set<Class<? extends Address>> getSupportedAddressClasses() {
        return new HashSet<Class<? extends Address>>(Arrays.asList(DtlsAddress.class, UdpAddress.class));
    }

    @Override
    public TlsTmSecurityCallback<X509Certificate> getSecurityCallback() {
        return this.securityCallback;
    }

    @Override
    public void setSecurityCallback(TlsTmSecurityCallback<X509Certificate> securityCallback) {
        this.securityCallback = securityCallback;
    }

    public TLSTMTrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public void setTrustManagerFactory(TLSTMTrustManagerFactory trustManagerFactory) {
        if (trustManagerFactory == null) {
            throw new NullPointerException();
        }
        this.trustManagerFactory = trustManagerFactory;
    }

    @Override
    public UdpAddress getListenAddress() {
        DtlsAddress actualListenAddress = null;
        DatagramSocket socketCopy = this.socket;
        if (socketCopy != null) {
            actualListenAddress = new DtlsAddress(socketCopy.getLocalAddress(), socketCopy.getLocalPort());
        }
        return actualListenAddress;
    }

    @Override
    public synchronized boolean close(UdpAddress remoteAddress) throws IOException {
        SocketEntry socketEntry;
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Closing socket for peer address " + remoteAddress)));
        }
        if ((socketEntry = this.sockets.remove(new InetSocketAddress(remoteAddress.getInetAddress(), remoteAddress.getPort()))) != null) {
            socketEntry.closeSession();
            return true;
        }
        return false;
    }

    @Override
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public MessageLengthDecoder getMessageLengthDecoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMessageLengthDecoder(MessageLengthDecoder messageLengthDecoder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public synchronized void addTransportStateListener(TransportStateListener l) {
        if (this.transportStateListeners == null) {
            this.transportStateListeners = new ArrayList<TransportStateListener>(2);
        }
        this.transportStateListeners.add(l);
    }

    @Override
    public synchronized void removeTransportStateListener(TransportStateListener l) {
        if (this.transportStateListeners != null) {
            this.transportStateListeners.remove(l);
        }
    }

    @Override
    public CommonTimer getSocketCleaner() {
        return this.socketCleaner;
    }

    @Override
    public boolean isServerEnabled() {
        return this.serverEnabled;
    }

    @Override
    public void setServerEnabled(boolean serverEnabled) {
        this.serverEnabled = serverEnabled;
    }

    @Override
    public int getMaxInboundMessageSize() {
        return super.getMaxInboundMessageSize();
    }

    @Override
    public void setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    public int getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    public void setHandshakeTimeout(int handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
    }

    @Override
    public String getX509CertificateRevocationListURI() {
        return this.x509CertificateRevocationListURI;
    }

    @Override
    public void setX09CertificateRevocationListURI(String crlURI) {
        this.x509CertificateRevocationListURI = crlURI;
    }

    private synchronized void timeoutSocket(SocketEntry entry) {
        if (this.connectionTimeout > 0L && this.socketCleaner != null) {
            this.socketCleaner.schedule(new SocketTimeout<UdpAddress>(this, entry), this.connectionTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireConnectionStateChanged(TransportStateEvent change) {
        block8: {
            List<TransportStateListener> listenersFinalRef;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Firing transport state event: " + change)));
            }
            if ((listenersFinalRef = this.transportStateListeners) != null) {
                try {
                    ArrayList<TransportStateListener> listeners;
                    List<TransportStateListener> list = listenersFinalRef;
                    synchronized (list) {
                        listeners = new ArrayList<TransportStateListener>(listenersFinalRef);
                    }
                    for (TransportStateListener listener : listeners) {
                        listener.connectionStateChanged(change);
                    }
                }
                catch (RuntimeException ex) {
                    logger.error("Exception in fireConnectionStateChanged: " + ex.getMessage(), ex);
                    if (!SNMP4JSettings.isForwardRuntimeExceptions()) break block8;
                    throw ex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<DatagramPacket> prepareOutPackets(UdpAddress targetAddress, byte[] message, TransportStateReference tmStateReference, DatagramSocket socket, long timeoutMillis, int maxRetries) throws IOException {
        ArrayList<DatagramPacket> packets;
        SocketEntry socketEntry;
        ByteBuffer outNet;
        InetSocketAddress targetSocketAddress;
        block16: {
            targetSocketAddress = new InetSocketAddress(targetAddress.getInetAddress(), targetAddress.getPort());
            outNet = ByteBuffer.allocate(65536);
            socketEntry = this.sockets.get(targetSocketAddress);
            packets = new ArrayList<DatagramPacket>(1);
            if (socketEntry == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Did not find any existing DTLS session for " + targetAddress)));
                }
                try {
                    socketEntry = new SocketEntry(targetAddress, true, tmStateReference);
                    this.sockets.put(targetSocketAddress, socketEntry);
                    Object object = socketEntry.outboundLock;
                    synchronized (object) {
                        HandshakeTask handshakeTask = new HandshakeTask(socketEntry, socket, targetSocketAddress, null, timeoutMillis, maxRetries);
                        handshakeTask.run();
                        break block16;
                    }
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Using existing DTLS session " + socketEntry.sessionID + " for sending packet to " + targetAddress)));
            }
        }
        ByteBuffer outApp = ByteBuffer.wrap(message);
        Object object = socketEntry.outboundLock;
        synchronized (object) {
            SSLEngineResult r = socketEntry.sslEngine.wrap(outApp, outNet);
            outNet.flip();
            SSLEngineResult.Status rs = r.getStatus();
            if (rs == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                throw new IOException("DTLSTM: Buffer overflow: incorrect server maximum fragment size");
            }
            if (rs == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                throw new IOException("DTLSTM: Buffer underflow during wrapping");
            }
            if (rs == SSLEngineResult.Status.CLOSED) {
                throw new IOException("DTLSTM: SSLEngine has closed");
            }
            if (outNet.hasRemaining()) {
                byte[] ba = new byte[outNet.remaining()];
                outNet.get(ba);
                DatagramPacket packet = new DatagramPacket(ba, ba.length, targetSocketAddress);
                packets.add(packet);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Prepared " + packets + " for " + targetAddress)));
        }
        return packets;
    }

    protected List<DatagramPacket> onReceiveTimeout(SSLEngine engine, SocketAddress socketAddr) throws IOException {
        SSLEngineResult.HandshakeStatus hs = engine.getHandshakeStatus();
        if (hs == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            return new ArrayList<DatagramPacket>();
        }
        return this.produceHandshakePackets(engine, socketAddr);
    }

    @Override
    public PKIXRevocationChecker getPKIXRevocationChecker() {
        return this.pkixRevocationChecker;
    }

    @Override
    public void setPKIXRevocationChecker(PKIXRevocationChecker pkixRevocationChecker) {
        this.pkixRevocationChecker = pkixRevocationChecker;
    }

    @Override
    public boolean isAsyncMsgProcessingSupported() {
        return true;
    }

    @Override
    public void setAsyncMsgProcessingSupported(boolean asyncMsgProcessingSupported) {
        if (!asyncMsgProcessingSupported) {
            throw new IllegalArgumentException("Async message processing cannot be disabled for DTLS");
        }
    }

    @Override
    protected void fireProcessMessage(DatagramPacket packet, ByteBuffer bis, TransportStateReference stateReference) {
        this.fireProcessMessage(new DtlsAddress(packet.getAddress(), packet.getPort()), bis, stateReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ByteBuffer prepareInPacket(DatagramPacket packet, byte[] buf, TransportStateReference tmStateReference) throws IOException {
        ByteBuffer inNetBuffer;
        Object handshakeEntry;
        Object e2;
        InetAddress peerAddress = packet.getAddress();
        InetSocketAddress peerSocketAddress = new InetSocketAddress(peerAddress, packet.getPort());
        SocketEntry entry = this.sockets.get(peerSocketAddress);
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Preparing inbound DTLS packet from " + peerSocketAddress)));
        }
        if (entry == null) {
            if (logger.isInfoEnabled()) {
                logger.info("New DTLS connection from " + peerSocketAddress + " using " + (this.isServerEnabled() ? "server" : "client") + " role");
            }
            try {
                entry = new SocketEntry(new DtlsAddress(peerAddress, packet.getPort()), !this.isServerEnabled(), tmStateReference);
            }
            catch (GeneralSecurityException e2) {
                throw new IOException("Failed to accept new DTLS connection from " + peerAddress + " due to: " + e2.getMessage(), e2);
            }
            e2 = entry.inboundLock;
            synchronized (e2) {
                SocketEntry otherEntry = this.sockets.get(peerSocketAddress);
                handshakeEntry = entry;
                if (otherEntry == null) {
                    this.sockets.put(peerSocketAddress, entry);
                    HandshakeTask handshakeTask = new HandshakeTask((SocketEntry)handshakeEntry, this.socket, peerSocketAddress, packet, 0L, 0);
                    this.dtlsHandshakeThreadPool.execute(handshakeTask);
                    return null;
                }
                entry = otherEntry;
            }
        }
        entry.used();
        if (!entry.isHandshakeFinished()) {
            logger.debug((Serializable)((Object)("Adding DTLS packet to handshake queue: " + packet)));
            e2 = entry;
            synchronized (e2) {
                entry.inboundPacketQueue.add(packet);
                entry.notify();
            }
        }
        ByteBuffer inAppBuffer = ByteBuffer.allocate(this.getMaxInboundMessageSize());
        handshakeEntry = entry.outboundLock;
        synchronized (handshakeEntry) {
            inNetBuffer = ByteBuffer.wrap(buf, 0, packet.getLength());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Read " + packet.getLength() + " bytes from " + peerSocketAddress)));
            logger.debug((Serializable)((Object)("DTLS inNetBuffer: " + inNetBuffer)));
        }
        if (inNetBuffer.hasRemaining()) {
            Object object = entry.inboundLock;
            synchronized (object) {
                SSLEngineResult result = entry.sslEngine.unwrap(inNetBuffer, inAppBuffer);
                switch (result.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        logger.error((Serializable)((Object)"DTLS BUFFER_OVERFLOW"));
                        throw new RuntimeException("DTLS BUFFER_OVERFLOW");
                    }
                }
                if (this.runDelegatedTasks(entry.sslEngine)) {
                    if (logger.isInfoEnabled()) {
                        logger.info("SSL session established for peer " + peerSocketAddress);
                    }
                    if (result.bytesProduced() > 0) {
                        inAppBuffer.flip();
                        logger.debug((Serializable)((Object)("SSL established, dispatching inappBuffer=" + inAppBuffer)));
                        entry.checkTransportStateReference(tmStateReference);
                        return inAppBuffer;
                    }
                }
            }
        }
        return null;
    }

    boolean runDelegatedTasks(SSLEngine engine) {
        Runnable runnable;
        while ((runnable = engine.getDelegatedTask()) != null) {
            runnable.run();
        }
        SSLEngineResult.HandshakeStatus hs = engine.getHandshakeStatus();
        return hs != SSLEngineResult.HandshakeStatus.NEED_TASK;
    }

    protected List<DatagramPacket> produceHandshakePackets(SSLEngine sslEngine, SocketAddress socketAddress) throws IOException {
        ArrayList<DatagramPacket> packets = new ArrayList<DatagramPacket>();
        boolean endLoops = false;
        int loops = 100;
        while (!endLoops) {
            if (--loops < 0) {
                throw new RuntimeException("Too much loops to produce handshake packets");
            }
            ByteBuffer oNet = ByteBuffer.allocate(this.getMaxInboundMessageSize());
            ByteBuffer oApp = ByteBuffer.allocate(0);
            SSLEngineResult r = sslEngine.wrap(oApp, oNet);
            oNet.flip();
            SSLEngineResult.Status rs = r.getStatus();
            SSLEngineResult.HandshakeStatus hs = r.getHandshakeStatus();
            if (rs == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                throw new IOException("Buffer overflow: incorrect server maximum fragment size");
            }
            if (rs == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                if (hs != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    throw new IOException("Buffer underflow: incorrect server maximum fragment size");
                }
            } else if (rs == SSLEngineResult.Status.CLOSED) {
                throw new IOException("SSLEngine has closed");
            }
            if (oNet.hasRemaining()) {
                byte[] ba = new byte[oNet.remaining()];
                oNet.get(ba);
                DatagramPacket packet = this.createHandshakePacket(ba, socketAddress);
                packets.add(packet);
            }
            boolean endInnerLoop = false;
            SSLEngineResult.HandshakeStatus nhs = hs;
            while (!endInnerLoop) {
                if (nhs == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.runDelegatedTasks(sslEngine);
                    nhs = sslEngine.getHandshakeStatus();
                    continue;
                }
                if (nhs == SSLEngineResult.HandshakeStatus.FINISHED || nhs == SSLEngineResult.HandshakeStatus.NEED_UNWRAP || nhs == SSLEngineResult.HandshakeStatus.NEED_UNWRAP_AGAIN || nhs == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    endInnerLoop = true;
                    endLoops = true;
                    continue;
                }
                if (nhs != SSLEngineResult.HandshakeStatus.NEED_WRAP) continue;
                endInnerLoop = true;
            }
        }
        return packets;
    }

    protected DatagramPacket createHandshakePacket(byte[] buf, SocketAddress socketAddr) {
        return new DatagramPacket(buf, buf.length, socketAddr);
    }

    public SSLEngineConfigurator getSslEngineConfigurator() {
        return this.sslEngineConfigurator;
    }

    public void setSslEngineConfigurator(SSLEngineConfigurator sslEngineConfigurator) {
        this.sslEngineConfigurator = sslEngineConfigurator;
    }

    protected SSLEngineConfigurator ensureSslEngineConfigurator() {
        if (this.sslEngineConfigurator == null) {
            this.sslEngineConfigurator = new DefaultSSLEngineConfiguration(this, this.trustManagerFactory, DEFAULT_DTLSTM_PROTOCOLS);
        }
        return this.sslEngineConfigurator;
    }

    private class DefaultDTLSTMTrustManagerFactory
    implements TLSTMTrustManagerFactory {
        private DefaultDTLSTMTrustManagerFactory() {
        }

        @Override
        public X509TrustManager create(X509TrustManager trustManager, boolean useClientMode, TransportStateReference tmStateReference) {
            return new TLSTMExtendedTrustManager(DTLSTM.this.counterSupport, DTLSTM.this.securityCallback, trustManager, useClientMode, tmStateReference);
        }
    }

    class SocketEntry
    extends AbstractServerSocket<UdpAddress> {
        private final SSLEngine sslEngine;
        private final long sessionID;
        private final TransportStateReference tmStateReference;
        private boolean handshakeFinished;
        private final Object outboundLock;
        private final Object inboundLock;
        private final LinkedList<DatagramPacket> inboundPacketQueue;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SocketEntry(UdpAddress address, boolean useClientMode, TransportStateReference tmStateReference) throws GeneralSecurityException {
            SSLEngineConfigurator sslEngineConfigurator;
            SSLContext sslContext;
            super(address);
            this.outboundLock = new Object();
            this.inboundLock = new Object();
            this.inboundPacketQueue = new LinkedList();
            this.tmStateReference = tmStateReference;
            if (tmStateReference == null) {
                DTLSTM.this.counterSupport.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionAccepts));
            }
            if ((sslContext = (sslEngineConfigurator = DTLSTM.this.ensureSslEngineConfigurator()).getSSLContext(useClientMode, tmStateReference)) == null) {
                throw new RuntimeException("Failed to initialize SSLContext");
            }
            this.sslEngine = sslContext.createSSLEngine(address.getInetAddress().getHostName(), address.getPort());
            this.sslEngine.setUseClientMode(useClientMode);
            this.sslEngine.setNeedClientAuth(true);
            SSLParameters parameters = this.sslEngine.getSSLParameters();
            parameters.setMaximumPacketSize(DTLSTM.this.getMaxInboundMessageSize());
            this.sslEngine.setSSLParameters(parameters);
            sslEngineConfigurator.configure(this.sslEngine);
            DTLSTM dTLSTM = DTLSTM.this;
            synchronized (dTLSTM) {
                this.sessionID = DTLSTM.this.nextSessionID++;
            }
        }

        public String toString() {
            return "SocketEntry[peerAddress=" + this.getPeerAddress() + ",socket=" + DTLSTM.this.socket + ",lastUse=" + new Date(this.getLastUse() / 1000000L) + "]";
        }

        public void checkTransportStateReference(TransportStateReference tmStateReference) {
            tmStateReference.setTransport(DTLSTM.this);
            if (tmStateReference.getTransportSecurityLevel().equals((Object)SecurityLevel.undefined)) {
                tmStateReference.setTransportSecurityLevel(SecurityLevel.authPriv);
            }
            OctetString securityName = tmStateReference.getSecurityName();
            if (DTLSTM.this.securityCallback != null) {
                try {
                    securityName = DTLSTM.this.securityCallback.getSecurityName((X509Certificate[])this.sslEngine.getSession().getPeerCertificates());
                }
                catch (SSLPeerUnverifiedException e) {
                    logger.error("SSL peer '" + this.getPeerAddress() + "' is not verified by security callback " + DTLSTM.this.securityCallback + " : " + e.getMessage(), e);
                    this.sslEngine.setEnableSessionCreation(false);
                }
            } else if (securityName == null) {
                logger.warn((Serializable)((Object)"No security callback configured to match DTLS peer certificate to local security name"));
            }
            tmStateReference.setSecurityName(securityName);
        }

        @Override
        public boolean isHandshakeFinished() {
            return this.handshakeFinished;
        }

        @Override
        public synchronized void setHandshakeFinished(boolean handshakeFinished) {
            this.handshakeFinished = handshakeFinished;
            this.notifyAll();
        }

        public long getSessionID() {
            return this.sessionID;
        }

        public void closeSession() {
            if (this.sslEngine.getSession().isValid()) {
                ByteBuffer outNetBuffer = ByteBuffer.allocate(DTLSTM.this.getMaxInboundMessageSize());
                try {
                    SSLEngineResult sslEngineResult;
                    do {
                        sslEngineResult = this.sslEngine.wrap(ByteBuffer.allocate(0), outNetBuffer);
                        outNetBuffer.flip();
                        DTLSTM.this.socket.send(new DatagramPacket(outNetBuffer.array(), outNetBuffer.limit(), ((UdpAddress)this.getPeerAddress()).getInetAddress(), ((UdpAddress)this.getPeerAddress()).getPort()));
                    } while (sslEngineResult.getStatus() != SSLEngineResult.Status.CLOSED && sslEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP);
                }
                catch (Exception e) {
                    logger.error("DTLSM: Exception while closing TLS session " + this + ": " + e.getMessage(), e);
                }
            }
            this.sslEngine.closeOutbound();
            DTLSTM.this.counterSupport.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionServerCloses));
            TransportStateEvent e = new TransportStateEvent(DTLSTM.this, (Address)this.getPeerAddress(), 4, null);
            DTLSTM.this.fireConnectionStateChanged(e);
        }
    }

    class HandshakeTask
    implements WorkerTask {
        private boolean endLoops = false;
        private final Object joinLock = new Object();
        private final SocketEntry socketEntry;
        private final DatagramSocket socket;
        private final SocketAddress peerAddr;
        private final DatagramPacket receivedPacket;
        private final long handshakeTimeout;
        private final int maxRetries;
        private int retries = 0;

        public HandshakeTask(SocketEntry socketEntry, DatagramSocket socket, SocketAddress peerAddr, DatagramPacket receivedPacket, long handshakeTimeout, int maxRetries) {
            this.socketEntry = socketEntry;
            this.socket = socket;
            this.peerAddr = peerAddr;
            this.receivedPacket = receivedPacket;
            this.handshakeTimeout = handshakeTimeout;
            this.maxRetries = maxRetries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.socketEntry.setHandshakeFinished(false);
            DatagramPacket received = this.receivedPacket;
            SSLEngine engine = this.socketEntry.sslEngine;
            engine.setEnableSessionCreation(true);
            int loops = 100;
            Buffer iNet = null;
            ByteBuffer iApp = null;
            UdpAddress peerAddress = (UdpAddress)this.socketEntry.getPeerAddress();
            InetSocketAddress peerSocketAddress = new InetSocketAddress(peerAddress.getInetAddress(), peerAddress.getPort());
            try {
                long timeoutMillis;
                engine.beginHandshake();
                long startTime = System.nanoTime();
                long l = timeoutMillis = this.handshakeTimeout <= 0L ? (long)DTLSTM.this.getHandshakeTimeout() : this.handshakeTimeout;
                while (!this.endLoops && !engine.isInboundDone() && DTLSTM.this.sockets.containsKey(peerSocketAddress) && (System.nanoTime() - startTime) / 1000000L < timeoutMillis) {
                    if (--loops < 0) {
                        this.stopLoops();
                        throw new IOException("DTLSTM: Too much loops to produce handshake packets");
                    }
                    SSLEngineResult.HandshakeStatus hs = engine.getHandshakeStatus();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Processing handshake status " + hs + " in loop #" + (100 - loops))));
                    }
                    SSLEngineResult.Status rs = null;
                    while (!(this.endLoops || hs != SSLEngineResult.HandshakeStatus.NEED_UNWRAP && hs != SSLEngineResult.HandshakeStatus.NEED_UNWRAP_AGAIN)) {
                        if (hs != SSLEngineResult.HandshakeStatus.NEED_UNWRAP_AGAIN) {
                            if (!(received != null || iNet != null && iNet.hasRemaining())) {
                                Object object;
                                if (DTLSTM.this.isListening()) {
                                    long timeout = timeoutMillis - (System.nanoTime() - startTime) / 1000000L;
                                    if (timeout > 0L) {
                                        object = this.socketEntry;
                                        synchronized (object) {
                                            try {
                                                if (this.socketEntry.inboundPacketQueue.isEmpty()) {
                                                    logger.debug((Serializable)((Object)("Waiting for next handshake packet timeout=" + timeout)));
                                                    this.socketEntry.wait(timeoutMillis);
                                                }
                                            }
                                            catch (InterruptedException interruptedException) {
                                                // empty catch block
                                            }
                                            if (engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                                                if (logger.isDebugEnabled()) {
                                                    logger.debug((Serializable)((Object)"Handshake finished already by other thread"));
                                                }
                                                return;
                                            }
                                            Object object2 = this.socketEntry.inboundLock;
                                            synchronized (object2) {
                                                received = (DatagramPacket)this.socketEntry.inboundPacketQueue.pollFirst();
                                                if (logger.isDebugEnabled() && received != null) {
                                                    logger.debug((Serializable)((Object)("Polled DTLS packet with length " + received.getLength())));
                                                }
                                            }
                                        }
                                    }
                                    this.stopLoops();
                                    if (received == null) {
                                        continue;
                                    }
                                } else {
                                    byte[] buf = new byte[DTLSTM.this.getMaxInboundMessageSize()];
                                    received = new DatagramPacket(buf, buf.length);
                                    try {
                                        this.socket.receive(received);
                                    }
                                    catch (SocketTimeoutException ste) {
                                        if (logger.isInfoEnabled()) {
                                            logger.info("Socket timeout while receiving DTLS handshake packet");
                                        }
                                        if (this.maxRetries > this.retries++) {
                                            object = this.socketEntry.outboundLock;
                                            synchronized (object) {
                                                List<DatagramPacket> packets = DTLSTM.this.onReceiveTimeout(engine, this.peerAddr);
                                                for (DatagramPacket p : packets) {
                                                    this.socket.send(p);
                                                    if (!logger.isDebugEnabled()) continue;
                                                    logger.debug((Serializable)((Object)("Sent " + new OctetString(p.getData()).toHexString() + " to " + p.getAddress() + ":" + p.getPort())));
                                                }
                                                break;
                                            }
                                        }
                                        this.stopLoops();
                                        break;
                                    }
                                }
                            }
                            if (received != null) {
                                if (iNet == null || !iNet.hasRemaining()) {
                                    iNet = ByteBuffer.wrap(received.getData(), 0, received.getLength());
                                } else {
                                    ((ByteBuffer)iNet).compact();
                                    ((ByteBuffer)iNet).put(received.getData(), 0, received.getLength());
                                    ((ByteBuffer)iNet).flip();
                                }
                            }
                            iApp = ByteBuffer.allocate(DTLSTM.this.getMaxInboundMessageSize());
                        } else {
                            iApp = ByteBuffer.allocate(DTLSTM.this.getMaxInboundMessageSize());
                        }
                        received = null;
                        Object object = this.socketEntry.inboundLock;
                        synchronized (object) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Serializable)((Object)("unrwap start: iNet=" + (ByteBuffer)iNet + ",iApp=" + iApp)));
                            }
                            SSLEngineResult r = engine.unwrap((ByteBuffer)iNet, iApp);
                            rs = r.getStatus();
                            hs = r.getHandshakeStatus();
                            if (logger.isDebugEnabled()) {
                                logger.debug((Serializable)((Object)("unrwap done: iNet=" + (ByteBuffer)iNet + ",iApp=" + iApp + ",rs=" + rs + ",hs=" + hs)));
                            }
                        }
                        if (rs == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                            throw new IOException("DTLSTM: Buffer overflow: incorrect client maximum fragment size");
                        }
                        if (rs == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                            logger.warn((Serializable)((Object)("DTLS buffer underflow iNet=" + (ByteBuffer)iNet + ",iApp=" + iApp)));
                            if (hs != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue;
                            this.stopLoops();
                            break;
                        }
                        if (rs == SSLEngineResult.Status.CLOSED) {
                            this.stopLoops();
                        }
                        if (rs == SSLEngineResult.Status.OK) continue;
                    }
                    if (hs == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                        Object object = this.socketEntry.outboundLock;
                        synchronized (object) {
                            List<DatagramPacket> packets = DTLSTM.this.produceHandshakePackets(engine, this.peerAddr);
                            for (DatagramPacket p : packets) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Serializable)((Object)("Sending handshake packet with length " + p.getLength() + " [" + new OctetString(p.getData()).toHexString() + "] to " + p.getAddress() + ":" + p.getPort())));
                                }
                                this.socket.send(p);
                            }
                            continue;
                        }
                    }
                    if (hs == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        DTLSTM.this.runDelegatedTasks(engine);
                        continue;
                    }
                    if (hs == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                        this.stopLoops();
                        continue;
                    }
                    if (hs != SSLEngineResult.HandshakeStatus.FINISHED) continue;
                    this.stopLoops();
                }
            }
            catch (IOException iox) {
                logger.error("DTLS handshake failed for " + this.peerAddr + " failed with IO exception:" + iox.getMessage(), iox);
            }
            SSLEngineResult.HandshakeStatus hs = engine.getHandshakeStatus();
            if (hs != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                DTLSTM.this.sockets.remove(peerSocketAddress);
                logger.error((Serializable)((Object)("DTLS handshake failed for " + this.peerAddr + ", status is " + hs + ": Not ready for application data yet, giving up")));
                this.socketEntry.closeSession();
            } else {
                this.socketEntry.setHandshakeFinished(true);
                if (logger.isInfoEnabled()) {
                    logger.info("SSL handshake completed for " + this.peerAddr);
                }
                DTLSTM.this.timeoutSocket(this.socketEntry);
                TransportStateEvent e = new TransportStateEvent(DTLSTM.this, (Address)this.socketEntry.getPeerAddress(), 1, null);
                DTLSTM.this.fireConnectionStateChanged(e);
            }
            this.stopLoops();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopLoops() {
            this.endLoops = true;
            Object object = this.joinLock;
            synchronized (object) {
                this.joinLock.notifyAll();
            }
        }

        @Override
        public void terminate() {
            this.endLoops = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void join() throws InterruptedException {
            Object object = this.joinLock;
            synchronized (object) {
                while (!this.endLoops) {
                    this.joinLock.wait(10L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void interrupt() {
            SocketEntry socketEntry = this.socketEntry;
            synchronized (socketEntry) {
                this.socketEntry.notify();
            }
        }
    }
}

