/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.AttributeKey;
import java.time.LocalTime;
import java.util.List;
import org.apache.plc4x.java.s7.readwrite.configuration.S7Configuration;
import org.apache.plc4x.java.s7.readwrite.protocol.S7HMux;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.events.ConnectEvent;
import org.apache.plc4x.java.spi.events.ConnectedEvent;
import org.apache.plc4x.java.spi.events.DisconnectEvent;
import org.apache.plc4x.java.spi.events.DisconnectedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class S7HMuxImpl
extends MessageToMessageCodec<ByteBuf, ByteBuf>
implements S7HMux {
    private static final Logger logger = LoggerFactory.getLogger(S7HMuxImpl.class);
    static final AttributeKey<Boolean> IS_CONNECTED = AttributeKey.valueOf((String)"IS_CONNECTED");
    static final AttributeKey<Boolean> WAS_CONNECTED = AttributeKey.valueOf((String)"WAS_CONNECTED");
    static final AttributeKey<Boolean> IS_PRIMARY = AttributeKey.valueOf((String)"IS_PRIMARY");
    static final AttributeKey<Integer> READ_TIME_OUT = AttributeKey.valueOf((String)"READ_TIME_OUT");
    static final AttributeKey<Boolean> IS_PING_ACTIVE = AttributeKey.valueOf((String)"IS_PIN_ACTIVE");
    static final AttributeKey<Integer> PING_TIME = AttributeKey.valueOf((String)"PING_TIME");
    static final AttributeKey<Integer> RETRY_TIME = AttributeKey.valueOf((String)"RETRY_TIME");
    ChannelHandlerContext embed_ctx = null;
    protected Channel embeded_channel = null;
    protected Channel tcp_channel = null;
    protected Channel primary_channel = null;
    protected Channel secondary_channel = null;

    protected void encode(ChannelHandlerContext ctx, ByteBuf outbb, List<Object> list) {
        if (this.embed_ctx == null && ctx.channel() instanceof EmbeddedChannel) {
            this.embed_ctx = ctx;
        }
        if (this.tcp_channel != null && this.embed_ctx == ctx) {
            this.tcp_channel.writeAndFlush((Object)outbb.copy());
        } else {
            list.add(outbb.copy());
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf inbb, List<Object> list) throws Exception {
        this.embed_ctx.fireChannelRead((Object)inbb.copy());
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        logger.debug("channelRegistered: " + ctx.name());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        logger.debug("exceptionCaught: " + ctx.name());
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        logger.debug("channelWritabilityChanged: " + ctx.name());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
        logger.info(LocalTime.now() + " userEventTriggered: " + ctx.name() + " Event: " + evt);
        if (evt instanceof ConnectedEvent) {
            try {
                this.tcp_channel.pipeline().remove("watchdog");
            }
            catch (Exception ex) {
                logger.info(ex.toString());
            }
            try {
                if ((Integer)this.embeded_channel.attr(READ_TIME_OUT).get() > 0 && ((Boolean)this.embeded_channel.attr(IS_PING_ACTIVE).get()).booleanValue()) {
                    this.tcp_channel.pipeline().addFirst("watchdog", (ChannelHandler)new ReadTimeoutHandler(((Integer)this.embeded_channel.attr(READ_TIME_OUT).get()).intValue()));
                }
                if (this.tcp_channel.isActive()) {
                    this.embeded_channel.attr(IS_CONNECTED).set((Object)true);
                } else {
                    this.embeded_channel.attr(IS_CONNECTED).set((Object)false);
                }
            }
            catch (Exception ex) {
                logger.info(ex.toString());
            }
        }
        if (evt instanceof DisconnectEvent) {
            logger.info("DisconnectEvent");
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        super.channelReadComplete(ctx);
        logger.debug(LocalTime.now() + " channelReadComplete: " + ctx.name());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        logger.debug("channelInactive: " + ctx.name());
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        logger.debug("channelActive: " + ctx.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        Channel channel;
        super.channelUnregistered(ctx);
        logger.debug(String.valueOf(LocalTime.now().toString()) + " channelUnregistered: " + ctx.name());
        String strCanal = this.tcp_channel == this.primary_channel ? "PRIMARY" : "SECONDARY";
        logger.info("Unregistered of channel: " + strCanal);
        if (ctx == this.embed_ctx) {
            return;
        }
        if (this.tcp_channel == ctx.channel()) {
            this.embeded_channel.attr(IS_CONNECTED).set((Object)false);
            this.embeded_channel.attr(WAS_CONNECTED).set((Object)true);
            this.embeded_channel.pipeline().fireUserEventTriggered((Object)new DisconnectedEvent());
        }
        logger.info(this.embed_ctx.executor().toString());
        if (this.tcp_channel == this.primary_channel && this.primary_channel == ctx.channel() && !this.primary_channel.isActive() && this.secondary_channel != null && this.secondary_channel.isActive()) {
            channel = this.tcp_channel;
            synchronized (channel) {
                logger.info("Using secondary TCP channel.");
                this.tcp_channel = this.secondary_channel;
                this.embeded_channel.attr(IS_PRIMARY).set((Object)false);
                this.embeded_channel.pipeline().fireUserEventTriggered((Object)new ConnectEvent());
            }
        }
        if (this.tcp_channel == this.secondary_channel && this.secondary_channel == ctx.channel() && !this.secondary_channel.isActive() && this.primary_channel != null && this.primary_channel.isActive()) {
            channel = this.tcp_channel;
            synchronized (channel) {
                logger.info("Using primary TCP channel.");
                this.tcp_channel = this.primary_channel;
                this.embeded_channel.attr(IS_PRIMARY).set((Object)true);
                this.embeded_channel.pipeline().fireUserEventTriggered((Object)new ConnectEvent());
            }
        }
    }

    @Override
    public void setEmbededhannel(Channel embeded_channel, PlcConnectionConfiguration configuration) {
        S7Configuration conf = (S7Configuration)configuration;
        this.embeded_channel = embeded_channel;
        this.embeded_channel.attr(IS_CONNECTED).set((Object)false);
        this.embeded_channel.attr(WAS_CONNECTED).set((Object)false);
        this.embeded_channel.attr(IS_PRIMARY).set((Object)true);
        this.embeded_channel.attr(READ_TIME_OUT).set((Object)conf.getReadTimeout());
        this.embeded_channel.attr(IS_PING_ACTIVE).set((Object)conf.getPing());
        this.embeded_channel.attr(PING_TIME).set((Object)conf.getPingTime());
        this.embeded_channel.attr(RETRY_TIME).set((Object)conf.getRetryTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPrimaryChannel(Channel primary_channel) {
        if (this.primary_channel == null && this.tcp_channel == null) {
            if (primary_channel != null) {
                this.primary_channel = primary_channel;
                this.tcp_channel = primary_channel;
                this.embeded_channel.attr(IS_PRIMARY).set((Object)true);
            }
        } else if (this.primary_channel == null || this.tcp_channel == this.secondary_channel && this.tcp_channel.isActive()) {
            this.primary_channel = primary_channel;
        } else if (!this.primary_channel.isActive() && this.tcp_channel == this.secondary_channel) {
            this.primary_channel = primary_channel;
        } else if (!this.primary_channel.isActive() && this.tcp_channel == this.primary_channel || primary_channel.isActive()) {
            Channel channel = this.tcp_channel;
            synchronized (channel) {
                this.tcp_channel.close();
                this.primary_channel = primary_channel;
                this.tcp_channel = primary_channel;
                this.embeded_channel.attr(IS_PRIMARY).set((Object)true);
                if (this.tcp_channel.isActive()) {
                    this.embed_ctx.fireUserEventTriggered((Object)new ConnectEvent());
                }
            }
        } else {
            primary_channel.isActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSecondaryChannel(Channel secondary_channel) {
        if (this.primary_channel == null && this.tcp_channel == null) {
            if (secondary_channel != null) {
                this.secondary_channel = secondary_channel;
                this.tcp_channel = secondary_channel;
                this.embeded_channel.attr(IS_PRIMARY).set((Object)false);
            }
        } else if (this.secondary_channel == null || this.tcp_channel == this.primary_channel && this.tcp_channel.isActive()) {
            this.secondary_channel = secondary_channel;
        } else if (!this.secondary_channel.isActive() && this.tcp_channel == this.primary_channel) {
            this.secondary_channel = secondary_channel;
        } else if (!this.secondary_channel.isActive() && this.tcp_channel == this.secondary_channel || secondary_channel.isActive()) {
            Channel channel = this.tcp_channel;
            synchronized (channel) {
                this.tcp_channel.close();
                this.secondary_channel = secondary_channel;
                this.tcp_channel = secondary_channel;
                this.embeded_channel.attr(IS_PRIMARY).set((Object)false);
            }
            if (this.tcp_channel.isActive()) {
                this.embed_ctx.fireUserEventTriggered((Object)new ConnectEvent());
            }
        }
    }

    @Override
    public Channel getTCPChannel() {
        return this.tcp_channel;
    }
}

