/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.optimizer;

import io.vavr.control.Either;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.plc4x.java.api.exceptions.PlcException;
import org.apache.plc4x.java.api.exceptions.PlcProtocolException;
import org.apache.plc4x.java.s7.readwrite.S7AddressAny;
import org.apache.plc4x.java.s7.readwrite.S7MessageRequest;
import org.apache.plc4x.java.s7.readwrite.S7MessageResponseData;
import org.apache.plc4x.java.s7.readwrite.S7Parameter;
import org.apache.plc4x.java.s7.readwrite.S7ParameterReadVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7ParameterReadVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7ParameterWriteVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7ParameterWriteVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadReadVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadWriteVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadWriteVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7VarRequestParameterItem;
import org.apache.plc4x.java.s7.readwrite.S7VarRequestParameterItemAddress;
import org.apache.plc4x.java.s7.readwrite.optimizer.S7MessageProcessor;

public class DefaultS7MessageProcessor
implements S7MessageProcessor {
    private final AtomicInteger tpduRefGen;
    public static final int EMPTY_READ_REQUEST_SIZE = new S7MessageRequest(0, new S7ParameterReadVarRequest(Collections.emptyList()), null).getLengthInBytes();
    public static final int EMPTY_READ_RESPONSE_SIZE = new S7MessageResponseData(0, new S7ParameterReadVarResponse(0), new S7PayloadReadVarResponse(Collections.emptyList()), 0, 0).getLengthInBytes();
    public static final int EMPTY_WRITE_REQUEST_SIZE = new S7MessageRequest(0, new S7ParameterWriteVarRequest(Collections.emptyList()), new S7PayloadWriteVarRequest(Collections.emptyList())).getLengthInBytes();
    public static final int EMPTY_WRITE_RESPONSE_SIZE = new S7MessageResponseData(0, new S7ParameterWriteVarResponse(0), new S7PayloadWriteVarResponse(Collections.emptyList()), 0, 0).getLengthInBytes();

    public DefaultS7MessageProcessor(AtomicInteger tpduGenerator) {
        this.tpduRefGen = tpduGenerator;
    }

    @Override
    public Collection<S7MessageRequest> processRequest(S7MessageRequest request, int pduSize) throws PlcException {
        S7Parameter parameter = request.getParameter();
        if (parameter instanceof S7ParameterReadVarRequest) {
            return this.processReadVarParameter(request, pduSize);
        }
        if (parameter instanceof S7ParameterWriteVarRequest) {
            return this.processWriteVarParameter(request, pduSize);
        }
        return Collections.singletonList(request);
    }

    private Collection<S7MessageRequest> processReadVarParameter(S7MessageRequest request, int pduSize) {
        S7ParameterReadVarRequest readVarParameter = (S7ParameterReadVarRequest)request.getParameter();
        LinkedList<S7MessageRequest> result = new LinkedList<S7MessageRequest>();
        int maxResponseSize = pduSize - EMPTY_READ_RESPONSE_SIZE;
        int curRequestSize = EMPTY_READ_REQUEST_SIZE;
        int curResponseSize = EMPTY_READ_RESPONSE_SIZE;
        LinkedList<S7VarRequestParameterItem> curRequestItems = new LinkedList<S7VarRequestParameterItem>();
        for (S7VarRequestParameterItem readVarParameterItem : readVarParameter.getItems()) {
            S7AddressAny address = (S7AddressAny)((S7VarRequestParameterItemAddress)readVarParameterItem).getAddress();
            int readRequestItemSize = readVarParameterItem.getLengthInBytes();
            int readResponseItemSize = 4 + address.getNumberOfElements() * address.getTransportSize().getSizeInBytes();
            if (readResponseItemSize % 2 == 1) {
                ++readResponseItemSize;
            }
            if (curRequestSize + readRequestItemSize > pduSize || curResponseSize + readResponseItemSize > pduSize) {
                S7MessageRequest subMessage = new S7MessageRequest((short)this.tpduRefGen.getAndIncrement(), new S7ParameterReadVarRequest(curRequestItems), null);
                result.add(subMessage);
                curRequestSize = EMPTY_READ_REQUEST_SIZE;
                curResponseSize = EMPTY_READ_RESPONSE_SIZE;
                curRequestItems = new LinkedList();
                S7VarRequestParameterItemAddress addressItem = (S7VarRequestParameterItemAddress)readVarParameterItem;
                if (!(addressItem.getAddress() instanceof S7AddressAny)) continue;
                S7AddressAny anyAddress = (S7AddressAny)addressItem.getAddress();
                int maxNumElements = (int)Math.floor((double)maxResponseSize / (double)anyAddress.getTransportSize().getSizeInBytes());
                int sizeMaxNumElementInBytes = maxNumElements * anyAddress.getTransportSize().getSizeInBytes();
                int remainingNumElements = anyAddress.getNumberOfElements();
                int curByteAddress = anyAddress.getByteAddress();
                while (remainingNumElements > 0) {
                    int numCurElements = Math.min(remainingNumElements, maxNumElements);
                    S7VarRequestParameterItemAddress subVarParameterItem = new S7VarRequestParameterItemAddress(new S7AddressAny(anyAddress.getTransportSize(), numCurElements, anyAddress.getDbNumber(), anyAddress.getArea(), curByteAddress, 0));
                    subMessage = new S7MessageRequest((short)this.tpduRefGen.getAndIncrement(), new S7ParameterReadVarRequest(Collections.singletonList(subVarParameterItem)), null);
                    result.add(subMessage);
                    remainingNumElements -= maxNumElements;
                    curByteAddress += sizeMaxNumElementInBytes;
                }
                continue;
            }
            curRequestSize += readRequestItemSize;
            curResponseSize += readResponseItemSize;
            curRequestItems.add(readVarParameterItem);
        }
        if (!curRequestItems.isEmpty()) {
            S7MessageRequest subMessage = new S7MessageRequest((short)this.tpduRefGen.getAndIncrement(), new S7ParameterReadVarRequest(curRequestItems), null);
            result.add(subMessage);
        }
        return result;
    }

    private Collection<S7MessageRequest> processWriteVarParameter(S7MessageRequest request, int pduSize) throws PlcProtocolException {
        return Collections.singletonList(request);
    }

    @Override
    public S7MessageResponseData processResponse(S7MessageRequest originalRequest, Map<S7MessageRequest, Either<S7MessageResponseData, Throwable>> result) {
        return null;
    }
}

