/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.s7.readwrite.COTPPacket;
import org.apache.plc4x.java.s7.readwrite.COTPParameter;
import org.apache.plc4x.java.s7.readwrite.S7Message;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class COTPPacketData
extends COTPPacket
implements Message {
    protected final boolean eot;
    protected final byte tpduRef;

    @Override
    public Short getTpduCode() {
        return (short)240;
    }

    public COTPPacketData(List<COTPParameter> parameters, S7Message payload, boolean eot, byte tpduRef) {
        super(parameters, payload);
        this.eot = eot;
        this.tpduRef = tpduRef;
    }

    public boolean getEot() {
        return this.eot;
    }

    public byte getTpduRef() {
        return this.tpduRef;
    }

    @Override
    protected void serializeCOTPPacketChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("COTPPacketData", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"eot", (Object)this.eot, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"tpduRef", (Object)this.tpduRef, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("COTPPacketData", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        COTPPacketData _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ++lengthInBits;
        return lengthInBits += 7;
    }

    public static COTPPacket.COTPPacketBuilder staticParseCOTPPacketBuilder(ReadBuffer readBuffer, Integer cotpLen) throws ParseException {
        readBuffer.pullContext("COTPPacketData", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        boolean eot = (Boolean)FieldReaderFactory.readSimpleField((String)"eot", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        byte tpduRef = (Byte)FieldReaderFactory.readSimpleField((String)"tpduRef", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)7), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("COTPPacketData", new WithReaderArgs[0]);
        return new COTPPacketDataBuilderImpl(eot, tpduRef);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof COTPPacketData)) {
            return false;
        }
        COTPPacketData that = (COTPPacketData)o;
        return this.getEot() == that.getEot() && this.getTpduRef() == that.getTpduRef() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getEot(), this.getTpduRef());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class COTPPacketDataBuilderImpl
    implements COTPPacket.COTPPacketBuilder {
        private final boolean eot;
        private final byte tpduRef;

        public COTPPacketDataBuilderImpl(boolean eot, byte tpduRef) {
            this.eot = eot;
            this.tpduRef = tpduRef;
        }

        @Override
        public COTPPacketData build(List<COTPParameter> parameters, S7Message payload) {
            COTPPacketData cOTPPacketData = new COTPPacketData(parameters, payload, this.eot, this.tpduRef);
            return cOTPPacketData;
        }
    }
}

