/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.cache;

import cn.afterturn.easypoi.cache.manager.POICacheManager;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import javax.swing.ImageIcon;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageCache.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getImage(String imagePath) {
        InputStream is = POICacheManager.getFile(imagePath);
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        try {
            int ch;
            while ((ch = is.read()) != -1) {
                swapStream.write(ch);
            }
            byte[] byArray = swapStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((Closeable)is);
            IOUtils.closeQuietly((Closeable)swapStream);
        }
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }
}

