/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal;

import io.opentelemetry.instrumentation.api.incubator.config.internal.InstrumentationConfig;
import io.opentelemetry.instrumentation.runtimemetrics.java17.RuntimeMetrics;
import io.opentelemetry.instrumentation.runtimemetrics.java17.RuntimeMetricsBuilder;
import javax.annotation.Nullable;

public final class RuntimeMetricsConfigUtil {
    private RuntimeMetricsConfigUtil() {
    }

    @Nullable
    public static RuntimeMetrics configure(RuntimeMetricsBuilder builder, InstrumentationConfig config) {
        boolean defaultEnabled = config.getBoolean("otel.instrumentation.common.default-enabled", true);
        if (config.getBoolean("otel.instrumentation.runtime-telemetry-java17.enable-all", false)) {
            builder.enableAllFeatures();
        } else if (!config.getBoolean("otel.instrumentation.runtime-telemetry-java17.enabled", false)) {
            if (config.getBoolean("otel.instrumentation.runtime-telemetry.enabled", defaultEnabled)) {
                builder.disableAllFeatures();
            } else {
                return null;
            }
        }
        if (config.getBoolean("otel.instrumentation.runtime-telemetry.emit-experimental-telemetry", false)) {
            builder.enableExperimentalJmxTelemetry();
        }
        return builder.build();
    }
}

