/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sequencing;

import org.eclipse.persistence.internal.sequencing.ClientSessionSequencing;
import org.eclipse.persistence.internal.sequencing.RemoteConnectionSequencing;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingHome;
import org.eclipse.persistence.internal.sequencing.SequencingManager;
import org.eclipse.persistence.internal.sequencing.SessionBrokerSequencing;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteConnection;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.server.ClientSession;

public class SequencingFactory {
    private SequencingFactory() {
    }

    public static Sequencing createSequencing(AbstractSession session) {
        SessionBroker br;
        Sequencing sequencing = null;
        if (session.isClientSession()) {
            ClientSession cs = (ClientSession)session;
            if (ClientSessionSequencing.sequencingServerExists(cs)) {
                sequencing = new ClientSessionSequencing(cs);
            }
        } else if (session.isRemoteSession()) {
            RemoteConnection con = ((DistributedSession)session).getRemoteConnection();
            if (RemoteConnectionSequencing.masterSequencingExists(con)) {
                sequencing = new RemoteConnectionSequencing(con);
            }
        } else if (session.isBroker() && SessionBrokerSequencing.atLeastOneSessionHasSequencing(br = (SessionBroker)session)) {
            sequencing = new SessionBrokerSequencing(br);
        }
        return sequencing;
    }

    public static SequencingHome createSequencingHome(DatabaseSessionImpl ownerSession) {
        SequencingManager home = null;
        if (!ownerSession.isBroker()) {
            home = new SequencingManager(ownerSession);
        }
        return home;
    }
}

