/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.util;

import com.vesoft.nebula.client.graph.data.CASignedSSLParam;
import com.vesoft.nebula.client.graph.data.SelfSignedSSLParam;
import java.io.FileReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocketFactory getSSLSocketFactoryWithCA(CASignedSSLParam param) {
        String caCrtFile = param.getCaCrtFilePath();
        String crtFile = param.getCrtFilePath();
        String keyFile = param.getKeyFilePath();
        String password = "";
        try {
            X509CertificateHolder certHolder;
            X509CertificateHolder caCertHolder;
            Object keyObject;
            Security.addProvider((Provider)new BouncyCastleProvider());
            try (PEMParser reader = null;){
                reader = new PEMParser((Reader)new FileReader(keyFile));
                keyObject = reader.readObject();
            }
            PEMDecryptorProvider provider = new JcePEMDecryptorProviderBuilder().build("".toCharArray());
            JcaPEMKeyConverter keyConverter = new JcaPEMKeyConverter().setProvider("BC");
            KeyPair key = keyObject instanceof PEMEncryptedKeyPair ? keyConverter.getKeyPair(((PEMEncryptedKeyPair)keyObject).decryptKeyPair(provider)) : keyConverter.getKeyPair((PEMKeyPair)keyObject);
            try {
                reader = new PEMParser((Reader)new FileReader(caCrtFile));
                caCertHolder = (X509CertificateHolder)reader.readObject();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter().setProvider("BC");
            KeyStore caKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            X509Certificate caCert = certificateConverter.getCertificate(caCertHolder);
            caKeyStore.load(null, null);
            caKeyStore.setCertificateEntry("ca-certificate", caCert);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(caKeyStore);
            try {
                reader = new PEMParser((Reader)new FileReader(crtFile));
                certHolder = (X509CertificateHolder)reader.readObject();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            KeyStore clientKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            X509Certificate cert = certificateConverter.getCertificate(certHolder);
            clientKeyStore.load(null, null);
            clientKeyStore.setCertificateEntry("certificate", cert);
            clientKeyStore.setKeyEntry("private-key", key.getPrivate(), "".toCharArray(), new Certificate[]{cert});
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(clientKeyStore, "".toCharArray());
            SSLContext context = SSLContext.getInstance("TLSv1.3");
            context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            return context.getSocketFactory();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocketFactory getSSLSocketFactoryWithoutCA(SelfSignedSSLParam param) {
        String crtFile = param.getCrtFilePath();
        String keyFile = param.getKeyFilePath();
        String password = param.getPassword();
        try {
            X509CertificateHolder certHolder;
            Object keyObject;
            Security.addProvider((Provider)new BouncyCastleProvider());
            try (PEMParser reader = null;){
                reader = new PEMParser((Reader)new FileReader(keyFile));
                keyObject = reader.readObject();
            }
            PEMDecryptorProvider provider = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
            JcaPEMKeyConverter keyConverter = new JcaPEMKeyConverter().setProvider("BC");
            KeyPair key = keyObject instanceof PEMEncryptedKeyPair ? keyConverter.getKeyPair(((PEMEncryptedKeyPair)keyObject).decryptKeyPair(provider)) : keyConverter.getKeyPair((PEMKeyPair)keyObject);
            JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter().setProvider("BC");
            try {
                reader = new PEMParser((Reader)new FileReader(crtFile));
                certHolder = (X509CertificateHolder)reader.readObject();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            X509Certificate cert = certificateConverter.getCertificate(certHolder);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setCertificateEntry("certificate", cert);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            KeyStore clientKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            clientKeyStore.load(null, null);
            clientKeyStore.setCertificateEntry("certificate", cert);
            clientKeyStore.setKeyEntry("private-key", key.getPrivate(), password.toCharArray(), new Certificate[]{cert});
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(clientKeyStore, password.toCharArray());
            SSLContext context = SSLContext.getInstance("TLSv1.3");
            context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            return context.getSocketFactory();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return null;
        }
    }
}

